/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.mylyn.docs.epub.core.ValidationMessage;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OPS2Validator
extends DefaultHandler {
    private StringBuilder contents = null;
    private final ArrayList<ValidationMessage> messages;
    private StringBuilder buffer = null;
    private final String[] legalAttributes = new String[]{"accesskey", "charset", "class", "coords", "dir", "href", "hreflang", "id", "rel", "rev", "shape", "style", "tabindex", "target", "title", "type", "xml:lang", "xmlns", "src", "alt"};
    private final String[] legalElements = new String[]{"body", "head", "html", "title", "abbr", "acronym", "address", "blockquote", "br", "cite", "code", "dfn", "div", "em", "h1", "h2", "h3", "h4", "h5", "h6", "kbd", "p", "pre", "q", "samp", "span", "strong", "var", "a", "dl", "dt", "dd", "ol", "ul", "li", "object", "param", "b", "big", "hr", "i", "small", "sub", "sup", "tt", "del", "ins", "bdo", "caption", "col", "colgroup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "img", "area", "map", "style", "link", "base"};
    private Mode mode = Mode.WARN;
    private final String[] passthroughElements = new String[]{"meta"};
    private boolean recording = false;
    private final String href;

    public StringBuilder getContents() {
        return this.contents;
    }

    public ArrayList<ValidationMessage> getMessages() {
        return this.messages;
    }

    public static List<ValidationMessage> validate(InputSource file, String href) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXParser parser = factory.newSAXParser();
        OPS2Validator tocGenerator = new OPS2Validator(href, Mode.WARN);
        try {
            parser.parse(file, (DefaultHandler)tocGenerator);
            return tocGenerator.getMessages();
        }
        catch (SAXException e) {
            System.err.println("Could not parse " + href);
            e.printStackTrace();
            return null;
        }
    }

    public static String clean(InputSource file, String href) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SAXParser parser = factory.newSAXParser();
        OPS2Validator tocGenerator = new OPS2Validator(href, Mode.REMOVE);
        try {
            parser.parse(file, (DefaultHandler)tocGenerator);
            return tocGenerator.getContents().toString();
        }
        catch (SAXException e) {
            System.err.println("Could not parse " + href);
            e.printStackTrace();
            return null;
        }
    }

    public OPS2Validator(String href, Mode mode) {
        this.href = href;
        this.buffer = new StringBuilder();
        this.contents = new StringBuilder();
        this.messages = new ArrayList();
        this.mode = mode;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recording) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isLegalElement(qName)) {
            this.contents.append((CharSequence)this.buffer);
            this.contents.append("</" + qName + ">");
            this.buffer.setLength(0);
        }
        this.recording = false;
    }

    private boolean isLegalAttribute(String name) {
        String[] stringArray = this.legalAttributes;
        int n = this.legalAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String legal = stringArray[n2];
            if (name.equalsIgnoreCase(legal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isLegalElement(String name) {
        String[] stringArray = this.legalElements;
        int n = this.legalElements.length;
        int n2 = 0;
        while (n2 < n) {
            String legal = stringArray[n2];
            if (name.equalsIgnoreCase(legal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isPassthroughElement(String name) {
        String[] stringArray = this.passthroughElements;
        int n = this.passthroughElements.length;
        int n2 = 0;
        while (n2 < n) {
            String legal = stringArray[n2];
            if (name.equalsIgnoreCase(legal)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isPassthroughElement(qName)) {
            this.contents.append('<');
            this.contents.append(qName);
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getQName(i);
                this.contents.append(' ');
                this.contents.append(name);
                this.contents.append("=\"");
                this.contents.append(attributes.getValue(i));
                this.contents.append("\"");
                ++i;
            }
            this.contents.append('>');
            this.recording = true;
        } else if (this.mode.equals((Object)Mode.WARN) || this.isLegalElement(qName)) {
            this.contents.append('<');
            this.contents.append(qName);
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getQName(i);
                if (this.mode.equals((Object)Mode.WARN) || this.isLegalAttribute(name)) {
                    this.contents.append(' ');
                    this.contents.append(name);
                    this.contents.append("=\"");
                    this.contents.append(attributes.getValue(i));
                    this.contents.append("\"");
                    if (!this.isLegalAttribute(name)) {
                        this.messages.add(new ValidationMessage(ValidationMessage.Severity.WARNING, MessageFormat.format("Attribute \"{0}\" in {1} is not in OPS Preferred Vocabularies", name, this.href)));
                    }
                }
                ++i;
            }
            this.contents.append('>');
            this.recording = true;
            if (!this.isLegalElement(qName)) {
                this.messages.add(new ValidationMessage(ValidationMessage.Severity.WARNING, MessageFormat.format("Element \"{0}\" in {1} is not in OPS Preferred Vocabularies", qName, this.href)));
            }
        }
    }

    public static enum Mode {
        REMOVE,
        WARN;

    }
}

