/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui.util;

import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.ConfigurationBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.BugzillaGeneratedCommentBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.BugzillaQuoteBlock;

public class Util {
    private static final String TASKTOP_TASKZILLA = "taskzilla";
    private static final String TASKTOP_ALM = "com.tasktop.alm.tasks";
    private static final String BUGZILLA = "bugzilla";

    public static MarkupLanguageConfiguration create(String repositoryKind) {
        ConfigurationBuilder builder = ConfigurationBuilder.create().repositorySettings();
        if (Util.isBugzillaOrDerivative(repositoryKind)) {
            builder.block((Block)new BugzillaQuoteBlock()).block((Block)new BugzillaGeneratedCommentBlock());
        }
        return builder.configuration();
    }

    private static boolean isBugzillaOrDerivative(String repositoryKind) {
        return BUGZILLA.equals(repositoryKind) || TASKTOP_ALM.equals(repositoryKind) || TASKTOP_TASKZILLA.equals(repositoryKind);
    }
}

