/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class ScheduledPresentationTest
extends TestCase {
    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskList();
        TasksUiPlugin.getExternalizationManager().requestSave();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskList();
        TasksUiPlugin.getExternalizationManager().requestSave();
    }

    public void testWeekStartChange() {
        TaskListInterestFilter filter = new TaskListInterestFilter();
        TasksUiPlugin.getTaskActivityManager().setWeekStartDay(2);
        DateRange lastDay = TaskActivityUtil.getCurrentWeek().getDayOfWeek(1);
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task1, lastDay);
        ScheduledPresentationTest.assertTrue((boolean)filter.isInterestingForThisWeek(null, (AbstractTask)task1));
        TasksUiPlugin.getTaskActivityManager().setWeekStartDay(1);
        ScheduledPresentationTest.assertFalse((boolean)filter.isInterestingForThisWeek(null, (AbstractTask)task1));
    }

    public void testScheduledDisplayed() {
        DayDateRange lastDay = TaskActivityUtil.getDayOf((Date)TaskActivityUtil.getEndOfCurrentWeek().getTime());
        LocalTask task1 = new LocalTask("task 1", "Task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)task1, (DateRange)lastDay);
        TaskRepository repository = new TaskRepository("mock", "http://mockrepository.test");
        repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("testuser", "testpassword"), false);
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        MockTask mockTask = new MockTask("http://mockrepository.test", "123", "mock task");
        mockTask.setOwner("anotheruser");
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)mockTask, (DateRange)TaskActivityUtil.getCurrentWeek());
        TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)mockTask, TaskActivityUtil.getCalendar().getTime());
        TasksUiPlugin.getTaskList().addTask((ITask)mockTask);
        HashMap<ITask, ScheduledTaskContainer> results = new HashMap<ITask, ScheduledTaskContainer>();
        results.put((ITask)mockTask, (ScheduledTaskContainer)null);
        results.put((ITask)task1, (ScheduledTaskContainer)null);
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((String)"This Week", (String)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary());
        ScheduledPresentationTest.assertNotNull(results.get(task1));
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)mockTask, (DateRange)TaskActivityUtil.getNextWeek());
        mockTask.setSynchronizationState(ITask.SynchronizationState.INCOMING);
        results.put((ITask)mockTask, null);
        results.put((ITask)task1, null);
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((String)"Next Week", (String)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary());
        ScheduledPresentationTest.assertNotNull(results.get(task1));
        results.put((ITask)mockTask, null);
        results.put((ITask)task1, null);
        this.populateResults(results, true);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((String)"Incoming", (String)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary());
        ScheduledPresentationTest.assertNotNull(results.get(task1));
        results.put((ITask)mockTask, null);
        results.put((ITask)task1, null);
        mockTask.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)mockTask, TaskActivityUtil.getNextWeek().getDayOfWeek(3).getStartDate().getTime());
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((String)"Next Week", (String)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary());
        results.put((ITask)mockTask, null);
        results.put((ITask)task1, null);
        DayDateRange dayDateRange = TaskActivityUtil.getDayOf((Date)new Date(86400000L));
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)mockTask, (DateRange)dayDateRange);
        mockTask.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        results.put((ITask)mockTask, null);
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertTrue((boolean)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary().contains("Today"));
        results.put((ITask)mockTask, null);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)mockTask, TaskActivityUtil.getNextWeek().getDayOfWeek(3));
        mockTask.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((Object)TaskActivityUtil.getNextWeek().getDayOfWeek(3), (Object)((ScheduledTaskContainer)results.get((Object)mockTask)).getDateRange());
        results.put((ITask)mockTask, null);
        mockTask.setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
        this.populateResults(results, true);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertEquals((String)"Incoming", (String)((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary());
        mockTask.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
        TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)mockTask, TaskActivityUtil.getNextWeek().getDayOfWeek(3).getStartDate().getTime());
        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)mockTask, (DateRange)TaskActivityUtil.getNextWeek());
        mockTask.setOwner("testuser");
        results.put((ITask)mockTask, null);
        results.put((ITask)task1, null);
        this.populateResults(results, false);
        ScheduledPresentationTest.assertNotNull((String)"Task scheduled but not visible in scheduled presentation", results.get((Object)mockTask));
        ScheduledPresentationTest.assertFalse((boolean)"Next Week".equals(((ScheduledTaskContainer)results.get((Object)mockTask)).getSummary()));
    }

    private void populateResults(Map<ITask, ScheduledTaskContainer> results, boolean focused) {
        TaskListView.getFromActivePerspective().setFocusedMode(focused);
        TaskScheduleContentProvider provider = new TaskScheduleContentProvider(TaskListView.getFromActivePerspective());
        Object[] bins = provider.getElements((Object)TaskListView.getFromActivePerspective().getViewSite());
        TaskListInterestFilter filter = new TaskListInterestFilter();
        Object[] objectArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!focused || filter.select(null, object)) {
                for (ITask task : ((ScheduledTaskContainer)object).getChildren()) {
                    if (!results.containsKey(task)) continue;
                    results.put(task, (ScheduledTaskContainer)object);
                }
            }
            ++n2;
        }
        if (focused) {
            TaskListView.getFromActivePerspective().setFocusedMode(!focused);
        }
    }
}

