/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoriesExternalizerTest
extends TestCase {
    private Set<TaskRepository> taskRepositories = new HashSet<TaskRepository>();
    private static final String REP_TYPE = "bugzilla";
    private static final String REPURL1 = "http://somewhere1";
    private static final String REPURL2 = "http://somewhere2";
    private static final String TIMEZONE = "test time zone";
    private static final String VERSION = "test version";
    private static final String ENCODING = "test encoding";
    private static final String TIMESTAMP = "test time stamp";
    private static final String SUFFIX = "2";
    private TaskRepository repository1;
    private TaskRepository repository2;

    protected void setUp() throws Exception {
        this.repository1 = new TaskRepository(REP_TYPE, REPURL1);
        this.repository2 = new TaskRepository(REP_TYPE, REPURL2);
        this.repository1.setTimeZoneId(TIMEZONE);
        this.repository1.setVersion(VERSION);
        this.repository1.setCharacterEncoding(ENCODING);
        this.repository1.setSynchronizationTimeStamp(TIMESTAMP);
        this.taskRepositories.add(this.repository1);
        this.repository2.setTimeZoneId("test time zone2");
        this.repository2.setVersion("test version2");
        this.repository2.setCharacterEncoding("test encoding2");
        this.repository2.setSynchronizationTimeStamp("test time stamp2");
        this.taskRepositories.add(this.repository2);
    }

    public void testExternalization() {
        TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();
        String path = "repositories.xml";
        File file = new File(path);
        file.deleteOnExit();
        externalizer.writeRepositoriesToXML(this.taskRepositories, file);
        this.taskRepositories.clear();
        TaskRepositoriesExternalizerTest.assertEquals((int)0, (int)this.taskRepositories.size());
        this.taskRepositories = externalizer.readRepositoriesFromXML(file);
        TaskRepositoriesExternalizerTest.assertEquals((int)2, (int)this.taskRepositories.size());
        this.taskRepositories.contains(this.repository1);
        this.taskRepositories.contains(this.repository2);
        for (TaskRepository repository : this.taskRepositories) {
            if (repository.getRepositoryUrl().equals(REPURL1)) {
                TaskRepositoriesExternalizerTest.assertEquals((String)TIMEZONE, (String)repository.getTimeZoneId());
                TaskRepositoriesExternalizerTest.assertEquals((String)VERSION, (String)repository.getVersion());
                TaskRepositoriesExternalizerTest.assertEquals((String)ENCODING, (String)repository.getCharacterEncoding());
                TaskRepositoriesExternalizerTest.assertEquals((String)TIMESTAMP, (String)repository.getSynchronizationTimeStamp());
                continue;
            }
            if (!repository.getRepositoryUrl().equals(REPURL2)) continue;
            TaskRepositoriesExternalizerTest.assertEquals((String)"test time zone2", (String)repository.getTimeZoneId());
            TaskRepositoriesExternalizerTest.assertEquals((String)"test version2", (String)repository.getVersion());
            TaskRepositoriesExternalizerTest.assertEquals((String)"test encoding2", (String)repository.getCharacterEncoding());
            TaskRepositoriesExternalizerTest.assertEquals((String)"test time stamp2", (String)repository.getSynchronizationTimeStamp());
        }
    }

    public void testExternalizationEmptyRepository() {
        TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();
        String path = "repositories.xml";
        File file = new File(path);
        file.deleteOnExit();
        externalizer.writeRepositoriesToXML(this.taskRepositories, file);
        this.taskRepositories = externalizer.readRepositoriesFromXML(file);
        TaskRepositoriesExternalizerTest.assertEquals((int)2, (int)this.taskRepositories.size());
        this.taskRepositories.clear();
        externalizer.writeRepositoriesToXML(this.taskRepositories, file);
        this.taskRepositories = externalizer.readRepositoriesFromXML(file);
        TaskRepositoriesExternalizerTest.assertEquals((int)0, (int)this.taskRepositories.size());
    }
}

