/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryCredentialsTest
extends TestCase {
    public void testPlatformAuthHandlerAvailable() throws Exception {
        URL url = new URL("http://mylyn");
        Platform.addAuthorizationInfo((URL)url, (String)"", (String)"", (Map)Collections.EMPTY_MAP);
        TaskRepositoryCredentialsTest.assertNotNull((String)"Tests require org.eclipse.core.runtime.compatibility.auth", (Object)Platform.getAuthorizationInfo((URL)url, (String)"", (String)""));
    }

    public void testLabel() {
        TaskRepository repository = new TaskRepository("kind", "http://foo.bar");
        TaskRepositoryCredentialsTest.assertTrue((boolean)repository.getRepositoryLabel().equals(repository.getRepositoryUrl()));
        repository.setProperty("label", "label");
        TaskRepositoryCredentialsTest.assertTrue((boolean)repository.getRepositoryLabel().equals("label"));
    }

    public void testPassword() throws Exception {
        this.password(AuthenticationType.REPOSITORY);
        TaskRepository taskRepository = new TaskRepository("kind", "http://url");
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)taskRepository.getUserName());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)taskRepository.getPassword());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getHttpPassword());
    }

    public void testHttpPassword() throws Exception {
        this.password(AuthenticationType.HTTP);
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("user", "pwd"), true);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)taskRepository.getHttpPassword());
    }

    public void testProxyPassword() throws Exception {
        this.password(AuthenticationType.PROXY);
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.PROXY, new AuthenticationCredentials("user", "pwd"), false);
        TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)taskRepository.getProxyUsername());
        TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)taskRepository.getProxyPassword());
    }

    public void testFlushCredentials() throws Exception {
        TaskRepository taskRepository = new TaskRepository("kind", "url");
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials("user", "pwd"), false);
        taskRepository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("user", "pwd"), true);
        taskRepository.flushAuthenticationCredentials();
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getUserName());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getPassword());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getHttpUser());
        TaskRepositoryCredentialsTest.assertEquals(null, (String)taskRepository.getHttpPassword());
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.REPOSITORY));
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.HTTP));
        TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(AuthenticationType.PROXY));
    }

    public void testPlatformIsRunning() {
        TaskRepositoryCredentialsTest.assertTrue((boolean)Platform.isRunning());
    }

    public void password(AuthenticationType authType) throws Exception {
        URL url = new URL("http://url");
        TaskRepository taskRepository = new TaskRepository("kind", url.toString());
        try {
            taskRepository.flushAuthenticationCredentials();
            TaskRepositoryCredentialsTest.assertNull((Object)taskRepository.getCredentials(authType));
            TaskRepositoryCredentialsTest.assertTrue((boolean)taskRepository.getSavePassword(authType));
            taskRepository.setCredentials(authType, new AuthenticationCredentials("user", "pwd"), true);
            AuthenticationCredentials credentials = taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd", (String)credentials.getPassword());
            Map map = Platform.getAuthorizationInfo((URL)url, (String)"", (String)"Basic");
            TaskRepositoryCredentialsTest.assertNotNull((Object)map);
            TaskRepositoryCredentialsTest.assertTrue((boolean)map.containsValue("user"));
            TaskRepositoryCredentialsTest.assertTrue((boolean)map.containsValue("pwd"));
            taskRepository.setCredentials(authType, new AuthenticationCredentials("user1", "pwd1"), false);
            TaskRepositoryCredentialsTest.assertFalse((boolean)taskRepository.getSavePassword(authType));
            credentials = taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user1", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd1", (String)credentials.getPassword());
            map = Platform.getAuthorizationInfo((URL)url, (String)"", (String)"Basic");
            TaskRepositoryCredentialsTest.assertNotNull((Object)map);
            TaskRepositoryCredentialsTest.assertTrue((boolean)map.containsValue("user1"));
            TaskRepositoryCredentialsTest.assertFalse((boolean)map.containsValue("pwd1"));
            TaskRepositoryCredentialsTest.assertFalse((boolean)map.containsValue("user"));
            TaskRepositoryCredentialsTest.assertFalse((boolean)map.containsValue("pwd"));
            taskRepository.setCredentials(authType, new AuthenticationCredentials("user2", "pwd2"), true);
            TaskRepositoryCredentialsTest.assertTrue((boolean)taskRepository.getSavePassword(authType));
            credentials = taskRepository.getCredentials(authType);
            TaskRepositoryCredentialsTest.assertNotNull((Object)credentials);
            TaskRepositoryCredentialsTest.assertEquals((String)"user2", (String)credentials.getUserName());
            TaskRepositoryCredentialsTest.assertEquals((String)"pwd2", (String)credentials.getPassword());
        }
        finally {
            taskRepository.flushAuthenticationCredentials();
        }
    }

    public void testConfigUpdateStoring() throws Exception {
        URL url = new URL("http://url");
        TaskRepository taskRepository = new TaskRepository("kind", url.toString());
        Date stamp = taskRepository.getConfigurationDate();
        TaskRepositoryCredentialsTest.assertNull((String)"unset configuration date returns null", (Object)stamp);
        stamp = new Date();
        stamp.setTime(stamp.getTime() - 35000L);
        taskRepository.setConfigurationDate(stamp);
        TaskRepositoryCredentialsTest.assertEquals((String)"Time stamp set", (long)stamp.getTime(), (long)taskRepository.getConfigurationDate().getTime());
    }
}

