/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositorySorterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCategorySorting() {
        TaskRepositoriesSorter sorter = new TaskRepositoriesSorter();
        TaskRepository t1 = new TaskRepository("t1", "http://a");
        TaskRepository t2 = new TaskRepository("t2", "http://a");
        TaskRepository t3 = new TaskRepository("t3", "http://a");
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t1, (Object)t2) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t3, (Object)t1) > 0 ? 1 : 0) != 0);
    }

    public void testUrlSorting() {
        TaskRepositoriesSorter sorter = new TaskRepositoriesSorter();
        TaskRepository t1 = new TaskRepository("t", "http://a");
        TaskRepository t2 = new TaskRepository("t", "http://b");
        TaskRepository t3 = new TaskRepository("t", "http://c");
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t1, (Object)t2) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t2, (Object)t3) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t3, (Object)t1) > 0 ? 1 : 0) != 0);
    }

    public void testUrlSortingWithEmptyLabels() {
        TaskRepositoriesSorter sorter = new TaskRepositoriesSorter();
        TaskRepository t1 = new TaskRepository("t", "http://a");
        t1.setProperty("label", "");
        TaskRepository t2 = new TaskRepository("t", "http://b");
        t2.setProperty("label", "");
        TaskRepository t3 = new TaskRepository("t", "http://c");
        t3.setProperty("label", "");
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t1, (Object)t2) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t2, (Object)t3) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t3, (Object)t1) > 0 ? 1 : 0) != 0);
    }

    public void testLabelSorting() {
        TaskRepositoriesSorter sorter = new TaskRepositoriesSorter();
        TaskRepository t1 = new TaskRepository("kind", "http://a");
        t1.setProperty("label", "a");
        TaskRepository t2 = new TaskRepository("kind", "http://a");
        t2.setProperty("label", "b");
        TaskRepository t3 = new TaskRepository("kind", "http://a");
        t3.setProperty("label", "c");
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t1, (Object)t2) < 0 ? 1 : 0) != 0);
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t3, (Object)t1) > 0 ? 1 : 0) != 0);
    }

    public void testLabelVsNoLabel() {
        TaskRepositoriesSorter sorter = new TaskRepositoriesSorter();
        TaskRepository t1 = new TaskRepository("kind", "http://a");
        t1.setProperty("label", "a");
        TaskRepository t2 = new TaskRepository("kind", "http://a");
        TaskRepositorySorterTest.assertTrue((sorter.compare(null, (Object)t1, (Object)t2) < 0 ? 1 : 0) != 0);
    }
}

