/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.operations;

import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;

public class PublishRequest
extends AbstractRequest<Object> {
    int patchSetId;
    String reviewId;
    Set<ApprovalCategoryValue.Id> approvals;

    public PublishRequest(String reviewId, int patchSetId, Set<ApprovalCategoryValue.Id> approvals) {
        Assert.isNotNull((Object)reviewId);
        this.reviewId = reviewId;
        this.patchSetId = patchSetId;
        this.approvals = Collections.unmodifiableSet(new HashSet<ApprovalCategoryValue.Id>(approvals));
    }

    public int getPatchSetId() {
        return this.patchSetId;
    }

    public String getReviewId() {
        return this.reviewId;
    }

    public Set<ApprovalCategoryValue.Id> getApprovals() {
        return this.approvals;
    }

    @Override
    protected Object execute(GerritClient client, IProgressMonitor monitor) throws GerritException {
        client.publishComments(this.getReviewId(), this.getPatchSetId(), this.getMessage(), this.getApprovals(), monitor);
        return null;
    }
}

