/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import com.google.gerrit.reviewdb.PatchSetApproval;
import com.google.gerrit.reviewdb.UserIdentity;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SubmitRecord;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.internal.gerrit.core.remote.PatchSetDetailRemoteFactory;
import org.eclipse.mylyn.reviews.core.model.IApprovalType;
import org.eclipse.mylyn.reviews.core.model.IChange;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IRequirementEntry;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewerEntry;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.model.RequirementStatus;
import org.eclipse.mylyn.reviews.core.model.ReviewStatus;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.review.ReviewRemoteFactory;

public class GerritReviewRemoteFactory
extends ReviewRemoteFactory<GerritChange, String> {
    public GerritReviewRemoteFactory(GerritRemoteFactoryProvider gerritRemoteFactoryProvider) {
        super((AbstractRemoteEmfFactoryProvider)gerritRemoteFactoryProvider);
    }

    protected IReview open(IRepository parentObject, String localKey) {
        return (IReview)this.getGerritProvider().open(localKey);
    }

    public boolean isPullNeeded(IRepository parent, IReview review, GerritChange remote) {
        return true;
    }

    public GerritChange pull(IRepository parent, String remoteKey, IProgressMonitor monitor) throws CoreException {
        try {
            this.getGerritProvider().getClient().refreshConfigOnce((IProgressMonitor)new NullProgressMonitor());
            GerritChange gerritChange = this.getGerritProvider().getClient().getChange(remoteKey, monitor);
            ChangeDetailX detail = gerritChange.getChangeDetail();
            this.getGerritProvider().pullUser(parent, detail.getAccounts(), detail.getChange().getOwner(), monitor);
            for (ChangeMessage message : detail.getMessages()) {
                if (message.getAuthor() == null) continue;
                this.getGerritProvider().pullUser(parent, detail.getAccounts(), message.getAuthor(), monitor);
            }
            for (PatchSetDetail patchSetDetail : gerritChange.getPatchSetDetails()) {
                this.getGerritProvider().pullUser(parent, detail.getAccounts(), patchSetDetail.getInfo().getAuthor().getAccount(), monitor);
                this.getGerritProvider().pullUser(parent, detail.getAccounts(), patchSetDetail.getInfo().getCommitter().getAccount(), monitor);
            }
            for (ApprovalDetail remoteApproval : detail.getApprovals()) {
                this.getGerritProvider().pullUser(parent, detail.getAccounts(), remoteApproval.getAccount(), monitor);
            }
            if (detail.getSubmitRecords() != null) {
                for (SubmitRecord record : detail.getSubmitRecords()) {
                    for (SubmitRecord.Label label : record.getLabels()) {
                        if (label.getAppliedBy() == null) continue;
                        this.getGerritProvider().pullUser(parent, detail.getAccounts(), label.getAppliedBy(), monitor);
                    }
                }
            }
            this.pull(parent, detail, detail.getDependsOn(), monitor);
            this.pull(parent, detail, detail.getNeededBy(), monitor);
            return gerritChange;
        }
        catch (GerritException e) {
            throw GerritCorePlugin.getDefault().getConnector().toCoreException(parent.getTaskRepository(), "Problem while retrieving Gerrit review.", e);
        }
    }

    protected void pull(IRepository parent, ChangeDetailX detail, List<ChangeInfo> remoteChanges, IProgressMonitor monitor) throws CoreException {
        for (ChangeInfo remoteChange : remoteChanges) {
            AccountInfo remoteOwner = detail.getAccounts().get(remoteChange.getOwner());
            this.getGerritProvider().pullUser(parent, detail.getAccounts(), remoteOwner.getId(), monitor);
        }
    }

    public boolean isCreateModelNeeded(IRepository parentObject, IReview modelObject) {
        return super.isCreateModelNeeded((EObject)parentObject, (Object)modelObject) || modelObject.getModificationDate() == null;
    }

    public IReview createModel(IRepository parent, GerritChange gerritChange) {
        ChangeDetailX detail = gerritChange.getChangeDetail();
        Change change = detail.getChange();
        IReview review = (IReview)this.getGerritProvider().open(this.getLocalKeyForRemoteObject(gerritChange));
        review.setKey(change.getKey().get());
        review.setId(this.getLocalKeyForRemoteObject(gerritChange));
        AccountInfo remoteOwner = detail.getAccounts().get(change.getOwner());
        IUser owner = this.getGerritProvider().createUser(parent, detail.getAccounts(), remoteOwner.getId());
        review.setOwner(owner);
        review.setCreationDate((Date)change.getCreatedOn());
        parent.getReviews().add(review);
        return review;
    }

    public boolean isUpdateModelNeeded(IRepository parent, IReview review, GerritChange gerritChange) {
        Change change = gerritChange.getChangeDetail().getChange();
        gerritChange.getChangeDetail().getDependsOn();
        this.isDependenciesDifferent(review.getParents(), gerritChange.getChangeDetail().getDependsOn());
        return review.getModificationDate() == null || !review.getModificationDate().equals(change.getLastUpdatedOn()) || this.isDependenciesDifferent(review.getParents(), gerritChange.getChangeDetail().getDependsOn()) || this.isDependenciesDifferent(review.getChildren(), gerritChange.getChangeDetail().getNeededBy());
    }

    public boolean isDependenciesDifferent(List<IChange> localDependencies, List<ChangeInfo> remoteDependencies) {
        HashSet<String> localIds = new HashSet<String>();
        for (IChange localChange : localDependencies) {
            localIds.add(localChange.getId());
        }
        HashSet<String> remoteIds = new HashSet<String>();
        for (ChangeInfo depend : remoteDependencies) {
            remoteIds.add(depend.getId().toString());
        }
        return !localIds.equals(remoteDependencies);
    }

    public boolean updateModel(IRepository parent, IReview review, GerritChange gerritChange) {
        ChangeDetailX detail = gerritChange.getChangeDetail();
        Change change = detail.getChange();
        review.setModificationDate(new Date(change.getLastUpdatedOn().getTime()));
        review.setSubject(change.getSubject());
        review.setMessage(detail.getDescription());
        this.updateComments(parent, review, detail);
        this.updateEmptyPatchSets(parent, review, gerritChange);
        this.updateApprovalsAndRequirements(parent, review, detail);
        this.updateDependencies(parent, review, detail);
        return true;
    }

    public void updateComments(IRepository parent, IReview review, ChangeDetailX detail) {
        int oldCommentCount = review.getComments().size();
        int commentIndex = 0;
        for (ChangeMessage message : detail.getMessages()) {
            if (commentIndex++ < oldCommentCount) continue;
            IComment comment = review.createComment(null, message.getMessage());
            comment.setDraft(false);
            comment.setCreationDate((Date)message.getWrittenOn());
            if (message.getAuthor() == null) continue;
            IUser author = this.getGerritProvider().createUser(parent, detail.getAccounts(), message.getAuthor());
            comment.setAuthor(author);
        }
    }

    public void updateEmptyPatchSets(IRepository parent, IReview review, GerritChange gerritChange) {
        ChangeDetailX detail = gerritChange.getChangeDetail();
        int oldPatchCount = review.getSets().size();
        int patchIndex = 0;
        PatchSetDetailRemoteFactory itemSetFactory = this.getGerritProvider().getReviewItemSetFactory();
        for (PatchSetDetail patchSetDetail : gerritChange.getPatchSetDetails()) {
            UserIdentity authorIdent;
            RemoteEmfConsumer consumer = itemSetFactory.getConsumerForRemoteObject((EObject)review, patchSetDetail);
            try {
                consumer.pull(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException("Internal Exception. Unexpected state.", e);
            }
            if (patchIndex++ < oldPatchCount) continue;
            consumer.applyModel(false);
            IReviewItemSet itemSet = (IReviewItemSet)consumer.getModelObject();
            IUser author = this.getGerritProvider().createUser(parent, detail.getAccounts(), patchSetDetail.getInfo().getAuthor().getAccount());
            itemSet.setAddedBy(author);
            UserIdentity committerIdent = patchSetDetail.getInfo().getCommitter();
            if (committerIdent != null) {
                IUser committer = this.getGerritProvider().createUser(parent, detail.getAccounts(), committerIdent.getAccount());
                itemSet.setCommittedBy(committer);
                itemSet.setCreationDate((Date)committerIdent.getDate());
            }
            if ((authorIdent = patchSetDetail.getInfo().getAuthor()) != null) {
                itemSet.setModificationDate((Date)authorIdent.getDate());
            }
            consumer.release();
        }
    }

    public void updateApprovalsAndRequirements(IRepository parent, IReview review, ChangeDetailX detail) {
        HashMap<String, IApprovalType> typeForKey = new HashMap<String, IApprovalType>();
        HashMap<String, IApprovalType> typeForName = new HashMap<String, IApprovalType>();
        for (IApprovalType type : parent.getApprovalTypes()) {
            typeForKey.put(type.getKey(), type);
        }
        GerritConfiguration configuration = this.getGerritProvider().getClient().getConfiguration();
        for (ApprovalType remoteType : configuration.getGerritConfig().getApprovalTypes().getApprovalTypes()) {
            IApprovalType localApprovalType = (IApprovalType)typeForKey.get(remoteType.getCategory().getId().get());
            if (localApprovalType == null) {
                localApprovalType = IReviewsFactory.INSTANCE.createApprovalType();
                localApprovalType.setKey(remoteType.getCategory().getId().get());
                localApprovalType.setName(remoteType.getCategory().getName());
                parent.getApprovalTypes().add(localApprovalType);
                typeForKey.put(localApprovalType.getKey(), localApprovalType);
            }
            String approvalName = remoteType.getCategory().getName();
            approvalName = approvalName.replace(" ", "-");
            typeForName.put(approvalName, localApprovalType);
        }
        review.getReviewerApprovals().clear();
        for (ApprovalDetail remoteApproval : detail.getApprovals()) {
            IUser reviewer = this.getGerritProvider().createUser(parent, detail.getAccounts(), remoteApproval.getAccount());
            if (reviewer == null) {
                throw new RuntimeException("Internal Error, no reviewer found for: " + remoteApproval.getAccount());
            }
            IReviewerEntry reviewerEntry = (IReviewerEntry)review.getReviewerApprovals().get(reviewer);
            if (reviewerEntry == null) {
                reviewerEntry = IReviewsFactory.INSTANCE.createReviewerEntry();
                review.getReviewerApprovals().put(reviewer, reviewerEntry);
            }
            for (Map.Entry remoteMap : remoteApproval.getApprovalMap().entrySet()) {
                String remoteType = ((PatchSetApproval)remoteMap.getValue()).getCategoryId().get();
                IApprovalType approvalType = (IApprovalType)typeForKey.get(remoteType);
                if (approvalType == null) {
                    approvalType = IReviewsFactory.INSTANCE.createApprovalType();
                    approvalType.setKey(remoteType);
                    approvalType.setName(remoteType);
                    parent.getApprovalTypes().add(approvalType);
                    typeForKey.put(approvalType.getKey(), approvalType);
                }
                reviewerEntry.getApprovals().put(approvalType, Integer.valueOf(((PatchSetApproval)remoteMap.getValue()).getValue()));
            }
        }
        review.getRequirements().clear();
        if (detail.getSubmitRecords() != null) {
            for (SubmitRecord record : detail.getSubmitRecords()) {
                for (SubmitRecord.Label label : record.getLabels()) {
                    IApprovalType approvalType = (IApprovalType)typeForName.get(label.getLabel());
                    if (approvalType == null) {
                        throw new RuntimeException("Internal Error, no approval type found for: " + label.getLabel());
                    }
                    IRequirementEntry requirementEntry = IReviewsFactory.INSTANCE.createRequirementEntry();
                    if (label.getStatus().equals("OK")) {
                        requirementEntry.setStatus(RequirementStatus.SATISFIED);
                    } else if (label.getStatus().equals("NEED")) {
                        requirementEntry.setStatus(RequirementStatus.NOT_SATISFIED);
                    } else if (label.getStatus().equals("REJECT")) {
                        requirementEntry.setStatus(RequirementStatus.REJECTED);
                    } else if (label.getStatus().equals("MAY")) {
                        requirementEntry.setStatus(RequirementStatus.OPTIONAL);
                    } else if (label.getStatus().equals("IMPOSSIBLE")) {
                        requirementEntry.setStatus(RequirementStatus.ERROR);
                    }
                    if (label.getAppliedBy() != null) {
                        IUser approver = this.getGerritProvider().createUser(parent, detail.getAccounts(), label.getAppliedBy());
                        requirementEntry.setBy(approver);
                    }
                    review.getRequirements().put(approvalType, requirementEntry);
                }
            }
        }
        switch (detail.getChange().getStatus()) {
            case NEW: {
                review.setState(ReviewStatus.NEW);
                break;
            }
            case MERGED: {
                review.setState(ReviewStatus.MERGED);
                break;
            }
            case SUBMITTED: {
                review.setState(ReviewStatus.SUBMITTED);
                break;
            }
            case ABANDONED: {
                review.setState(ReviewStatus.ABANDONED);
            }
        }
    }

    public void updateDependencies(IRepository parent, IReview review, ChangeDetailX detail) {
        this.create(parent, review.getParents(), detail, detail.getDependsOn());
        this.create(parent, review.getChildren(), detail, detail.getNeededBy());
    }

    protected void create(IRepository group, List<IChange> localChanges, ChangeDetailX detail, List<ChangeInfo> remoteChanges) {
        localChanges.clear();
        for (ChangeInfo remoteChange : remoteChanges) {
            IChange localChange = IReviewsFactory.INSTANCE.createChange();
            localChange.setKey(remoteChange.getKey().get());
            localChange.setId(String.valueOf(remoteChange.getId().get()));
            AccountInfo remoteOwner = detail.getAccounts().get(remoteChange.getOwner());
            IUser owner = this.getGerritProvider().createUser(group, detail.getAccounts(), remoteOwner.getId());
            localChange.setOwner(owner);
            localChange.setModificationDate((Date)remoteChange.getLastUpdatedOn());
            localChange.setSubject(remoteChange.getSubject());
            switch (remoteChange.getStatus()) {
                case NEW: {
                    localChange.setState(ReviewStatus.NEW);
                    break;
                }
                case MERGED: {
                    localChange.setState(ReviewStatus.MERGED);
                    break;
                }
                case SUBMITTED: {
                    localChange.setState(ReviewStatus.SUBMITTED);
                    break;
                }
                case ABANDONED: {
                    localChange.setState(ReviewStatus.ABANDONED);
                }
            }
            localChanges.add(localChange);
        }
    }

    public String getRemoteKey(GerritChange remoteObject) {
        return String.valueOf(remoteObject.getChangeDetail().getChange().getId().get());
    }

    public String getLocalKeyForRemoteObject(GerritChange remoteObject) {
        return this.getRemoteKey(remoteObject);
    }

    public String getLocalKeyForRemoteKey(String remoteKey) {
        return remoteKey;
    }

    public String getRemoteKeyForLocalKey(IRepository parentObject, String localKey) {
        return localKey;
    }

    public GerritRemoteFactoryProvider getGerritProvider() {
        return (GerritRemoteFactoryProvider)this.getFactoryProvider();
    }
}

