/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.DefaultTaskMapping;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class BugzillaTaskDataHandlerTest
extends TestCase {
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;

    public void setUp() throws Exception {
        this.repository = BugzillaFixture.current().repository();
        this.connector = BugzillaFixture.current().connector();
    }

    public void testCloneTaskData() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "test summary for clone", "test description for clone");
        taskData.getRoot().getMappedAttribute("task.common.priority").setValue("P5");
        TaskMapper mapping = this.connector.getTaskMapping(taskData);
        DefaultTaskMapping taskSelection = new DefaultTaskMapping();
        taskSelection.setDescription("Test description");
        TaskAttribute attrDescription = mapping.getTaskData().getRoot().getMappedAttribute("task.common.description");
        if (attrDescription != null) {
            attrDescription.getMetaData().setReadOnly(false);
        }
        mapping.merge((ITaskMapping)taskSelection);
        BugzillaTaskDataHandlerTest.assertEquals((String)"test summary for clone", (String)mapping.getSummary());
        BugzillaTaskDataHandlerTest.assertEquals((String)"Test description", (String)mapping.getDescription());
    }

    public void testCharacterEscaping() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, "Testing! \"&@ $\" &amp;", null);
        BugzillaTaskDataHandlerTest.assertEquals((String)"Testing! \"&@ $\" &amp;", (String)taskData.getRoot().getAttribute(BugzillaAttribute.SHORT_DESC.getKey()).getValue());
    }

    public void testinitializeTaskData() throws Exception {
        TaskMapping taskMappingInit = new TaskMapping(){

            public String getSummary() {
                return "The Summary";
            }

            public String getDescription() {
                return "The Description";
            }
        };
        TaskMapping taskMappingSelect = new TaskMapping(){

            public String getProduct() {
                return "TestProduct";
            }
        };
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, null, null));
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, (ITaskMapping)taskMappingInit, null));
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, (ITaskMapping)taskMappingSelect, null));
    }

    public void testPropertyTargetMilestoneUndefined() throws Exception {
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        this.repository.removeProperty("bugzilla.param.usetargetmilestone");
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, null, null));
        BugzillaTaskDataHandlerTest.assertNotNull((Object)taskData.getRoot().getAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey()));
    }

    public void testPropertyTargetMilestoneTrue() throws Exception {
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        this.repository.setProperty("bugzilla.param.usetargetmilestone", Boolean.TRUE.toString());
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, null, null));
        BugzillaTaskDataHandlerTest.assertNotNull((Object)taskData.getRoot().getAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey()));
    }

    public void testPropertyTargetMilestoneFalse() throws Exception {
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        this.repository.setProperty("bugzilla.param.usetargetmilestone", Boolean.FALSE.toString());
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        BugzillaTaskDataHandlerTest.assertTrue((boolean)taskDataHandler.initializeTaskData(this.repository, taskData, null, null));
        BugzillaTaskDataHandlerTest.assertNull((Object)taskData.getRoot().getAttribute(BugzillaAttribute.TARGET_MILESTONE.getKey()));
    }
}

