/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttributeMapper;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tests.util.UrlBuilder;

public class BugzillaClientTest
extends TestCase {
    private BugzillaClient client;
    private TaskRepository repository;

    protected void setUp() throws Exception {
        this.repository = BugzillaFixture.current().repository();
        this.client = BugzillaFixture.current().client();
    }

    public void testRDFProductConfig() throws Exception {
        if (BugzillaVersion.BUGZILLA_4_4.compareTo(BugzillaFixture.current().getBugzillaVersion()) == 0 || BugzillaVersion.BUGZILLA_HEAD.compareTo(BugzillaFixture.current().getBugzillaVersion()) == 0) {
            return;
        }
        RepositoryConfiguration config = this.client.getRepositoryConfiguration();
        BugzillaClientTest.assertNotNull((Object)config);
        BugzillaClientTest.assertEquals((int)0, (int)config.getInstallVersion().compareMajorMinorOnly(new BugzillaVersion(BugzillaFixture.current().getVersion())));
        if (BugzillaFixture.current().isCustomWorkflowAndStatus()) {
            BugzillaClientTest.assertEquals((int)10, (int)config.getOptionValues(BugzillaAttribute.BUG_STATUS).size());
        } else if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            BugzillaClientTest.assertEquals((int)7, (int)config.getOptionValues(BugzillaAttribute.BUG_STATUS).size());
        } else {
            BugzillaClientTest.assertEquals((int)5, (int)config.getOptionValues(BugzillaAttribute.BUG_STATUS).size());
        }
        if (config.getOptionValues(BugzillaAttribute.RESOLUTION).contains("LATER")) {
            BugzillaClientTest.assertEquals((int)8, (int)config.getOptionValues(BugzillaAttribute.RESOLUTION).size());
            BugzillaClientTest.assertEquals((int)8, (int)config.getOptionValues(BugzillaAttribute.REP_PLATFORM).size());
            BugzillaClientTest.assertEquals((int)36, (int)config.getOptionValues(BugzillaAttribute.OP_SYS).size());
            BugzillaClientTest.assertEquals((int)5, (int)config.getOptionValues(BugzillaAttribute.PRIORITY).size());
        } else {
            if (BugzillaVersion.BUGZILLA_4_0.compareMajorMinorOnly(new BugzillaVersion(BugzillaFixture.current().getVersion())) > 0) {
                BugzillaClientTest.assertEquals((int)6, (int)config.getOptionValues(BugzillaAttribute.RESOLUTION).size());
            } else {
                BugzillaClientTest.assertEquals((int)5, (int)config.getOptionValues(BugzillaAttribute.RESOLUTION).size());
            }
            BugzillaClientTest.assertEquals((int)4, (int)config.getOptionValues(BugzillaAttribute.REP_PLATFORM).size());
            BugzillaClientTest.assertEquals((int)5, (int)config.getOptionValues(BugzillaAttribute.OP_SYS).size());
            BugzillaClientTest.assertEquals((int)6, (int)config.getOptionValues(BugzillaAttribute.PRIORITY).size());
        }
        BugzillaClientTest.assertEquals((int)7, (int)config.getOptionValues(BugzillaAttribute.BUG_SEVERITY).size());
        BugzillaClientTest.assertEquals((int)3, (int)config.getOptionValues(BugzillaAttribute.PRODUCT).size());
        if (BugzillaFixture.current().isCustomWorkflowAndStatus()) {
            BugzillaClientTest.assertEquals((int)6, (int)config.getOpenStatusValues().size());
            BugzillaClientTest.assertEquals((int)1, (int)config.getClosedStatusValues().size());
        } else if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            BugzillaClientTest.assertEquals((int)4, (int)config.getOpenStatusValues().size());
            BugzillaClientTest.assertEquals((int)3, (int)config.getClosedStatusValues().size());
        } else {
            BugzillaClientTest.assertEquals((int)3, (int)config.getOpenStatusValues().size());
            BugzillaClientTest.assertEquals((int)2, (int)config.getClosedStatusValues().size());
        }
        BugzillaClientTest.assertEquals((int)2, (int)config.getOptionValues(BugzillaAttribute.KEYWORDS).size());
        BugzillaClientTest.assertEquals((int)2, (int)config.getProductOptionValues(BugzillaAttribute.COMPONENT, "ManualTest").size());
        BugzillaClientTest.assertEquals((int)4, (int)config.getProductOptionValues(BugzillaAttribute.VERSION, "ManualTest").size());
        BugzillaClientTest.assertEquals((int)4, (int)config.getProductOptionValues(BugzillaAttribute.TARGET_MILESTONE, "ManualTest").size());
        BugzillaClientTest.assertEquals((int)1, (int)config.getProductOptionValues(BugzillaAttribute.COMPONENT, "TestProduct").size());
        BugzillaClientTest.assertEquals((int)1, (int)config.getProductOptionValues(BugzillaAttribute.VERSION, "TestProduct").size());
        BugzillaClientTest.assertEquals((int)1, (int)config.getProductOptionValues(BugzillaAttribute.TARGET_MILESTONE, "TestProduct").size());
        BugzillaClientTest.assertEquals((int)2, (int)config.getProductOptionValues(BugzillaAttribute.COMPONENT, "Product with Spaces").size());
        BugzillaClientTest.assertEquals((int)4, (int)config.getProductOptionValues(BugzillaAttribute.VERSION, "Product with Spaces").size());
        BugzillaClientTest.assertEquals((int)4, (int)config.getProductOptionValues(BugzillaAttribute.TARGET_MILESTONE, "Product with Spaces").size());
    }

    public void testValidate() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        AbstractWebLocation location = BugzillaFixture.current().location();
        this.client = new BugzillaClient(location, repository, BugzillaFixture.current().connector());
        this.client.validate((IProgressMonitor)new NullProgressMonitor());
    }

    public void testValidateInvalidProxy() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        AbstractWebLocation location = BugzillaFixture.current().location(CommonTestUtil.PrivilegeLevel.USER, new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 12356)));
        this.client = new BugzillaClient(location, repository, BugzillaFixture.current().connector());
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
            BugzillaClientTest.fail((String)"invalid proxy did not cause connection error");
        }
        catch (Exception exception) {}
    }

    public void testValidateAnonymous() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        AuthenticationCredentials anonymousCreds = new AuthenticationCredentials("", "");
        repository.setCredentials(AuthenticationType.REPOSITORY, anonymousCreds, false);
        TaskRepositoryLocation location = new TaskRepositoryLocation(repository);
        this.client = new BugzillaClient((AbstractWebLocation)location, repository, BugzillaFixture.current().connector());
        this.client.validate((IProgressMonitor)new NullProgressMonitor());
    }

    public void testValidateAnonymousPlusHTTP() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        AuthenticationCredentials anonymousCreds = new AuthenticationCredentials("", "");
        repository.setCredentials(AuthenticationType.REPOSITORY, anonymousCreds, false);
        repository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("YYYYYYYY", "XXXXXXXX"), false);
        TaskRepositoryLocation location = new TaskRepositoryLocation(repository);
        this.client = new BugzillaClient((AbstractWebLocation)location, repository, BugzillaFixture.current().connector());
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            BugzillaClientTest.assertEquals((String)("Expected login error, got: " + e.getMessage()), (int)3, (int)e.getStatus().getCode());
        }
    }

    public void testValidateUser() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        TaskRepositoryLocation location = new TaskRepositoryLocation(repository);
        this.client = new BugzillaClient((AbstractWebLocation)location, repository, BugzillaFixture.current().connector());
        this.client.validate((IProgressMonitor)new NullProgressMonitor());
    }

    public void testValidateUserPlusHTTP() throws Exception {
        TaskRepository repository = BugzillaFixture.current().repository();
        repository.setCredentials(AuthenticationType.HTTP, new AuthenticationCredentials("YYYYYYYY", "XXXXXXXX"), false);
        TaskRepositoryLocation location = new TaskRepositoryLocation(repository);
        this.client = new BugzillaClient((AbstractWebLocation)location, repository, BugzillaFixture.current().connector());
        try {
            this.client.validate((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            BugzillaClientTest.assertEquals((String)("Unable to login to " + repository.getUrl() + ".\n\n\n    The username or password you entered is not valid.\n\n" + "Please validate credentials via Task Repositories view."), (String)e.getMessage());
        }
    }

    public void testCommentQuery() throws Exception {
        BugzillaRepositoryConnector connector = BugzillaFixture.current().connector();
        BugzillaAttributeMapper mapper = new BugzillaAttributeMapper(this.repository, connector);
        TaskData newData = new TaskData((TaskAttributeMapper)mapper, BugzillaFixture.current().getConnectorKind(), BugzillaFixture.current().getRepositoryUrl(), "");
        BugzillaClientTest.assertTrue((boolean)connector.getTaskDataHandler().initializeTaskData(this.repository, newData, null, (IProgressMonitor)new NullProgressMonitor()));
        newData.getRoot().getMappedAttribute("task.common.summary").setValue("testCommentQuery()");
        newData.getRoot().getMappedAttribute("task.common.product").setValue("TestProduct");
        newData.getRoot().getMappedAttribute("task.common.component").setValue("TestComponent");
        newData.getRoot().getMappedAttribute(BugzillaAttribute.OP_SYS.getKey()).setValue("All");
        long timestamp = System.currentTimeMillis();
        newData.getRoot().getMappedAttribute("task.common.description").setValue("" + timestamp);
        RepositoryResponse response = this.client.postTaskData(newData, (IProgressMonitor)new NullProgressMonitor());
        String bugid = response.getTaskId();
        RepositoryQuery query = new RepositoryQuery(BugzillaFixture.current().getConnectorKind(), "123");
        query.setRepositoryUrl(BugzillaFixture.current().getRepositoryUrl());
        if (BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0) {
            query.setUrl("?long_desc_type=allwordssubstr&long_desc=" + timestamp + "&bug_status=NEW&");
        } else {
            query.setUrl("?long_desc_type=allwordssubstr&long_desc=" + timestamp + "&bug_status=CONFIRMED&");
        }
        final HashSet returnedData = new HashSet();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                returnedData.add(taskData);
            }
        };
        this.client.getSearchHits((IRepositoryQuery)query, collector, (TaskAttributeMapper)mapper, (IProgressMonitor)new NullProgressMonitor());
        BugzillaClientTest.assertEquals((int)1, (int)returnedData.size());
        BugzillaClientTest.assertEquals((String)bugid, (String)((TaskData)returnedData.iterator().next()).getTaskId());
    }

    public void testQueryRealName_Bug335278() throws Exception {
        RepositoryQuery query = new RepositoryQuery(BugzillaFixture.current().getConnectorKind(), "query");
        UrlBuilder urlBuilder = UrlBuilder.build((TaskRepository)BugzillaFixture.current().repository()).append("/buglist.cgi");
        urlBuilder.parameter("columnlist", "bug_severity,priority,assigned_to,bug_status,resolution,short_desc,changeddate,reporter,assigned_to_realname,reporter_realname,product,component");
        query.setUrl(urlBuilder.toString());
        final HashSet returnedData = new HashSet();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                returnedData.add(taskData);
            }
        };
        TaskAttributeMapper mapper = BugzillaFixture.current().connector().getTaskDataHandler().getAttributeMapper(BugzillaFixture.current().repository());
        this.client.getSearchHits((IRepositoryQuery)query, collector, mapper, (IProgressMonitor)new NullProgressMonitor());
        BugzillaClientTest.assertTrue((returnedData.size() > 0 ? 1 : 0) != 0);
        for (TaskData taskData : returnedData) {
            TaskAttribute reporterName = taskData.getRoot().getAttribute(BugzillaAttribute.REPORTER_NAME.getKey());
            TaskAttribute assignedToName = taskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO_NAME.getKey());
            this.assertHasValue(reporterName);
            this.assertHasValue(assignedToName);
        }
    }

    private void assertHasValue(TaskAttribute attribute) {
        BugzillaClientTest.assertNotNull((Object)attribute);
        BugzillaClientTest.assertNotNull((Object)attribute.getValue());
        BugzillaClientTest.assertTrue((attribute.getValue().trim().length() > 0 ? 1 : 0) != 0);
    }

    public void testLeadingZeros() throws Exception {
        String taskNumber = "0002";
        TaskData taskData = BugzillaFixture.current().getTask(taskNumber, this.client);
        BugzillaClientTest.assertNotNull((Object)taskData);
        BugzillaClientTest.assertNotNull((Object)taskData);
        TaskAttribute idAttribute = taskData.getRoot().getAttribute(BugzillaAttribute.BUG_ID.getKey());
        BugzillaClientTest.assertNotNull((Object)idAttribute);
        BugzillaClientTest.assertEquals((String)"2", (String)idAttribute.getValue());
    }
}

