/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;

public class BugzillaRepositoryConnectorStandaloneTest
extends TestCase {
    private TaskRepository repository;
    private BugzillaRepositoryConnector connector;
    private BugzillaClient client;

    public void setUp() throws Exception {
        this.client = BugzillaFixture.current().client(CommonTestUtil.PrivilegeLevel.USER);
        this.repository = BugzillaFixture.current().repository();
        this.connector = BugzillaFixture.current().connector();
    }

    public void testHasTaskChanged() {
        TaskTask task = new TaskTask(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2008-02-02 12:01:12");
        TaskData data = new TaskData(this.connector.getTaskDataHandler().getAttributeMapper(this.repository), this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        TaskAttribute attribute = data.getRoot().createAttribute(BugzillaAttribute.DELTA_TS.getKey());
        attribute.setValue("2008-02-02 12:01:12");
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        attribute.setValue("2008-02-03 12:01:12");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        attribute.setValue("2008-02-02 12:03:12");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        attribute.setValue("2008-02-02 12:03:00");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2008-02-02 12:01:12 -0700");
        attribute.setValue("2008-02-02 12:01:12");
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2008-02-02 12:01:12 -0700");
        attribute.setValue("2008-02-02 12:01:13");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2008-02-02 12:01:12");
        attribute.setValue("2008-02-02 12:01:12 -0700");
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        attribute.setValue("2008-02-02 12:01:13 -0700");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2008-02-02 12:01:12");
        attribute.setValue("2008-02-02 12:01:03 -0700");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2009-09-04 00:00:00 PDT");
        attribute.setValue("2009-09-04 03:00:00 EDT");
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2009-09-04 12:00:00 PDT");
        attribute.setValue("2009-09-04 12:00:01 PDT");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2009-09-04 12:00:::01 PDT");
        attribute.setValue("2009-09-04 12:00:::01 PDT");
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
        task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), "2009-09X-04X12:00:::01 PDT");
        attribute.setValue("2009-X-03 12:00:::01 PDT");
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)this.connector.hasTaskChanged(this.repository, (ITask)task, data));
    }

    public void testAddCredentials() {
        AuthenticationCredentials auth = this.repository.getCredentials(AuthenticationType.REPOSITORY);
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((auth != null && auth.getPassword() != null && !auth.getPassword().equals("") && auth.getUserName() != null && !auth.getUserName().equals("") ? 1 : 0) != 0);
    }

    public void testGetTaskData() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add(taskData.getTaskId());
        final HashSet results = new HashSet();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                results.add(taskData);
            }
        };
        this.connector.getTaskDataHandler().getMultiTaskData(this.repository, taskIds, collector, (IProgressMonitor)new NullProgressMonitor());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((int)1, (int)results.size());
        TaskData updatedTaskData = (TaskData)results.iterator().next();
        String taskId = updatedTaskData.getTaskId();
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskId, (String)updatedTaskData.getTaskId());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue());
    }

    public void testGetMultiTaskData() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        TaskData taskData2 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        TaskData taskData3 = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        HashSet<String> taskIds = new HashSet<String>();
        taskIds.add(taskData.getTaskId());
        taskIds.add(taskData2.getTaskId());
        taskIds.add(taskData3.getTaskId());
        final HashMap results = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                results.put(taskData.getTaskId(), taskData);
            }
        };
        this.connector.getTaskDataHandler().getMultiTaskData(this.repository, taskIds, collector, (IProgressMonitor)new NullProgressMonitor());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((int)3, (int)results.size());
        TaskData updatedTaskData = (TaskData)results.get(taskData.getTaskId());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue());
        updatedTaskData = (TaskData)results.get(taskData2.getTaskId());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData2.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData2.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue());
        updatedTaskData = (TaskData)results.get(taskData3.getTaskId());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData3.getRoot().getAttribute(BugzillaAttribute.ASSIGNED_TO.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.REPORTER.getKey()).getValue());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((String)taskData3.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue(), (String)updatedTaskData.getRoot().getAttribute(BugzillaAttribute.LONG_DESC.getKey()).getValue());
    }

    public void testPerformQuery() throws Exception {
        TaskData taskData = BugzillaFixture.current().createTask(CommonTestUtil.PrivilegeLevel.USER, null, null);
        RepositoryConfiguration repositoryConfiguration = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        List priorities = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRIORITY);
        String priority = (String)priorities.get(0);
        String severity = "trivial";
        String email = "tests%40mylyn.eclipse.org";
        String bug_status = BugzillaFixture.current().getBugzillaVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_4_0) < 0 ? "&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED" : "&bug_status=UNCONFIRMED&bug_status=CONFIRMED";
        String queryUrlString = String.valueOf(this.repository.getRepositoryUrl()) + "/buglist.cgi?priority=" + priority + "&emailassigned_to1=1&query_format=advanced&emailreporter1=1&field0-0-0=bug_status&bug_severity=" + severity + bug_status + "&type0-0-1=equals&value0-0-1=tests%40mylyn.eclipse.org&email1=" + email + "&type0-0-0=notequals&field0-0-1=reporter&value0-0-0=UNCONFIRMED&emailtype1=exact";
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)taskData.getRoot().getMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).getValue().equals(priority));
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)taskData.getRoot().getMappedAttribute(BugzillaAttribute.BUG_SEVERITY.getKey()).getValue().equals(severity));
        RepositoryQuery query = new RepositoryQuery(this.repository.getConnectorKind(), "handle-testQueryViaConnector");
        query.setUrl(queryUrlString);
        final HashMap changedTaskData = new HashMap();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.put(taskData.getTaskId(), taskData);
            }
        };
        this.connector.performQuery(this.repository, (IRepositoryQuery)query, collector, null, (IProgressMonitor)new NullProgressMonitor());
        taskData.getRoot().getMappedAttribute(BugzillaAttribute.SHORT_DESC.getKey()).setValue(String.valueOf(System.currentTimeMillis()));
        taskData.getRoot().getMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue(priority);
        taskData.getRoot().getMappedAttribute(BugzillaAttribute.BUG_SEVERITY.getKey()).setValue(severity);
        RepositoryResponse response = BugzillaFixture.current().submitTask(taskData, this.client);
        BugzillaRepositoryConnectorStandaloneTest.assertFalse((boolean)response.getTaskId().equals(""));
        TaskData taskDataNew = BugzillaFixture.current().getTask(response.getTaskId(), this.client);
        final HashMap changedTaskData2 = new HashMap();
        TaskDataCollector collector2 = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData2.put(taskData.getTaskId(), taskData);
            }
        };
        this.connector.performQuery(this.repository, (IRepositoryQuery)query, collector2, null, (IProgressMonitor)new NullProgressMonitor());
        changedTaskData2.keySet().removeAll(changedTaskData.keySet());
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((int)1, (int)changedTaskData2.size());
        taskData = (TaskData)changedTaskData2.get(taskData.getTaskId());
        BugzillaRepositoryConnectorStandaloneTest.assertNotNull((Object)taskData);
        BugzillaRepositoryConnectorStandaloneTest.assertTrue((boolean)taskData.getRoot().getAttribute(BugzillaAttribute.SHORT_DESC.getKey()).getValue().equals(taskDataNew.getRoot().getAttribute(BugzillaAttribute.SHORT_DESC.getKey()).getValue()));
    }

    public void testGetTaskMappingPriority() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        TaskMapper mapping = this.connector.getTaskMapping(taskData);
        taskDataHandler.initializeTaskData(this.repository, taskData, null, null);
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P1");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P2");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P3");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P4");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P5");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        if (!version.isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Highest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("High");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Normal");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Low");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("---");
            ITask.PriorityLevel pl = mapping.getPriorityLevel();
            BugzillaRepositoryConnectorStandaloneTest.assertTrue((String)("P3 or P5 expected! but got " + pl.toString()), (pl == ITask.PriorityLevel.P3 || pl == ITask.PriorityLevel.P5 ? 1 : 0) != 0);
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        }
    }

    public void testGetTaskMappingPriorityNoConfiguration() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        TaskMapper mapping = this.connector.getTaskMapping(taskData);
        taskDataHandler.initializeTaskData(this.repository, taskData, null, null);
        this.connector.removeConfiguration(this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl()));
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P1");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P2");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P3");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P4");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P5");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        if (!version.isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Highest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("High");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Normal");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Low");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("---");
            ITask.PriorityLevel pl = mapping.getPriorityLevel();
            BugzillaRepositoryConnectorStandaloneTest.assertTrue((String)("P3 or P5 expected! but got " + pl.toString()), (pl == ITask.PriorityLevel.P3 || pl == ITask.PriorityLevel.P5 ? 1 : 0) != 0);
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        }
    }

    public void testGetTaskMappingPriorityCustom() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        TaskMapper mapping = this.connector.getTaskMapping(taskData);
        taskDataHandler.initializeTaskData(this.repository, taskData, null, null);
        RepositoryConfiguration config = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        this.connector.removeConfiguration(config);
        config = new RepositoryConfiguration();
        config.setRepositoryUrl(this.repository.getRepositoryUrl());
        config.addItem(BugzillaAttribute.PRIORITY, "MostHighest");
        config.addItem(BugzillaAttribute.PRIORITY, "Highest");
        config.addItem(BugzillaAttribute.PRIORITY, "Higher");
        config.addItem(BugzillaAttribute.PRIORITY, "High");
        config.addItem(BugzillaAttribute.PRIORITY, "Normal");
        config.addItem(BugzillaAttribute.PRIORITY, "Low");
        config.addItem(BugzillaAttribute.PRIORITY, "Lower");
        config.addItem(BugzillaAttribute.PRIORITY, "Lowest");
        config.addItem(BugzillaAttribute.PRIORITY, "MostLowest");
        this.connector.addRepositoryConfiguration(config);
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P1");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P2");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P3");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P4");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P5");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        if (!version.isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("MostHighest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Highest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Higher");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("High");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Normal");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Low");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lower");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("MostLowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("---");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        }
    }

    public void testGetTaskMappingPriorityCustomWithNoConfig() throws Exception {
        BugzillaVersion version = new BugzillaVersion(BugzillaFixture.current().getVersion());
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository);
        TaskData taskData = new TaskData(mapper, this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "");
        TaskMapper mapping = this.connector.getTaskMapping(taskData);
        taskDataHandler.initializeTaskData(this.repository, taskData, null, null);
        RepositoryConfiguration config = this.connector.getRepositoryConfiguration(this.repository.getRepositoryUrl());
        this.connector.removeConfiguration(config);
        config = new RepositoryConfiguration();
        config.setRepositoryUrl(this.repository.getRepositoryUrl());
        config.addItem(BugzillaAttribute.PRIORITY, "MostHighest");
        config.addItem(BugzillaAttribute.PRIORITY, "Highest");
        config.addItem(BugzillaAttribute.PRIORITY, "Higher");
        config.addItem(BugzillaAttribute.PRIORITY, "High");
        config.addItem(BugzillaAttribute.PRIORITY, "Normal");
        config.addItem(BugzillaAttribute.PRIORITY, "Low");
        config.addItem(BugzillaAttribute.PRIORITY, "Lower");
        config.addItem(BugzillaAttribute.PRIORITY, "Lowest");
        config.addItem(BugzillaAttribute.PRIORITY, "MostLowest");
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P1");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P2");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P3");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P4");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("P5");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
        BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        if (!version.isSmaller(BugzillaVersion.BUGZILLA_3_6)) {
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("MostHighest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Highest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P1, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Higher");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("High");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P2, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Normal");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Low");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P4, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lower");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("Lowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P5, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("MostLowest");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("---");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
            taskData.getRoot().createMappedAttribute(BugzillaAttribute.PRIORITY.getKey()).setValue("abc");
            BugzillaRepositoryConnectorStandaloneTest.assertEquals((Object)ITask.PriorityLevel.P3, (Object)mapping.getPriorityLevel());
        }
    }
}

