/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationChainImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.IRemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteENotificationImpl;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteNotification;

public class RemoteEmfConsumer<EParentObjectType extends EObject, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType>
extends AbstractRemoteConsumer {
    private final AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> factory;
    private RemoteKeyType remoteKey;
    private RemoteType remoteObject;
    private final EParentObjectType parentObject;
    private EObjectType modelObject;
    private LocalKeyType localKey;
    private final Collection<IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>> remoteEmfObservers;
    private boolean pulling;
    private boolean retrieving;
    boolean userJob;
    boolean systemJob;
    boolean asynchronous = true;
    ConsumerAdapter adapter = new ConsumerAdapter();

    RemoteEmfConsumer(AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> factory, EParentObjectType parent, EObjectType modelObject, LocalKeyType localKey, RemoteType remoteObject, RemoteKeyType remoteKey) {
        this.parentObject = parent;
        this.modelObject = modelObject;
        this.remoteObject = remoteObject;
        this.remoteKey = remoteKey;
        this.localKey = localKey;
        this.factory = factory;
        if (remoteKey == null && remoteObject != null) {
            remoteKey = factory.getRemoteKey(remoteObject);
        }
        if (localKey == null && modelObject != null) {
            localKey = factory.getLocalKey(null, modelObject);
        }
        if (modelObject instanceof EObject) {
            ((EObject)modelObject).eAdapters().add((Object)this.adapter);
        } else if (parent != null) {
            parent.eAdapters().add((Object)this.adapter);
        }
        this.remoteEmfObservers = new ArrayList<IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>>();
    }

    @Override
    public void pull(boolean force, IProgressMonitor monitor) throws CoreException {
        this.pulling = true;
        if (this.remoteObject != null && this.remoteKey == null) {
            this.remoteKey = this.factory.getRemoteKey(this.remoteObject);
        }
        if (this.remoteKey == null && this.localKey != null) {
            this.remoteKey = this.factory.getRemoteKeyForLocalKey(this.parentObject, this.localKey);
        }
        if ((this.factory.isPullNeeded(this.parentObject, this.modelObject, this.remoteObject) || force) && this.remoteKey != null) {
            this.getFactory().getService().modelExec(new Runnable(){

                @Override
                public void run() {
                    RemoteEmfConsumer.this.parentObject.eNotify((Notification)new RemoteENotificationImpl((InternalEObject)RemoteEmfConsumer.this.parentObject, 1003, RemoteEmfConsumer.this.factory.getParentReference(), RemoteEmfConsumer.this.modelObject));
                    if (RemoteEmfConsumer.this.modelObject instanceof EObject) {
                        ((EObject)RemoteEmfConsumer.this.modelObject).eNotify((Notification)new RemoteENotificationImpl((InternalEObject)RemoteEmfConsumer.this.modelObject, 1003, null, null));
                    }
                }
            }, false);
            try {
                this.remoteObject = this.factory.pull(this.parentObject, this.remoteKey, monitor);
                if (this.localKey == null) {
                    this.localKey = this.factory.getLocalKeyForRemoteObject(this.remoteObject);
                }
                this.pulling = false;
            }
            catch (CoreException e) {
                this.getFactory().getService().modelExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteEmfConsumer.this.parentObject.eNotify((Notification)new RemoteENotificationImpl((InternalEObject)RemoteEmfConsumer.this.parentObject, 1004, RemoteEmfConsumer.this.factory.getParentReference(), null, e.getStatus()));
                        if (RemoteEmfConsumer.this.modelObject instanceof EObject) {
                            ((EObject)RemoteEmfConsumer.this.modelObject).eNotify((Notification)new RemoteENotificationImpl((InternalEObject)RemoteEmfConsumer.this.modelObject, 1014, null, (Object)null, e.getStatus()));
                        }
                    }
                }, false);
                throw e;
            }
        }
        this.pulling = false;
    }

    public boolean isPulling() {
        return this.pulling;
    }

    @Override
    public void applyModel(boolean force) {
        NotificationChainImpl msgs = new NotificationChainImpl();
        EReference reference = this.factory.getParentReference();
        boolean modified = false;
        if (this.remoteObject != null) {
            if (this.modelObject == null || this.factory.isCreateModelNeeded(this.parentObject, this.modelObject) || reference.isMany() && ((Collection)this.parentObject.eGet((EStructuralFeature)reference)).size() == 0) {
                modified = true;
                this.modelObject = this.factory.createModel(this.parentObject, this.remoteObject);
                if (reference.isMany()) {
                    if (this.modelObject instanceof Collection) {
                        ((EList)this.parentObject.eGet((EStructuralFeature)reference)).addAll((Collection)this.modelObject);
                    } else {
                        ((EList)this.parentObject.eGet((EStructuralFeature)reference)).add(this.modelObject);
                    }
                } else {
                    this.parentObject.eSet((EStructuralFeature)reference, this.modelObject);
                }
                if (this.modelObject instanceof EObject) {
                    ((EObject)this.modelObject).eSet((EStructuralFeature)this.factory.getLocalKeyAttribute(), this.factory.getLocalKeyForRemoteObject(this.remoteObject));
                    if (!((EObject)this.modelObject).eAdapters().contains((Object)this.adapter)) {
                        ((EObject)this.modelObject).eAdapters().add((Object)this.adapter);
                    }
                }
                msgs.add((Notification)new RemoteENotificationImpl((InternalEObject)this.parentObject, 1001, reference, this.modelObject));
            }
            if (this.factory.isUpdateModelNeeded(this.parentObject, this.modelObject, this.remoteObject) || force) {
                modified |= this.factory.updateModel(this.parentObject, this.modelObject, this.remoteObject);
            }
        }
        msgs.add((Notification)new RemoteENotificationImpl((InternalEObject)this.parentObject, 1002, reference, this.modelObject, modified));
        if (this.modelObject instanceof EObject) {
            msgs.add((Notification)new RemoteENotificationImpl((InternalEObject)this.modelObject, 1012, null, (Object)null, modified));
        }
        this.retrieving = false;
        msgs.dispatch();
    }

    public boolean isRetrieving() {
        return this.retrieving;
    }

    public void retrieve(boolean force) {
        if (this.retrieving) {
            return;
        }
        this.retrieving = true;
        this.getFactory().getService().retrieve(this, force);
    }

    @Override
    public void notifyDone(IStatus status) {
        this.retrieving = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.retrieving = false;
        this.parentObject.eAdapters().remove((Object)this.adapter);
        if (this.modelObject instanceof EObject) {
            ((EObject)this.modelObject).eAdapters().remove((Object)this.adapter);
        }
        Collection<IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>> collection = this.remoteEmfObservers;
        synchronized (collection) {
            this.remoteEmfObservers.clear();
        }
        this.getFactory().removeConsumer(this);
        if (this.getModelObject() instanceof EObject) {
            this.getFactory().getFactoryProvider().close((EObject)this.getModelObject());
        }
        this.modelObject = null;
        this.remoteObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType> observer) {
        if (observer instanceof RemoteEmfObserver) {
            RemoteEmfObserver remoteEmfObserver = (RemoteEmfObserver)observer;
            if (remoteEmfObserver.getConsumer() != null && remoteEmfObserver.getConsumer() != this) {
                remoteEmfObserver.getConsumer().removeObserver(remoteEmfObserver);
            }
            remoteEmfObserver.internalSetConsumer(this);
        }
        Collection<IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>> collection = this.remoteEmfObservers;
        synchronized (collection) {
            this.remoteEmfObservers.add(observer);
        }
        if (this.modelObject instanceof EObject) {
            if (!((EObject)this.modelObject).eAdapters().contains((Object)this.adapter)) {
                ((EObject)this.modelObject).eAdapters().add((Object)this.adapter);
            }
        } else if (this.parentObject != null && !this.parentObject.eAdapters().contains((Object)this.adapter)) {
            this.parentObject.eAdapters().add((Object)this.adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType> observer) {
        RemoteEmfObserver remoteEmfObserver;
        if (observer instanceof RemoteEmfObserver && (remoteEmfObserver = (RemoteEmfObserver)observer).getConsumer() == this) {
            remoteEmfObserver.internalSetConsumer(null);
        }
        Collection<IRemoteEmfObserver<EParentObjectType, EObjectType, LocalKeyType, ObjectCurrentType>> collection = this.remoteEmfObservers;
        synchronized (collection) {
            this.remoteEmfObservers.remove(observer);
        }
        this.release();
    }

    public void release() {
        if (this.remoteEmfObservers.size() == 0) {
            this.dispose();
        }
    }

    public void updateObservers() {
        NotificationChainImpl msgs = new NotificationChainImpl();
        msgs.add((Notification)new RemoteENotificationImpl((InternalEObject)this.parentObject, 1002, this.factory.getParentReference(), this.modelObject, false));
        if (this.modelObject instanceof EObject) {
            msgs.add((Notification)new RemoteENotificationImpl((InternalEObject)this.modelObject, 1012, null, (Object)null, false));
        }
        msgs.dispatch();
    }

    public AbstractRemoteEmfFactory<EParentObjectType, EObjectType, LocalKeyType, RemoteType, RemoteKeyType, ObjectCurrentType> getFactory() {
        return this.factory;
    }

    public void open() {
        EObjectType object = this.getFactory().open(this.parentObject, this.localKey);
        if (object instanceof EObject) {
            this.modelObject = object;
            this.getFactory().getService().modelExec(new Runnable(){

                @Override
                public void run() {
                    if (!((EObject)RemoteEmfConsumer.this.modelObject).eAdapters().contains((Object)RemoteEmfConsumer.this.adapter)) {
                        ((EObject)RemoteEmfConsumer.this.modelObject).eAdapters().add((Object)RemoteEmfConsumer.this.adapter);
                    }
                }
            }, true);
        }
    }

    public void save() {
        if (this.getModelObject() instanceof EObject) {
            this.getFactory().getFactoryProvider().save();
            this.getFactory().getFactoryProvider().save((EObject)this.getModelObject());
        }
    }

    public EParentObjectType getParentObject() {
        return this.parentObject;
    }

    public EObjectType getModelObject() {
        return this.modelObject;
    }

    public LocalKeyType getLocalKey() {
        if (this.localKey != null) {
            return this.localKey;
        }
        if (this.remoteKey != null) {
            return this.getFactory().getLocalKeyForRemoteKey(this.remoteKey);
        }
        if (this.remoteObject != null) {
            return this.getFactory().getLocalKeyForRemoteObject(this.remoteObject);
        }
        return null;
    }

    public RemoteKeyType getRemoteKey() {
        return this.remoteKey;
    }

    public RemoteType getRemoteObject() {
        return this.remoteObject;
    }

    void setRemoteObject(RemoteType remoteObject) {
        if (!this.factory.getLocalKeyForRemoteObject(remoteObject).equals(this.getLocalKey())) {
            throw new RuntimeException("Internal Error. Tried to set a remote object that doesn't match existing local key or object.");
        }
        this.remoteObject = remoteObject;
    }

    void setRemoteKey(RemoteKeyType remoteKey) {
        if (!this.factory.getLocalKeyForRemoteKey(remoteKey).equals(this.getLocalKey())) {
            throw new RuntimeException("Internal Error. Tried to set a remote object that doesn't match existing local key or object.");
        }
        this.remoteKey = remoteKey;
    }

    @Override
    public String getDescription() {
        return "Retrieving " + this.factory.getModelDescription(this.getParentObject(), this.getModelObject(), this.getLocalKey());
    }

    @Override
    public boolean isUserJob() {
        return this.userJob;
    }

    public void setUiJob(boolean userJob) {
        this.userJob = userJob;
    }

    @Override
    public boolean isSystemJob() {
        return this.systemJob;
    }

    public void setSystemJob(boolean systemJob) {
        this.systemJob = systemJob;
    }

    @Override
    public boolean isAsynchronous() {
        return this.getFactory().isAsynchronous() && this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    private class ConsumerAdapter
    extends AdapterImpl {
        private ConsumerAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification msg) {
            if (msg instanceof RemoteNotification) {
                boolean notifyChild;
                RemoteNotification remoteMessage = (RemoteNotification)msg;
                boolean notifyParent = remoteMessage.isMember() && msg.getNotifier() == RemoteEmfConsumer.this.parentObject && (msg.getNewValue() == RemoteEmfConsumer.this.modelObject && (msg.getEventType() == 1001 || msg.getEventType() == 1004) || RemoteEmfConsumer.this.modelObject instanceof Collection);
                boolean bl = notifyChild = !remoteMessage.isMember() && msg.getNotifier() == RemoteEmfConsumer.this.modelObject;
                if (notifyParent || notifyChild) {
                    Collection collection = RemoteEmfConsumer.this.remoteEmfObservers;
                    synchronized (collection) {
                        for (IRemoteEmfObserver listener : RemoteEmfConsumer.this.remoteEmfObservers) {
                            switch (msg.getEventType()) {
                                case 1001: {
                                    listener.created(RemoteEmfConsumer.this.parentObject, RemoteEmfConsumer.this.modelObject);
                                    break;
                                }
                                case 1003: 
                                case 1013: {
                                    listener.updating(RemoteEmfConsumer.this.parentObject, RemoteEmfConsumer.this.modelObject);
                                    break;
                                }
                                case 1002: 
                                case 1012: {
                                    listener.updated(RemoteEmfConsumer.this.parentObject, RemoteEmfConsumer.this.modelObject, remoteMessage.isModification());
                                    break;
                                }
                                case 1004: 
                                case 1014: {
                                    listener.failed(RemoteEmfConsumer.this.parentObject, RemoteEmfConsumer.this.modelObject, remoteMessage.getStatus());
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

