/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui.windows;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.sandbox.search.ui.windows.Messages;
import org.eclipse.mylyn.sandbox.search.ui.SearchCallback;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.mylyn.sandbox.search.ui.SearchProvider;
import org.eclipse.osgi.util.NLS;

public class WindowsSearchProvider
extends SearchProvider {
    static {
        String dllName = "Windows7Search";
        String suffix = "32";
        try {
            String osArch = Platform.getOSArch();
            if ("x86".equals(osArch)) {
                suffix = "32";
            } else if ("x86_64".equals(osArch)) {
                suffix = "64";
            }
        }
        catch (Throwable throwable) {}
        dllName = String.valueOf(dllName) + suffix;
        System.loadLibrary(dllName);
    }

    private native void performNativeSearch(SearchCriteria var1, SearchCallback var2, IProgressMonitor var3);

    public void performSearch(SearchCriteria searchSpecification, SearchCallback callback, IProgressMonitor m) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m);
        monitor.beginTask(NLS.bind((String)Messages.WindowsSearchProvider_SearchingTask, (Object)searchSpecification.getText()), -1);
        try {
            this.performNativeSearch(searchSpecification, callback, (IProgressMonitor)monitor);
        }
        finally {
            monitor.done();
        }
    }
}

