/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.sandbox.ui.planner.ITaskCollector;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;

public class CompletedTaskCollector
implements ITaskCollector {
    private final Map<String, AbstractTask> completedTasks = new HashMap<String, AbstractTask>();
    private final Date periodStartDate;
    private final Date periodEndDate;

    public CompletedTaskCollector(Date periodStartDate, Date periodEndDate) {
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
    }

    public String getLabel() {
        return "Completed Tasks";
    }

    @Override
    public void consumeTask(AbstractTask task) {
        if (task.isCompleted() && task.getCompletionDate() != null && task.getCompletionDate().compareTo(this.periodStartDate) >= 0 && task.getCompletionDate().compareTo(this.periodEndDate) <= 0 && !this.completedTasks.containsKey(task.getHandleIdentifier())) {
            this.completedTasks.put(task.getHandleIdentifier(), task);
        }
    }

    @Override
    public Set<AbstractTask> getTasks() {
        HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
        tasks.addAll(this.completedTasks.values());
        return tasks;
    }
}

