/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.CodedEnum;
import com.google.gwtorm.client.Column;

public class AccountDiffPreference {
    public static final short DEFAULT_CONTEXT = 10;
    public static final short WHOLE_FILE_CONTEXT = -1;
    public static final short[] CONTEXT_CHOICES = new short[]{3, 10, 25, 50, 75, 100, -1};
    @Column(id=1, name="--NONE--")
    protected Account.Id accountId;
    @Column(id=2)
    protected char ignoreWhitespace;
    @Column(id=3)
    protected int tabSize;
    @Column(id=4)
    protected int lineLength;
    @Column(id=5)
    protected boolean syntaxHighlighting;
    @Column(id=6)
    protected boolean showWhitespaceErrors;
    @Column(id=7)
    protected boolean intralineDifference;
    @Column(id=8)
    protected boolean showTabs;
    @Column(id=9)
    protected short context;

    public static AccountDiffPreference createDefault(Account.Id accountId) {
        AccountDiffPreference p = new AccountDiffPreference(accountId);
        p.setIgnoreWhitespace(Whitespace.IGNORE_NONE);
        p.setTabSize(8);
        p.setLineLength(100);
        p.setSyntaxHighlighting(true);
        p.setShowWhitespaceErrors(true);
        p.setIntralineDifference(true);
        p.setShowTabs(true);
        p.setContext((short)10);
        return p;
    }

    protected AccountDiffPreference() {
    }

    public AccountDiffPreference(Account.Id accountId) {
        this.accountId = accountId;
    }

    public AccountDiffPreference(AccountDiffPreference p) {
        this.accountId = p.accountId;
        this.ignoreWhitespace = p.ignoreWhitespace;
        this.tabSize = p.tabSize;
        this.lineLength = p.lineLength;
        this.syntaxHighlighting = p.syntaxHighlighting;
        this.showWhitespaceErrors = p.showWhitespaceErrors;
        this.intralineDifference = p.intralineDifference;
        this.showTabs = p.showTabs;
        this.context = p.context;
    }

    public Account.Id getAccountId() {
        return this.accountId;
    }

    public Whitespace getIgnoreWhitespace() {
        return Whitespace.forCode(this.ignoreWhitespace);
    }

    public void setIgnoreWhitespace(Whitespace ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace.getCode();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public boolean isSyntaxHighlighting() {
        return this.syntaxHighlighting;
    }

    public void setSyntaxHighlighting(boolean syntaxHighlighting) {
        this.syntaxHighlighting = syntaxHighlighting;
    }

    public boolean isShowWhitespaceErrors() {
        return this.showWhitespaceErrors;
    }

    public void setShowWhitespaceErrors(boolean showWhitespaceErrors) {
        this.showWhitespaceErrors = showWhitespaceErrors;
    }

    public boolean isIntralineDifference() {
        return this.intralineDifference;
    }

    public void setIntralineDifference(boolean intralineDifference) {
        this.intralineDifference = intralineDifference;
    }

    public boolean isShowTabs() {
        return this.showTabs;
    }

    public void setShowTabs(boolean showTabs) {
        this.showTabs = showTabs;
    }

    public short getContext() {
        return this.context;
    }

    public void setContext(short context) {
        assert (0 <= context || context == -1);
        this.context = context;
    }

    public static enum Whitespace implements CodedEnum
    {
        IGNORE_NONE('N'),
        IGNORE_SPACE_AT_EOL('E'),
        IGNORE_SPACE_CHANGE('S'),
        IGNORE_ALL_SPACE('A');

        private final char code;

        private Whitespace(char c) {
            this.code = c;
        }

        @Override
        public char getCode() {
            return this.code;
        }

        public static Whitespace forCode(char c) {
            for (Whitespace s : Whitespace.values()) {
                if (s.code != c) continue;
                return s;
            }
            return null;
        }
    }
}

