/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ToStringHelper;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithNestedContents;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.util.WikiToStringStyle;

public class Image
extends InlineWithNestedContents {
    private final String src;
    private final String title;

    public Image(Line line, int offset, int length, String src, String title, List<Inline> contents) {
        super(line, offset, length, contents);
        this.src = Objects.requireNonNull(src);
        this.title = title;
    }

    public String getHref() {
        return this.src;
    }

    @Override
    public void emit(DocumentBuilder builder) {
        ImageAttributes attributes = new ImageAttributes();
        attributes.setTitle(this.title);
        List<Inline> contents = this.getContents();
        if (!contents.isEmpty()) {
            attributes.setAlt(InlineParser.toStringContent(contents));
        }
        builder.image((Attributes)attributes, this.src);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOffset(), this.getLength(), this.getContents(), this.src, this.title);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Image other = (Image)obj;
        return this.src.equals(other.src) && this.getContents().equals(other.getContents()) && Objects.equals(this.title, other.title);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)WikiToStringStyle.WIKI_TO_STRING_STYLE).append("offset", this.getOffset()).append("length", this.getLength()).append("src", (Object)ToStringHelper.toStringValue(this.src)).append("title", (Object)this.title).append("contents", this.getContents()).toString();
    }
}

