/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.shared;

import com.google.gwt.core.client.JsonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCodex {
    private static Map<Class<?>, Type> typesByClass = new HashMap();

    public static boolean canDecode(Class<?> clazz) {
        return typesByClass.containsKey(clazz);
    }

    public static <T> T convertFromString(Class<T> clazz, String encoded) {
        if (encoded == null) {
            return null;
        }
        return (T)ValueCodex.getType(clazz).decode(clazz, encoded);
    }

    public static String encodeForJsonPayload(Object obj) {
        return ValueCodex.getType(obj.getClass()).encode(obj);
    }

    private static <T> Type getType(Class<T> clazz) {
        Type type = typesByClass.get(clazz);
        if (type == null) {
            if (clazz.getEnumConstants() != null) {
                return Type.ENUM;
            }
            throw new IllegalArgumentException(clazz.getName());
        }
        return type;
    }

    static {
        for (Type t : Type.values()) {
            typesByClass.put(t.getType(), t);
            if (t.getPrimitiveType() == null) continue;
            typesByClass.put(t.getPrimitiveType(), t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        BIG_DECIMAL((Class)BigDecimal.class){

            @Override
            public BigDecimal decode(Class<?> clazz, String value) {
                return new BigDecimal(value);
            }
        }
        ,
        BIG_INTEGER((Class)BigInteger.class){

            @Override
            public BigInteger decode(Class<?> clazz, String value) {
                return new BigInteger(value);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE){

            @Override
            public Boolean decode(Class<?> clazz, String value) {
                return Boolean.valueOf(value);
            }
        }
        ,
        BYTE((Class)Byte.class, (Class)Byte.TYPE){

            @Override
            public Byte decode(Class<?> clazz, String value) {
                return Byte.valueOf(value);
            }
        }
        ,
        CHARACTER((Class)Character.class, (Class)Character.TYPE){

            @Override
            public Character decode(Class<?> clazz, String value) {
                return Character.valueOf(value.charAt(0));
            }
        }
        ,
        DATE((Class)Date.class){

            @Override
            public Date decode(Class<?> clazz, String value) {
                return new Date(Long.valueOf(value));
            }

            @Override
            public String encode(Object value) {
                return String.valueOf(((Date)value).getTime());
            }
        }
        ,
        DOUBLE((Class)Double.class, (Class)Double.TYPE){

            @Override
            public Double decode(Class<?> clazz, String value) {
                return Double.valueOf(value);
            }
        }
        ,
        ENUM((Class)Enum.class){

            @Override
            public Enum<?> decode(Class<?> clazz, String value) {
                return (Enum)clazz.getEnumConstants()[Integer.valueOf(value)];
            }

            @Override
            public String encode(Object value) {
                return String.valueOf(((Enum)value).ordinal());
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE){

            @Override
            public Float decode(Class<?> clazz, String value) {
                return Float.valueOf(value);
            }
        }
        ,
        INTEGER((Class)Integer.class, (Class)Integer.TYPE){

            @Override
            public Integer decode(Class<?> clazz, String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE){

            @Override
            public Long decode(Class<?> clazz, String value) {
                return Long.valueOf(value);
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE){

            @Override
            public Short decode(Class<?> clazz, String value) {
                return Short.valueOf(value);
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public String decode(Class<?> clazz, String value) {
                return value;
            }

            @Override
            public String encode(Object value) {
                return JsonUtils.escapeValue(String.valueOf(value));
            }
        }
        ,
        VOID((Class)Void.class, (Class)Void.TYPE){

            @Override
            public Void decode(Class<?> clazz, String value) {
                return null;
            }
        };

        private final Class<?> type;
        private final Class<?> primitiveType;

        private Type(Class<?> objectType) {
            this(objectType, null);
        }

        private Type(Class<?> objectType, Class<?> primitiveType) {
            this.type = objectType;
            this.primitiveType = primitiveType;
        }

        public abstract Object decode(Class<?> var1, String var2);

        public String encode(Object value) {
            return String.valueOf(value);
        }

        public Class<?> getPrimitiveType() {
            return this.primitiveType;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

