/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.resources.client.ExternalTextResource;
import com.google.gwt.resources.client.ResourceCallback;
import com.google.gwt.resources.client.ResourceException;
import com.google.gwt.resources.client.TextResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTextResourcePrototype
implements ExternalTextResource {
    private final TextResource[] cache;
    private final int index;
    private final String name;
    private final String url;

    private static native JavaScriptObject evalObject(String var0);

    private static native String extractString(JavaScriptObject var0, int var1);

    public ExternalTextResourcePrototype(String name, String url, TextResource[] cache, int index) {
        this.name = name;
        this.url = url;
        this.cache = cache;
        this.index = index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void getText(ResourceCallback<TextResource> callback) throws ResourceException {
        if (this.cache[this.index] != null) {
            callback.onSuccess(this.cache[this.index]);
            return;
        }
        RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, this.url);
        try {
            rb.sendRequest("", new ETRCallback(callback));
        }
        catch (RequestException e) {
            throw new ResourceException(this, "Unable to initiate request for external resource", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ETRCallback
    implements RequestCallback {
        final ResourceCallback<TextResource> callback;

        public ETRCallback(ResourceCallback<TextResource> callback) {
            this.callback = callback;
        }

        @Override
        public void onError(Request request, Throwable exception) {
            this.callback.onError(new ResourceException(ExternalTextResourcePrototype.this, "Unable to retrieve external resource", exception));
        }

        @Override
        public void onResponseReceived(Request request, Response response) {
            String responseText = response.getText();
            JavaScriptObject jso = ExternalTextResourcePrototype.evalObject(responseText);
            if (jso == null) {
                this.callback.onError(new ResourceException(ExternalTextResourcePrototype.this, "eval() returned null"));
                return;
            }
            for (int i = 0; i < ExternalTextResourcePrototype.this.cache.length; ++i) {
                final String resourceText = ExternalTextResourcePrototype.extractString(jso, i);
                ((ExternalTextResourcePrototype)ExternalTextResourcePrototype.this).cache[i] = new TextResource(){

                    public String getName() {
                        return ExternalTextResourcePrototype.this.name;
                    }

                    public String getText() {
                        return resourceText;
                    }
                };
            }
            this.callback.onSuccess(ExternalTextResourcePrototype.this.cache[ExternalTextResourcePrototype.this.index]);
        }
    }
}

