/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client;

import com.google.gwt.core.client.impl.WeakMapping;
import com.google.gwt.editor.client.AutoBean;
import com.google.gwt.editor.client.AutoBeanVisitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AutoBeanUtils {
    public static Map<String, Object> diff(AutoBean<?> a, AutoBean<?> b) {
        if (a.equals(b)) {
            return Collections.emptyMap();
        }
        final Map<String, Object> toReturn = AutoBeanUtils.getAllProperties(b);
        a.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> previousValue, AutoBeanVisitor.PropertyContext ctx) {
                if (toReturn.containsKey(propertyName)) {
                    if (this.equal(propertyName, previousValue)) {
                        toReturn.remove(propertyName);
                    }
                } else {
                    toReturn.put(propertyName, null);
                }
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object previousValue, AutoBeanVisitor.PropertyContext ctx) {
                if (toReturn.containsKey(propertyName)) {
                    if (this.equal(propertyName, previousValue)) {
                        toReturn.remove(propertyName);
                    }
                } else {
                    toReturn.put(propertyName, null);
                }
                return false;
            }

            private boolean equal(String propertyName, AutoBean<?> previousValue) {
                return previousValue == null && toReturn.get(propertyName) == null || previousValue != null && this.equal(propertyName, previousValue.as());
            }

            private boolean equal(String propertyName, Object previousValue) {
                return previousValue == null && toReturn.get(propertyName) == null || previousValue != null && previousValue.equals(toReturn.get(propertyName));
            }
        });
        return toReturn;
    }

    public static Map<String, Object> getAllProperties(AutoBean<?> bean) {
        final LinkedHashMap<String, Object> toReturn = new LinkedHashMap<String, Object>();
        bean.accept(new AutoBeanVisitor(){

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                toReturn.put(propertyName, value == null ? null : (Object)value.as());
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                toReturn.put(propertyName, value);
                return false;
            }
        });
        return toReturn;
    }

    public static <T, U extends T> AutoBean<T> getAutoBean(U delegate) {
        return delegate == null ? null : (AutoBean)WeakMapping.get(delegate, AutoBean.class.getName());
    }

    private AutoBeanUtils() {
    }
}

