/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.shared;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.UmbrellaException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEventBus
extends EventBus {
    private final boolean isReverseOrder;
    private int firingDepth = 0;
    private List<Scheduler.ScheduledCommand> deferredDeltas;
    private final Map<GwtEvent.Type<?>, Map<Object, List<?>>> map = new HashMap();

    public SimpleEventBus() {
        this(false);
    }

    @Deprecated
    SimpleEventBus(boolean fireInReverseOrder) {
        this.isReverseOrder = fireInReverseOrder;
    }

    @Override
    public <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        if (type == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAdd(type, null, handler);
    }

    @Override
    public <H extends EventHandler> HandlerRegistration addHandlerToSource(GwtEvent.Type<H> type, Object source, H handler) {
        if (type == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (source == null) {
            throw new NullPointerException("Cannot add a handler with a null source");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAdd(type, source, handler);
    }

    @Override
    public void fireEvent(GwtEvent<?> event) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        this.doFire(event, null);
    }

    @Override
    public void fireEventFromSource(GwtEvent<?> event, Object source) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        if (source == null) {
            throw new NullPointerException("Cannot fire from a null source");
        }
        this.doFire(event, source);
    }

    <H extends EventHandler> void doRemove(GwtEvent.Type<H> type, Object source, H handler) {
        if (this.firingDepth > 0) {
            this.enqueueRemove(type, source, handler);
        } else {
            this.doRemoveNow(type, source, handler);
        }
    }

    @Deprecated
    <H extends EventHandler> H getHandler(GwtEvent.Type<H> type, int index) {
        assert (index < this.getHandlerCount(type)) : "handlers for " + type.getClass() + " have size: " + this.getHandlerCount(type) + " so do not have a handler at index: " + index;
        List<H> l = this.getHandlerList(type, null);
        return (H)((EventHandler)l.get(index));
    }

    @Deprecated
    int getHandlerCount(GwtEvent.Type<?> eventKey) {
        return this.getHandlerList(eventKey, null).size();
    }

    @Deprecated
    boolean isEventHandled(GwtEvent.Type<?> eventKey) {
        return this.map.containsKey(eventKey);
    }

    private void defer(Scheduler.ScheduledCommand command) {
        if (this.deferredDeltas == null) {
            this.deferredDeltas = new ArrayList<Scheduler.ScheduledCommand>();
        }
        this.deferredDeltas.add(command);
    }

    private <H extends EventHandler> HandlerRegistration doAdd(final GwtEvent.Type<H> type, final Object source, final H handler) {
        if (this.firingDepth > 0) {
            this.enqueueAdd(type, source, handler);
        } else {
            this.doAddNow(type, source, handler);
        }
        return new HandlerRegistration(){

            public void removeHandler() {
                SimpleEventBus.this.doRemove(type, source, handler);
            }
        };
    }

    private <H extends EventHandler> void doAddNow(GwtEvent.Type<H> type, Object source, H handler) {
        List<H> l = this.ensureHandlerList(type, source);
        l.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <H extends EventHandler> void doFire(GwtEvent<H> event, Object source) {
        try {
            ListIterator<H> it;
            ++this.firingDepth;
            if (source != null) {
                event.setSource(source);
            }
            List<H> handlers = this.getDispatchList(event.getAssociatedType(), source);
            HashSet<Throwable> causes = null;
            ListIterator<H> listIterator = it = this.isReverseOrder ? handlers.listIterator(handlers.size()) : handlers.listIterator();
            while (this.isReverseOrder ? it.hasPrevious() : it.hasNext()) {
                EventHandler handler = this.isReverseOrder ? (EventHandler)it.previous() : (EventHandler)it.next();
                try {
                    event.dispatch(handler);
                }
                catch (Throwable e) {
                    if (causes == null) {
                        causes = new HashSet<Throwable>();
                    }
                    causes.add(e);
                }
            }
            if (causes != null) {
                throw new UmbrellaException(causes);
            }
        }
        finally {
            --this.firingDepth;
            if (this.firingDepth == 0) {
                this.handleQueuedAddsAndRemoves();
            }
        }
    }

    private <H> void doRemoveNow(GwtEvent.Type<H> type, Object source, H handler) {
        List<H> l = this.getHandlerList(type, source);
        boolean removed = l.remove(handler);
        assert (removed) : "redundant remove call";
        if (removed && l.isEmpty()) {
            this.prune(type, source);
        }
    }

    private <H extends EventHandler> void enqueueAdd(final GwtEvent.Type<H> type, final Object source, final H handler) {
        this.defer(new Scheduler.ScheduledCommand(){

            public void execute() {
                SimpleEventBus.this.doAddNow(type, source, handler);
            }
        });
    }

    private <H extends EventHandler> void enqueueRemove(final GwtEvent.Type<H> type, final Object source, final H handler) {
        this.defer(new Scheduler.ScheduledCommand(){

            public void execute() {
                SimpleEventBus.this.doRemoveNow(type, source, handler);
            }
        });
    }

    private <H> List<H> ensureHandlerList(GwtEvent.Type<H> type, Object source) {
        List<?> handlers;
        Map<Object, List<?>> sourceMap = this.map.get(type);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.map.put(type, sourceMap);
        }
        if ((handlers = sourceMap.get(source)) == null) {
            handlers = new ArrayList();
            sourceMap.put(source, handlers);
        }
        return handlers;
    }

    private <H> List<H> getDispatchList(GwtEvent.Type<H> type, Object source) {
        List<H> directHandlers = this.getHandlerList(type, source);
        if (source == null) {
            return directHandlers;
        }
        List<H> globalHandlers = this.getHandlerList(type, null);
        ArrayList<H> rtn = new ArrayList<H>(directHandlers);
        rtn.addAll(globalHandlers);
        return rtn;
    }

    private <H> List<H> getHandlerList(GwtEvent.Type<H> type, Object source) {
        Map<Object, List<?>> sourceMap = this.map.get(type);
        if (sourceMap == null) {
            return Collections.emptyList();
        }
        List<?> handlers = sourceMap.get(source);
        if (handlers == null) {
            return Collections.emptyList();
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueuedAddsAndRemoves() {
        if (this.deferredDeltas != null) {
            try {
                for (Scheduler.ScheduledCommand c : this.deferredDeltas) {
                    c.execute();
                }
            }
            finally {
                this.deferredDeltas = null;
            }
        }
    }

    private void prune(GwtEvent.Type<?> type, Object source) {
        Map<Object, List<?>> sourceMap = this.map.get(type);
        List<?> pruned = sourceMap.remove(source);
        assert (pruned != null) : "Can't prune what wasn't there";
        assert (pruned.isEmpty()) : "Pruned unempty list!";
        if (sourceMap.isEmpty()) {
            this.map.remove(type);
        }
    }
}

