/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.htmltext.commands;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.mylyn.htmltext.HtmlComposer;
import org.eclipse.mylyn.htmltext.model.TriState;

public abstract class Command {
    protected HtmlComposer composer;
    private TriState state;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public void execute() {
        this.composer.execute(this);
    }

    public Object executeWithReturn() {
        return this.composer.executeWithReturn(this);
    }

    public abstract String getCommandIdentifier();

    protected String getCommandDefinitionStub() {
        return "";
    }

    public String getCommand() {
        return "integration.executeCommand('" + this.getCommandIdentifier() + "');";
    }

    public TriState getState() {
        return this.state;
    }

    public void setState(TriState state) {
        TriState oldValue = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)oldValue, (Object)state);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        if (this.listeners.hasListeners(prop)) {
            this.listeners.firePropertyChange(prop, old, newValue);
        }
    }

    public void setComposer(HtmlComposer composer) {
        this.composer = composer;
        if (this.trackCommand()) {
            composer.trackCommand(this);
        }
    }

    protected boolean trackCommand() {
        return true;
    }

    public void dispose() {
    }
}

