/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.UserAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GitlabTaskEditorSummaryPart
extends TaskEditorSummaryPart {
    public void createControl(Composite parent, FormToolkit toolkit) {
        TaskAttribute userAssignedAttribute;
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        TaskAttribute priorityAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.priority");
        final Control priorityEditor = this.addPriorityAttributeWithIcon(composite, toolkit, priorityAttribute, false);
        if (priorityEditor != null) {
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).applyTo(priorityEditor);
            priorityEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (GitlabTaskEditorSummaryPart.this.summaryEditor != null && GitlabTaskEditorSummaryPart.this.summaryEditor.getControl() != null) {
                        GitlabTaskEditorSummaryPart.this.summaryEditor.getControl().setFocus();
                        priorityEditor.removeFocusListener((FocusListener)this);
                    }
                }
            });
            ++layout.numColumns;
        }
        this.addSummaryText(composite, toolkit);
        if (Boolean.parseBoolean(this.getModel().getTaskRepository().getProperty("gitlab.avantar")) && (userAssignedAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.user.assigned")) != null && !StringUtils.isBlank((CharSequence)userAssignedAttribute.getValue())) {
            UserAttributeEditor editor = new UserAttributeEditor(this.getModel(), userAssignedAttribute);
            editor.createControl(composite, toolkit);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).indent(0, 2).applyTo(editor.getControl());
            layout.marginRight = 1;
            ++layout.numColumns;
            TaskAttribute avatarURL = userAssignedAttribute.getAttribute("avatar_url");
            if (avatarURL != null) {
                GitlabRepositoryConnector gitlabConnector = (GitlabRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(userAssignedAttribute.getTaskData().getConnectorKind());
                byte[] avatarBytes = gitlabConnector.getAvatarData(avatarURL.getValue());
                editor.updateImage((IProfileImage)new ProfileImage(avatarBytes, 30, 30, ""));
            }
        }
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }
}

