/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.ConnectorBrand;
import org.eclipse.mylyn.internal.tasks.ui.IBrandManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectRepositoryConnectorPage
extends WizardPage {
    private TableViewer viewer;
    private ConnectorBrand connectorBrand;

    public SelectRepositoryConnectorPage() {
        super(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        this.setTitle(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        this.setDescription(Messages.SelectRepositoryConnectorPage_You_can_connect_to_an_existing_account_using_one_of_the_installed_connectors);
    }

    public boolean canFlipToNextPage() {
        return this.connectorBrand != null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 3).applyTo(container);
        this.viewer = new TableViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new ConnectorBrandContentProvider(TasksUiPlugin.getDefault().getBrandManager(), TasksUi.getRepositoryManager().getRepositoryConnectors()));
        this.viewer.setComparator((ViewerComparator)new TaskRepositoriesSorter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setInput((Object)TasksUi.getRepositoryManager().getRepositoryConnectors());
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.getFirstElement() instanceof ConnectorBrand) {
                this.setConnectorBrand((ConnectorBrand)selection.getFirstElement());
                this.setPageComplete(true);
            }
        });
        this.viewer.addOpenListener(event -> this.getContainer().showPage(this.getNextPage()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        final Command discoveryWizardCommand = TasksUiInternal.getConfiguredDiscoveryWizardCommand();
        if (discoveryWizardCommand != null && discoveryWizardCommand.isEnabled()) {
            Button discoveryButton = new Button(container, 8);
            GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)discoveryButton);
            discoveryButton.setText(Messages.SelectRepositoryConnectorPage_activateDiscovery);
            discoveryButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.DISCOVERY));
            discoveryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand(discoveryWizardCommand.getId(), null);
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)Messages.SelectRepositoryConnectorPage_discoveryProblemMessage, (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                        TasksUiInternal.logAndDisplayStatus(Messages.SelectRepositoryConnectorPage_discoveryProblemTitle, (IStatus)status);
                    }
                }
            });
        }
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    void setConnectorBrand(ConnectorBrand connectorBrand) {
        this.connectorBrand = connectorBrand;
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connectorBrand == null ? null : this.connectorBrand.getConnector();
    }

    public String getBrand() {
        return this.connectorBrand == null ? null : this.connectorBrand.getBrandId();
    }

    static class ConnectorBrandContentProvider
    implements IStructuredContentProvider {
        private final Collection<? extends AbstractRepositoryConnector> connectors;
        private final IBrandManager brandManager;

        public ConnectorBrandContentProvider(IBrandManager brandManager, Collection<? extends AbstractRepositoryConnector> connectors) {
            this.brandManager = brandManager;
            this.connectors = connectors;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            ArrayList<ConnectorBrand> connectorBrands = new ArrayList<ConnectorBrand>();
            for (AbstractRepositoryConnector abstractRepositoryConnector : this.connectors) {
                if (!abstractRepositoryConnector.isUserManaged() || !abstractRepositoryConnector.canCreateRepository()) continue;
                connectorBrands.add(new ConnectorBrand(abstractRepositoryConnector, null));
                for (String brand : this.brandManager.getBrands(abstractRepositoryConnector.getConnectorKind())) {
                    connectorBrands.add(new ConnectorBrand(abstractRepositoryConnector, brand));
                }
            }
            return connectorBrands.toArray();
        }
    }
}

