/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.requestfactory.shared.RequestEvent;
import com.google.gwt.requestfactory.shared.RequestTransport;
import com.google.gwt.user.client.Window;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultRequestTransport
implements RequestTransport {
    public static final String URL = "gwtRequest";
    private static Logger wireLogger = Logger.getLogger("WireActivityLogger");
    private static final String SERVER_ERROR = "Server Error";
    private final EventBus eventBus;
    private String requestUrl = GWT.getHostPageBaseURL() + "gwtRequest";

    public DefaultRequestTransport(EventBus eventBus) {
        if (eventBus == null) {
            throw new IllegalArgumentException("eventBus must not be null");
        }
        this.eventBus = eventBus;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void send(String payload, RequestTransport.TransportReceiver receiver) {
        RequestBuilder builder = this.createRequestBuilder();
        this.configureRequestBuilder(builder);
        builder.setRequestData(payload);
        builder.setCallback(this.createRequestCallback(receiver));
        try {
            wireLogger.finest("Sending fire request");
            builder.send();
            this.postRequestEvent(RequestEvent.State.SENT, null);
        }
        catch (RequestException e) {
            wireLogger.log(Level.SEVERE, "Server Error (" + e.getMessage() + ")", e);
        }
    }

    public void setRequestUrl(String url) {
        this.requestUrl = url;
    }

    protected void configureRequestBuilder(RequestBuilder builder) {
        builder.setHeader("Content-Type", "application/json; charset=utf-8");
        builder.setHeader("pageurl", Window.Location.getHref());
        builder.setHeader("X-GWT-Permutation", GWT.getPermutationStrongName());
    }

    protected RequestBuilder createRequestBuilder() {
        return new RequestBuilder(RequestBuilder.POST, this.getRequestUrl());
    }

    protected RequestCallback createRequestCallback(final RequestTransport.TransportReceiver receiver) {
        return new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                DefaultRequestTransport.this.postRequestEvent(RequestEvent.State.RECEIVED, null);
                wireLogger.log(Level.SEVERE, DefaultRequestTransport.SERVER_ERROR, exception);
                receiver.onTransportFailure(exception.getMessage());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponseReceived(Request request, Response response) {
                wireLogger.finest("Response received");
                try {
                    if (200 == response.getStatusCode()) {
                        String text = response.getText();
                        receiver.onTransportSuccess(text);
                    } else if (401 == response.getStatusCode()) {
                        String message = "Need to log in";
                        wireLogger.finest(message);
                        receiver.onTransportFailure(message);
                    } else if (response.getStatusCode() > 0) {
                        String message = "Server Error " + response.getStatusCode() + " " + response.getText();
                        wireLogger.severe(message);
                        receiver.onTransportFailure(message);
                    }
                }
                finally {
                    DefaultRequestTransport.this.postRequestEvent(RequestEvent.State.RECEIVED, response);
                }
            }
        };
    }

    private void postRequestEvent(RequestEvent.State received, Response response) {
        this.eventBus.fireEvent(new RequestEvent(received, response));
    }
}

