/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListDropAdapter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;

public class TaskListDropAdapterTest
extends TestCase {
    private TaskListDropAdapter dropAdapter;
    private TaskList taskList;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        TreeViewer viewer = TaskListView.getFromActivePerspective().getViewer();
        TaskListDropAdapterTest.assertNotNull((Object)viewer);
        this.dropAdapter = new TaskListDropAdapter((Viewer)viewer);
        this.taskList = TasksUiPlugin.getTaskList();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskList();
    }

    public void testUrlDrop() {
        TaskListDropAdapterTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        String url = "http://eclipse.org/mylyn";
        String title = "Mylyn Project";
        String urlData = url + "\n" + title;
        this.dropAdapter.performDrop((Object)urlData);
        Collection tasks = this.taskList.getDefaultCategory().getChildren();
        TaskListDropAdapterTest.assertNotNull((Object)tasks);
        TaskListDropAdapterTest.assertEquals((int)1, (int)tasks.size());
        TaskListDropAdapterTest.assertEquals((String)url, (String)((ITask)tasks.iterator().next()).getUrl());
    }
}

