/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.File;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.AttachmentFileStorage;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

class AttachmentFileEditorInput
extends PlatformObject
implements IPathEditorInput,
IStorageEditorInput {
    private final File file;
    private final String name;
    private final String tooltipText;

    AttachmentFileEditorInput(File file, String name, String tooltipText) {
        this.file = file;
        this.name = name;
        this.tooltipText = tooltipText;
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.file.getAbsolutePath());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltipText;
    }

    public IStorage getStorage() throws CoreException {
        return new AttachmentFileStorage(this.file, this.name);
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.name.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (!(obj instanceof AttachmentFileEditorInput)) {
            return false;
        }
        AttachmentFileEditorInput attachmentFileEditorInput = (AttachmentFileEditorInput)((Object)obj);
        return this.name.equals(other.name) && this.file.equals(other.file);
    }
}

