/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.MylynResourceMissingException;

@Deprecated
public class TestUtil {
    @Deprecated
    public static final String KEY_CREDENTIALS_FILE = "mylyn.credentials";

    @Deprecated
    public static Credentials readCredentials() {
        return TestUtil.readCredentials(PrivilegeLevel.USER, null);
    }

    @Deprecated
    public static Credentials readCredentials(PrivilegeLevel level) {
        return TestUtil.readCredentials(level, null);
    }

    @Deprecated
    public static Credentials readCredentials(PrivilegeLevel level, String realm) {
        Properties properties = new Properties();
        try {
            File file;
            String filename = System.getProperty(KEY_CREDENTIALS_FILE);
            if (filename == null) {
                try {
                    file = TestUtil.getFile(TestUtil.class, "credentials.properties");
                    if (!file.exists()) {
                        throw new MylynResourceMissingException("Can't find 'credentials.properties'");
                    }
                }
                catch (MylynResourceMissingException e) {
                    file = new File(new File(System.getProperty("user.home"), ".mylyn"), "credentials.properties");
                }
            } else {
                file = new File(filename);
            }
            properties.load(new FileInputStream(file));
        }
        catch (Exception e) {
            MylynResourceMissingException error = new MylynResourceMissingException("must define credentials in $HOME/.mylyn/credentials.properties");
            error.initCause((Throwable)e);
            throw error;
        }
        String defaultPassword = properties.getProperty("pass");
        realm = realm != null ? (String)realm + "." : "";
        return switch (level) {
            case PrivilegeLevel.ANONYMOUS -> TestUtil.createCredentials(properties, (String)realm + "anon.", "", "");
            case PrivilegeLevel.GUEST -> TestUtil.createCredentials(properties, (String)realm + "guest.", "guest@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.USER -> TestUtil.createCredentials(properties, (String)realm, "tests@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.READ_ONLY -> TestUtil.createCredentials(properties, (String)realm, "read-only@mylyn.eclipse.org", defaultPassword);
            case PrivilegeLevel.ADMIN -> TestUtil.createCredentials(properties, (String)realm + "admin.", "admin@mylyn.eclipse.org", null);
            default -> throw new MylynResourceMissingException("invalid privilege level");
        };
    }

    private static Credentials createCredentials(Properties properties, String prefix, String defaultUsername, String defaultPassword) {
        String username = properties.getProperty(prefix + "user");
        String password = properties.getProperty(prefix + "pass");
        if (username == null) {
            username = defaultUsername;
        }
        if (password == null) {
            password = defaultPassword;
        }
        if (username == null || password == null) {
            throw new MylynResourceMissingException("username or password not found in <plug-in dir>/credentials.properties, make sure file is valid");
        }
        return new Credentials(username, password);
    }

    @Deprecated
    public static File getFile(Object source, String filename) throws IOException {
        return CommonTestUtil.getFile((Object)source, (String)filename);
    }

    @Deprecated
    public static boolean runHeartbeatTestsOnly() {
        return !Boolean.getBoolean("org.eclipse.mylyn.tests.all");
    }

    @Deprecated
    public static class Credentials {
        @Deprecated
        public final String username;
        @Deprecated
        public final String password;

        @Deprecated
        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Deprecated
        public String toString() {
            return this.getClass().getSimpleName() + " [username=" + this.username + ",password=" + this.password + "]";
        }

        @Deprecated
        public String getShortUserName() {
            if (this.username.contains("@")) {
                return this.username.substring(0, this.username.indexOf("@"));
            }
            return this.username;
        }
    }

    public static enum PrivilegeLevel {
        ANONYMOUS,
        GUEST,
        USER,
        ADMIN,
        READ_ONLY;

    }
}

