/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.AutoBean;
import com.google.gwt.editor.client.AutoBeanFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Provides base implementations of AutoBeanFactory methods.
 */
public abstract class AbstractAutoBeanFactory implements AutoBeanFactory {
  /**
   * Implementations generated by subtypes. Used to implement the dynamic create
   * methods.
   */
  protected interface Creator {
    AutoBean<?> create();

    AutoBean<?> create(Object delegate);
  }

  protected final Map<Class<?>, Creator> creators = new HashMap<Class<?>, Creator>();

  @SuppressWarnings("unchecked")
  public <T, U extends T> AutoBean<T> create(Class<T> clazz, U delegate) {
    Creator c = creators.get(clazz);
    return c == null ? null : (AutoBean<T>) c.create(delegate);
  }

  @SuppressWarnings("unchecked")
  public <T> AutoBean<T> create(Class<T> clazz) {
    Creator c = creators.get(clazz);
    return c == null ? null : (AutoBean<T>) c.create();
  }
}
