/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.e4.selection;

import java.util.List;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionUtils;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;

public class E4SelectionListener<T>
implements ILayerListener {
    private ESelectionService selectionService;
    private SelectionLayer selectionLayer;
    private IRowDataProvider<T> rowDataProvider;
    private boolean fullySelectedRowsOnly = true;
    private boolean handleSameRowSelection = false;
    private List<T> previousSelection;
    private boolean processColumnSelection = true;
    private boolean multiSelection = true;

    public E4SelectionListener(ESelectionService service, SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        this.selectionService = service;
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof ISelectionEvent) {
            List selection = SelectionUtils.getSelectedRowObjects((SelectionLayer)this.selectionLayer, this.rowDataProvider, (boolean)this.fullySelectedRowsOnly);
            if (!(!this.handleSameRowSelection && selection.equals(this.previousSelection) || !this.processColumnSelection && event instanceof ColumnSelectionEvent)) {
                try {
                    if (this.multiSelection) {
                        this.selectionService.setSelection((Object)selection);
                    } else {
                        this.selectionService.setSelection(!selection.isEmpty() ? selection.get(0) : null);
                    }
                }
                finally {
                    this.previousSelection = selection;
                }
            }
        }
    }

    public boolean isFullySelectedRowsOnly() {
        return this.fullySelectedRowsOnly;
    }

    public void setFullySelectedRowsOnly(boolean fullySelectedRowsOnly) {
        this.fullySelectedRowsOnly = fullySelectedRowsOnly;
    }

    public boolean isHandleSameRowSelection() {
        return this.handleSameRowSelection;
    }

    public void setHandleSameRowSelection(boolean handleSameRowSelection) {
        this.handleSameRowSelection = handleSameRowSelection;
    }

    public boolean isProcessColumnSelection() {
        return this.processColumnSelection;
    }

    public void setProcessColumnSelection(boolean processColumnSelection) {
        this.processColumnSelection = processColumnSelection;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }
}

