/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    NSScrollView scrollView;
    String text;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    NSColor linkColor;

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean textView_clickOnLink_atIndex(int n, int n2, int n3, int n4, int n5) {
        NSString nSString = new NSString(n4);
        Event event = new Event();
        event.text = nSString.getString();
        this.sendEvent(13, event);
        return true;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = this.hasBorder() ? 2 : 0;
        NSSize nSSize = NSScrollView.frameSizeForContentSize(new NSSize(), false, false, n3);
        NSTextView nSTextView = (NSTextView)this.view;
        NSSize nSSize2 = nSTextView.textStorage().size();
        int n4 = (int)(nSSize2.width + nSSize.width);
        int n5 = (int)(nSSize2.height + nSSize.height);
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        int n6 = this.getBorderWidth();
        n4 += n6 * 2;
        return new Point(++n4, n5 += n6 * 2);
    }

    void createHandle() {
        this.state |= 0x800;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setDrawsBackground(false);
        nSScrollView.setBorderType(this.hasBorder() ? 2 : 0);
        NSTextView nSTextView = (NSTextView)new SWTTextView().alloc();
        nSTextView.init();
        nSTextView.setEditable(false);
        nSTextView.setDrawsBackground(false);
        nSTextView.setDelegate(nSTextView);
        nSTextView.setAutoresizingMask(18);
        nSTextView.textContainer().setLineFragmentPadding(0.0f);
        this.scrollView = nSScrollView;
        this.view = nSTextView;
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        NSDictionary nSDictionary = ((NSTextView)this.view).linkTextAttributes();
        this.linkColor = new NSColor(nSDictionary.valueForKey(OS.NSForegroundColorAttributeName));
    }

    NSFont defaultNSFont() {
        return this.display.textViewFont;
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        NSColor nSColor = null;
        nSColor = bl ? (this.foreground == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(this.foreground[0], this.foreground[1], this.foreground[2], this.foreground[3])) : NSColor.disabledControlTextColor();
        NSTextView nSTextView = (NSTextView)this.view;
        nSTextView.setTextColor(nSColor);
        NSDictionary nSDictionary = nSTextView.linkTextAttributes();
        int n = nSDictionary.count();
        NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(n);
        nSMutableDictionary.setDictionary(nSDictionary);
        nSMutableDictionary.setValue(bl ? this.linkColor : nSColor, OS.NSForegroundColorAttributeName);
        nSTextView.setLinkTextAttributes(nSMutableDictionary);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void register() {
        super.register();
        if (this.scrollView != null) {
            this.display.addWidget(this.scrollView, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
        this.linkColor = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n8, n9), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    void updateBackground() {
        NSColor nSColor = null;
        if (this.backgroundImage != null) {
            nSColor = NSColor.colorWithPatternImage(this.backgroundImage.handle);
        } else if (this.background != null) {
            nSColor = NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]);
        }
        this.setBackground(nSColor);
    }

    void setBackground(NSColor nSColor) {
        NSTextView nSTextView = (NSTextView)this.view;
        if (nSColor == null) {
            nSTextView.setDrawsBackground(false);
        } else {
            nSTextView.setDrawsBackground(true);
            nSTextView.setBackgroundColor(nSColor);
        }
    }

    void setFont(NSFont nSFont) {
        ((NSTextView)this.view).setFont(nSFont);
    }

    void setForeground(float[] fArray) {
        if (!this.getEnabled()) {
            return;
        }
        NSColor nSColor = fArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], 1.0f);
        ((NSTextView)this.view).setTextColor(nSColor);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        NSTextView nSTextView = (NSTextView)this.view;
        nSTextView.setString(NSString.stringWith(this.parse(string)));
        NSTextStorage nSTextStorage = nSTextView.textStorage();
        NSRange nSRange = new NSRange();
        int n = 0;
        while (n < this.offsets.length) {
            nSRange.location = this.offsets[n].x;
            nSRange.length = this.offsets[n].y - this.offsets[n].x + 1;
            nSTextStorage.addAttribute(OS.NSLinkAttributeName, NSString.stringWith(this.ids[n]), nSRange);
            ++n;
        }
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        return this.scrollView;
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(bl, this.scrollView);
        NSClipView nSClipView = this.scrollView.contentView();
        this.updateCursorRects(bl, nSClipView);
        nSClipView.setDocumentCursor(bl ? NSCursor.IBeamCursor() : null);
    }
}

