/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;

public class Bullet {
    public int type;
    public StyleRange style;
    public String text;
    int[] linesIndices;
    int count;

    public Bullet(StyleRange styleRange) {
        this(1, styleRange);
    }

    public Bullet(int n, StyleRange styleRange) {
        if (styleRange == null) {
            SWT.error(4);
        }
        if (styleRange.metrics == null) {
            SWT.error(4);
        }
        this.type = n;
        this.style = styleRange;
    }

    void addIndices(int n, int n2) {
        if (this.linesIndices == null) {
            this.linesIndices = new int[n2];
            this.count = n2;
            int n3 = 0;
            while (n3 < n2) {
                this.linesIndices[n3] = n + n3;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.count) {
                if (n <= this.linesIndices[n4]) break;
                ++n4;
            }
            int n5 = n4;
            while (n5 < this.count) {
                if (n + n2 <= this.linesIndices[n5]) break;
                ++n5;
            }
            int n6 = n4 + n2 + this.count - n5;
            if (n6 > this.linesIndices.length) {
                int[] nArray = new int[n6];
                System.arraycopy(this.linesIndices, 0, nArray, 0, this.count);
                this.linesIndices = nArray;
            }
            System.arraycopy(this.linesIndices, n5, this.linesIndices, n4 + n2, this.count - n5);
            int n7 = 0;
            while (n7 < n2) {
                this.linesIndices[n4 + n7] = n + n7;
                ++n7;
            }
            this.count = n6;
        }
    }

    int indexOf(int n) {
        int n2 = 0;
        while (n2 < this.count) {
            if (this.linesIndices[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int hashCode() {
        return this.style.hashCode() ^ this.type;
    }

    int[] removeIndices(int n, int n2, int n3, boolean bl) {
        if (this.count == 0) {
            return null;
        }
        if (n > this.linesIndices[this.count - 1]) {
            return null;
        }
        int n4 = n + n2;
        int n5 = n3 - n2;
        int n6 = 0;
        while (n6 < this.count) {
            int n7 = this.linesIndices[n6];
            if (n <= n7) {
                int n8 = n6;
                while (n8 < this.count) {
                    if (this.linesIndices[n8] >= n4) break;
                    ++n8;
                }
                if (bl) {
                    int n9 = n8;
                    while (n9 < this.count) {
                        int n10 = n9++;
                        this.linesIndices[n10] = this.linesIndices[n10] + n5;
                    }
                }
                int[] nArray = new int[this.count - n8];
                System.arraycopy(this.linesIndices, n8, nArray, 0, this.count - n8);
                System.arraycopy(this.linesIndices, n8, this.linesIndices, n6, this.count - n8);
                this.count -= n8 - n6;
                return nArray;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.count) {
            int n11 = n6++;
            this.linesIndices[n11] = this.linesIndices[n11] + n5;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

