/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int handle;
    int index;
    byte[] settingsData;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyleBit(shell, n));
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyleBit(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0 && ((n &= 0xEFFFFFFF) & n2) == 0) {
            n |= shell == null ? 65536 : 32768;
        }
        if ((n & n2) == 0) {
            n |= 0x10000;
        }
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
    }

    public int getScope() {
        return this.printerData.scope;
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    public PrinterData open() {
        int n;
        Object[] objectArray;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] byArray = Converter.wcsToMbcs(null, this.getText(), true);
        int n2 = this.getParent().handle;
        while (n2 != 0 && !OS.GTK_IS_WINDOW(n2)) {
            n2 = OS.gtk_widget_get_parent(n2);
        }
        this.handle = OS.gtk_print_unix_dialog_new(byArray, n2);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7);
        int n3 = OS.gtk_print_settings_new();
        int n4 = OS.gtk_page_setup_new();
        if (this.printerData.otherData != null) {
            Printer.restore(this.printerData.otherData, n3, n4);
        }
        switch (this.printerData.scope) {
            case 0: {
                OS.gtk_print_settings_set_print_pages(n3, 0);
                break;
            }
            case 1: {
                OS.gtk_print_settings_set_print_pages(n3, 2);
                objectArray = new int[]{this.printerData.startPage - 1, this.printerData.endPage - 1};
                OS.gtk_print_settings_set_page_ranges(n3, objectArray, 1);
                break;
            }
            case 2: {
                OS.gtk_print_settings_set_print_pages(n3, 0);
            }
        }
        if (this.printerData.fileName != null) {
            if (this.printerData.printToFile) {
                objectArray = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(n3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, (byte[])objectArray);
            }
            if (this.printerData.driver != null && this.printerData.name != null && this.printerData.driver.equals("GtkPrintBackendFile") && this.printerData.name.equals("Print to File")) {
                objectArray = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(n3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, (byte[])objectArray);
            }
        }
        if (this.printerData.printToFile) {
            objectArray = Converter.wcsToMbcs(null, "Print to File", true);
            OS.gtk_print_settings_set_printer(n3, (byte[])objectArray);
        }
        OS.gtk_print_settings_set_n_copies(n3, this.printerData.copyCount);
        OS.gtk_print_settings_set_collate(n3, this.printerData.collate);
        int n5 = this.printerData.orientation == 2 ? 1 : 0;
        OS.gtk_print_settings_set_orientation(n3, n5);
        OS.gtk_page_setup_set_orientation(n4, n5);
        OS.gtk_print_unix_dialog_set_settings(this.handle, n3);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, n4);
        OS.g_object_unref(n3);
        OS.g_object_unref(n4);
        OS.gtk_window_set_modal(this.handle, true);
        PrinterData printerData = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        int n6 = 0;
        int n7 = 0;
        if ((this.getStyle() & 0x4000000) != 0) {
            n6 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n7 = OS.g_signal_add_emission_hook(n6, 0, ((LONG)display.getData((String)GET_EMISSION_PROC_KEY)).value, this.handle, 0);
        }
        display.setData(ADD_IDLE_PROC_KEY, null);
        Object object = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            object = display.getData(GET_MODAL_DIALOG);
            display.setData(SET_MODAL_DIALOG, this);
        }
        int n8 = OS.gtk_dialog_run(this.handle);
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setData(SET_MODAL_DIALOG, object);
        }
        if ((this.getStyle() & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n6, n7);
        }
        if (n8 == -5 && (n = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0) {
            Object[] objectArray2;
            int n9;
            Object object2;
            n3 = OS.gtk_print_unix_dialog_get_settings(this.handle);
            n4 = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            printerData = Printer.printerDataFromGtkPrinter(n);
            int n10 = OS.gtk_print_settings_get_print_pages(n3);
            switch (n10) {
                case 0: {
                    printerData.scope = 0;
                    break;
                }
                case 2: {
                    printerData.scope = 1;
                    object2 = new int[1];
                    n9 = OS.gtk_print_settings_get_page_ranges(n3, (int[])object2);
                    objectArray2 = new int[2];
                    int n11 = object2[0];
                    int n12 = Integer.MAX_VALUE;
                    int n13 = 0;
                    int n14 = 0;
                    while (n14 < n11) {
                        OS.memmove(objectArray2, n9 + n14 * objectArray2.length * 4, objectArray2.length * 4);
                        n12 = Math.min(n12, objectArray2[0] + 1);
                        n13 = Math.max(n13, objectArray2[1] + 1);
                        ++n14;
                    }
                    OS.g_free(n9);
                    printerData.startPage = n12 == Integer.MAX_VALUE ? 1 : n12;
                    printerData.endPage = n13 == 0 ? 1 : n13;
                    break;
                }
                case 1: {
                    printerData.scope = 2;
                    printerData.startPage = printerData.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            printerData.printToFile = printerData.name.equals("Print to File");
            if (printerData.printToFile) {
                int n15 = OS.gtk_print_settings_get(n3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                n9 = OS.strlen(n15);
                objectArray2 = new byte[n9];
                OS.memmove((byte[])objectArray2, n15, n9);
                printerData.fileName = new String(Converter.mbcsToWcs(null, (byte[])objectArray2));
            }
            printerData.copyCount = OS.gtk_print_settings_get_n_copies(n3);
            printerData.collate = OS.gtk_print_settings_get_collate(n3);
            printerData.orientation = OS.gtk_page_setup_get_orientation(n4) == 1 ? 2 : 1;
            object2 = new Callback(this, "GtkPrintSettingsFunc", 3);
            n9 = ((Callback)object2).getAddress();
            if (n9 == 0) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(n3, n9, 0);
            ((Callback)object2).dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(n4));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(n4, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(n4, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(n4, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(n4, 3));
            int n16 = OS.gtk_page_setup_get_paper_size(n4);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(n16));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(n16));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(n16));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(n16, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(n16, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(n16));
            printerData.otherData = this.settingsData;
            OS.g_object_unref(n3);
            this.printerData = printerData;
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return printerData;
    }

    int GtkPrintSettingsFunc(int n, int n2, int n3) {
        int n4 = OS.strlen(n);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n, n4);
        n4 = OS.strlen(n2);
        byte[] byArray2 = new byte[n4];
        OS.memmove(byArray2, n2, n4);
        this.store(byArray, byArray2);
        return 0;
    }

    void store(String string, int n) {
        this.store(string, String.valueOf(n));
    }

    void store(String string, double d) {
        this.store(string, String.valueOf(d));
    }

    void store(String string, boolean bl) {
        this.store(string, String.valueOf(bl));
    }

    void storeBytes(String string, int n) {
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        this.store(string.getBytes(), byArray);
    }

    void store(String string, String string2) {
        this.store(string.getBytes(), string2.getBytes());
    }

    void store(byte[] byArray, byte[] byArray2) {
        int n = byArray.length + 1 + byArray2.length + 1;
        if (this.index + n + 1 > this.settingsData.length) {
            byte[] byArray3 = new byte[this.settingsData.length + Math.max(n + 1, 1024)];
            System.arraycopy(this.settingsData, 0, byArray3, 0, this.settingsData.length);
            this.settingsData = byArray3;
        }
        System.arraycopy(byArray, 0, this.settingsData, this.index, byArray.length);
        this.index += byArray.length + 1;
        System.arraycopy(byArray2, 0, this.settingsData, this.index, byArray2.length);
        this.index += byArray2.length + 1;
    }
}

