/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String PIXMAP = "PIXMAP";
    private static final int PIXMAP_ID = ImageTransfer.registerType("PIXMAP");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        ImageData imageData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imageData = (ImageData)object) == null) {
            SWT.error(4);
        }
        Image image = new Image((Device)Display.getCurrent(), imageData);
        int n = image.pixmap;
        int n2 = OS.XtMalloc(4);
        if (n2 == 0) {
            return;
        }
        OS.memmove(n2, new int[]{n}, 4);
        transferData.type = PIXMAP_ID;
        transferData.format = 32;
        transferData.length = 1;
        transferData.pValue = n2;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.length;
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[1];
        OS.memmove(nArray, transferData.pValue, n * 4);
        Image image = Image.motif_new(Display.getCurrent(), 0, nArray[0], 0);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    protected int[] getTypeIds() {
        return new int[]{PIXMAP_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{PIXMAP};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

