/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XTextProperty;
import org.eclipse.swt.widgets.Display;

public class TextTransfer
extends ByteArrayTransfer {
    static TextTransfer _instance = new TextTransfer();
    static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    static final String STRING = "STRING";
    static final int COMPOUND_TEXT_ID = TextTransfer.registerType("COMPOUND_TEXT");
    static final int STRING_ID = TextTransfer.registerType("STRING");

    TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        byte[] byArray;
        block11: {
            transferData.result = 0;
            if (!this.checkText(object) || !this.isSupportedType(transferData)) {
                DND.error(2003);
            }
            String string = (String)object;
            byArray = Converter.wcsToMbcs(null, string, true);
            if (transferData.type != COMPOUND_TEXT_ID) break block11;
            Display display = Display.getCurrent();
            if (display == null) {
                return;
            }
            int n = display.xDisplay;
            int n2 = OS.XtMalloc(byArray.length);
            if (n2 == 0) {
                return;
            }
            try {
                XTextProperty xTextProperty;
                block14: {
                    block13: {
                        int n3;
                        block12: {
                            OS.memmove(n2, byArray, byArray.length);
                            n3 = OS.XtMalloc(4);
                            if (n3 != 0) break block12;
                            break block13;
                        }
                        OS.memmove(n3, new int[]{n2}, 4);
                        xTextProperty = new XTextProperty();
                        int n4 = OS.XmbTextListToTextProperty(n, n3, 1, 1, xTextProperty);
                        OS.XtFree(n3);
                        if (n4 == 0) break block14;
                    }
                    Object var11_10 = null;
                    OS.XtFree(n2);
                    return;
                }
                transferData.format = xTextProperty.format;
                transferData.length = xTextProperty.nitems;
                transferData.pValue = xTextProperty.value;
                transferData.type = xTextProperty.encoding;
                transferData.result = 1;
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                OS.XtFree(n2);
                throw throwable;
            }
            OS.XtFree(n2);
        }
        if (transferData.type == STRING_ID) {
            int n = OS.XtMalloc(byArray.length);
            if (n == 0) {
                return;
            }
            OS.memmove(n, byArray, byArray.length);
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = byArray.length - 1;
            transferData.pValue = n;
            transferData.result = 1;
        }
    }

    public Object nativeToJava(TransferData transferData) {
        Object object;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        byte[] byArray = null;
        if (transferData.type == COMPOUND_TEXT_ID) {
            object = Display.getCurrent();
            if (object == null) {
                return null;
            }
            int n = ((Display)object).xDisplay;
            XTextProperty xTextProperty = new XTextProperty();
            xTextProperty.encoding = transferData.type;
            xTextProperty.format = transferData.format;
            xTextProperty.nitems = transferData.length;
            xTextProperty.value = transferData.pValue;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n2 = OS.XmbTextPropertyToTextList(n, xTextProperty, nArray, nArray2);
            if (n2 != 0 || nArray[0] == 0) {
                return null;
            }
            int[] nArray3 = new int[1];
            OS.memmove(nArray3, nArray[0], 4);
            int n3 = OS.strlen(nArray3[0]);
            byArray = new byte[n3];
            OS.memmove(byArray, nArray3[0], n3);
            OS.XFreeStringList(nArray[0]);
        }
        if (transferData.type == STRING_ID) {
            int n = transferData.format * transferData.length / 8;
            if (n == 0) {
                return null;
            }
            byArray = new byte[n];
            OS.memmove(byArray, transferData.pValue, n);
        }
        if (byArray == null) {
            return null;
        }
        object = Converter.mbcsToWcs(null, byArray);
        String string = new String((char[])object);
        int n = string.indexOf(0);
        return n == -1 ? string : string.substring(0, n);
    }

    protected int[] getTypeIds() {
        return new int[]{COMPOUND_TEXT_ID, STRING_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

