/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XColor;

public final class Color
extends Resource {
    public XColor handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue);
        this.init();
    }

    void destroy() {
        int n = this.device.xDisplay;
        int n2 = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n3 = n2;
            this.device.colorRefCount[n3] = this.device.colorRefCount[n3] - 1;
            if (this.device.colorRefCount[n3] == 0) {
                this.device.xcolors[n2] = null;
            }
        }
        int n4 = OS.XDefaultColormap(n, OS.XDefaultScreen(n));
        OS.XFreeColors(n, n4, new int[]{n2}, 1, 0);
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        XColor xColor = color.handle;
        if (this.handle == xColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == xColor.red && this.handle.green == xColor.green && this.handle.blue == xColor.blue;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle.red >> 8 & 0xFF, this.handle.green >> 8 & 0xFF, this.handle.blue >> 8 & 0xFF);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue;
    }

    void init(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        XColor xColor = new XColor();
        xColor.red = (short)(n & 0xFF | (n & 0xFF) << 8);
        xColor.green = (short)(n2 & 0xFF | (n2 & 0xFF) << 8);
        xColor.blue = (short)(n3 & 0xFF | (n3 & 0xFF) << 8);
        this.handle = xColor;
        int n6 = this.device.xDisplay;
        int n7 = OS.XDefaultScreen(n6);
        int n8 = OS.XDefaultColormap(n6, n7);
        if (OS.XAllocColor(n6, n8, xColor) != 0) {
            if (this.device.colorRefCount != null) {
                XColor xColor2 = new XColor();
                xColor2.red = xColor.red;
                xColor2.green = xColor.green;
                xColor2.blue = xColor.blue;
                xColor2.pixel = xColor.pixel;
                this.device.xcolors[xColor2.pixel] = xColor2;
                int n9 = xColor.pixel;
                this.device.colorRefCount[n9] = this.device.colorRefCount[n9] + 1;
            }
            return;
        }
        Visual visual = new Visual();
        OS.memmove(visual, OS.XDefaultVisual(n6, n7), 32);
        int n10 = visual.map_entries;
        XColor[] xColorArray = new XColor[n10];
        int[] nArray = new int[n10];
        int n11 = 0;
        while (n11 < n10) {
            XColor xColor3 = new XColor();
            xColor3.pixel = n11;
            xColorArray[n11] = xColor3;
            OS.XQueryColor(n6, n8, xColor3);
            n5 = n - (xColor3.red >> 8 & 0xFF);
            n4 = n2 - (xColor3.green >> 8 & 0xFF);
            int n12 = n3 - (xColor3.blue >> 8 & 0xFF);
            nArray[n11] = n5 * n5 + n4 * n4 + n12 * n12;
            ++n11;
        }
        n11 = 0;
        while (n11 < n10) {
            int n13 = 196608;
            n5 = 0;
            n4 = 0;
            while (n4 < n10) {
                if (nArray[n4] < n13) {
                    n13 = nArray[n4];
                    n5 = n4;
                }
                ++n4;
            }
            XColor xColor4 = xColorArray[n5];
            XColor xColor5 = new XColor();
            xColor5.red = xColor4.red;
            xColor5.green = xColor4.green;
            xColor5.blue = xColor4.blue;
            if (OS.XAllocColor(n6, n8, xColor5) != 0) {
                xColor.red = xColor5.red;
                xColor.green = xColor5.green;
                xColor.blue = xColor5.blue;
                xColor.pixel = xColor5.pixel;
                if (this.device.colorRefCount != null) {
                    this.device.xcolors[xColor5.pixel] = xColor5;
                    int n14 = xColor5.pixel;
                    this.device.colorRefCount[n14] = this.device.colorRefCount[n14] + 1;
                }
                return;
            }
            nArray[n5] = 196608;
            ++n11;
        }
        XColor xColor6 = new XColor();
        OS.XAllocColor(n6, n8, xColor6);
        xColor.red = xColor6.red;
        xColor.green = xColor6.green;
        xColor.blue = xColor6.blue;
        xColor.pixel = xColor6.pixel;
        if (this.device.colorRefCount != null) {
            this.device.xcolors[xColor6.pixel] = xColor6;
            int n15 = xColor6.pixel;
            this.device.colorRefCount[n15] = this.device.colorRefCount[n15] + 1;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public static Color motif_new(Device device, XColor xColor) {
        Color color = new Color(device);
        color.handle = xColor;
        return color;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

