/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    int accelerator;
    Menu parent;
    Menu menu;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(-1);
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        if (n2 == -1) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    void addAccelerator() {
        byte[] byArray;
        int n;
        int n2;
        int n3;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        if (OS.IsSunOS) {
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if ((this.accelerator & 0x10000) != 0) {
            string2 = "Meta ";
        }
        if ((this.accelerator & 0x20000) != 0) {
            string = "Shift ";
        }
        if ((this.accelerator & 0x40000) != 0) {
            string3 = "Ctrl ";
        }
        n2 = (n3 = Display.untranslateKey(n2 = this.accelerator & 0x100FFFF)) != 0 ? n3 : Display.wcsToMbcs((char)n2);
        String string4 = String.valueOf(string3) + string2 + string + "<Key>" + this.keysymName(n2);
        String string5 = String.valueOf(string4) + ",Lock " + string4;
        String string6 = Display.numLock;
        if (string6 != null) {
            string5 = String.valueOf(string5) + "," + string6 + " " + string4 + ",Lock " + string6 + " " + string4;
        }
        if ((n = OS.XtMalloc((byArray = Converter.wcsToMbcs(null, string5, true)).length)) != 0) {
            OS.memmove(n, byArray, byArray.length);
        }
        int[] nArray = new int[]{OS.XmNaccelerator, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (n != 0) {
            OS.XtFree(n);
        }
    }

    void addAccelerators() {
        this.addAccelerator();
        if (this.menu != null) {
            this.menu.addAccelerators();
        }
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        int n2;
        int[] nArray;
        int n3 = this.parent.handle;
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNchildren;
        nArray2[2] = OS.XmNnumChildren;
        int[] nArray3 = nArray2;
        OS.XtGetValues(n3, nArray3, nArray3.length / 2);
        if (n != -1 && nArray3[1] != 0) {
            nArray = new int[nArray3[3]];
            OS.memmove(nArray, nArray3[1], nArray3[3] * 4);
            n2 = 0;
            int n4 = 0;
            while (n2 < nArray3[3]) {
                if (OS.XtIsManaged(nArray[n2])) {
                    if (n == n4) break;
                    ++n4;
                }
                ++n2;
            }
            if (n != n4) {
                this.error(6);
            }
            n = n2;
        }
        if ((this.style & 2) != 0) {
            nArray = new int[]{OS.XmNancestorSensitive, 1, OS.XmNorientation, (this.parent.style & 2) != 0 ? 1 : 2, OS.XmNpositionIndex, n};
            this.handle = OS.XmCreateSeparatorGadget(n3, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        nArray = new int[]{OS.XmNancestorSensitive, 1, OS.XmNpositionIndex, n};
        if ((this.style & 8) != 0) {
            this.handle = OS.XmCreatePushButtonGadget(n3, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        if ((this.style & 0x30) != 0) {
            this.handle = OS.XmCreateToggleButtonGadget(n3, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            n2 = 2;
            if ((this.style & 0x20) != 0) {
                n2 = 1;
            }
            int[] nArray4 = new int[]{OS.XmNindicatorType, n2};
            OS.XtSetValues(this.handle, nArray4, nArray4.length / 2);
            return;
        }
        this.handle = OS.XmCreateCascadeButtonGadget(n3, null, nArray, nArray.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void destroyWidget() {
        OS.XtUnmanageChild(this.handle);
        super.destroyWidget();
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.XtIsManaged(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return new Rectangle((short)nArray2[1], (short)nArray2[3], nArray2[5], nArray2[7]);
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNset;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    void hookEvents() {
        if ((this.style & 2) != 0) {
            return;
        }
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, n, 17);
        if ((this.style & 0x40) != 0) {
            OS.XtAddCallback(this.handle, OS.XmNactivateCallback, n, 9);
            OS.XtAddCallback(this.handle, OS.XmNcascadingCallback, n, 12);
        } else {
            OS.XtAddCallback(this.handle, OS.XmNarmCallback, n, 10);
            if ((this.style & 0x30) != 0) {
                OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
            } else {
                OS.XtAddCallback(this.handle, OS.XmNactivateCallback, n, 9);
            }
        }
    }

    boolean isAccelActive() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return false;
        }
        Decorations decorations = menu.parent;
        return decorations.menuBar == menu;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    String keysymName(int n) {
        switch (n) {
            case 8: {
                return "BackSpace";
            }
            case 9: {
                return "Tab";
            }
            case 10: 
            case 13: 
            case 65290: {
                return "Return";
            }
            case 27: {
                return "Escape";
            }
            case 127: {
                return "Delete";
            }
        }
        if (48 <= n && n <= 57 || 97 <= n && n <= 122 || 65 <= n && n <= 90) {
            return new String(new char[]{(char)n});
        }
        int n2 = OS.XKeysymToString(n);
        if (n2 == 0) {
            return "";
        }
        int n3 = OS.strlen(n2);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    void manageChildren() {
        OS.XtManageChild(this.handle);
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        if (this == this.parent.defaultItem) {
            this.parent.defaultItem = null;
        }
        this.parent = null;
    }

    void removeAccelerator() {
        if (this.accelerator == 0) {
            return;
        }
        if (OS.IsSunOS) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNaccelerator;
        int[] nArray2 = nArray;
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
    }

    void removeAccelerators() {
        this.removeAccelerator();
        if (this.menu != null) {
            this.menu.removeAccelerators();
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        int n = 0;
        MenuItem[] menuItemArray = this.parent.getItems();
        while (n < menuItemArray.length && menuItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && menuItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < menuItemArray.length && menuItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        this.accelerator = n;
        if (this.isAccelActive()) {
            if (n != 0) {
                this.addAccelerator();
            } else {
                this.removeAccelerator();
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (this.getEnabled() == bl) {
            return;
        }
        int[] nArray = new int[]{OS.XmNsensitive, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (this.isAccelActive()) {
            if (bl) {
                this.addAccelerator();
            } else {
                this.removeAccelerator();
            }
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        boolean bl = this.isAccelActive();
        if (bl) {
            this.removeAccelerators();
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        int n = 0;
        if (menu != null) {
            menu.cascade = this;
            n = menu.handle;
        }
        int[] nArray = new int[]{OS.XmNsubMenuId, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (bl) {
            this.addAccelerators();
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNset, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setText(String string) {
        Object[] objectArray;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        if ((this.style & 6) != 0) {
            return;
        }
        if (OS.IsLinux && (this.style & 0x30) != 0 && string.length() == 0) {
            string = " ";
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\t') {
                bl = true;
                break;
            }
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (n3 == 0) {
                n3 = cArray[n];
            }
            --n2;
        }
        int n4 = 0;
        if (bl && ++n < cArray.length) {
            objectArray = new char[cArray.length - n];
            System.arraycopy(cArray, n, objectArray, 0, objectArray.length);
            byte[] byArray = Converter.wcsToMbcs(null, objectArray, true);
            n4 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            if (n4 == 0) {
                this.error(13);
            }
        } else {
            n4 = OS.XmStringGenerate(new byte[1], null, 0, null);
            if (n4 == 0) {
                this.error(13);
            }
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        objectArray = Converter.wcsToMbcs(null, cArray, true);
        int n5 = OS.XmStringParseText((byte[])objectArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (n5 == 0) {
            this.error(13);
        }
        if (n3 == 0) {
            n3 = 0xFFFFFF;
        }
        int[] nArray = new int[]{OS.XmNlabelString, n5, OS.XmNmnemonic, n3, OS.XmNacceleratorText, n4};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (n5 != 0) {
            OS.XmStringFree(n5);
        }
        if (n4 != 0) {
            OS.XmStringFree(n4);
        }
    }

    boolean translateAccelerator(int n, boolean bl) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.menu != null) {
            return this.menu.translateAccelerator(n, bl);
        }
        int n2 = this.accelerator;
        if ((n2 & 0x1000000) == 0) {
            int n3 = n2 & 0x100FFFF;
            if (65 <= n3 && n3 <= 90) {
                n3 += 32;
            }
            int n4 = n2 & SWT.MODIFIER_MASK;
            n2 = n4 | n3;
        }
        if (n2 == n) {
            if (bl) {
                this.postEvent(13);
            }
            return true;
        }
        return false;
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        if ((this.style & 0x40) != 0) {
            this.sendEvent(30);
        }
        if (!this.isEnabled()) {
            return 0;
        }
        XmAnyCallbackStruct xmAnyCallbackStruct = new XmAnyCallbackStruct();
        OS.memmove(xmAnyCallbackStruct, n3, 8);
        Event event = new Event();
        if (xmAnyCallbackStruct.event != 0) {
            XButtonEvent xButtonEvent = new XButtonEvent();
            OS.memmove(xButtonEvent, xmAnyCallbackStruct.event, 60);
            event.time = xButtonEvent.time;
            switch (xButtonEvent.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setInputState(event, xButtonEvent.state);
                }
            }
        }
        this.postEvent(13, event);
        return 0;
    }

    int XmNarmCallback(int n, int n2, int n3) {
        this.sendEvent(30);
        return 0;
    }

    int XmNcascadingCallback(int n, int n2, int n3) {
        this.sendEvent(30);
        return 0;
    }

    int XmNhelpCallback(int n, int n2, int n3) {
        if (this.hooks(28)) {
            this.postEvent(28);
            return 0;
        }
        this.parent.sendHelpEvent(n3);
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            return 0;
        }
        XmAnyCallbackStruct xmAnyCallbackStruct = new XmAnyCallbackStruct();
        OS.memmove(xmAnyCallbackStruct, n3, 8);
        Event event = new Event();
        if (xmAnyCallbackStruct.event != 0) {
            XButtonEvent xButtonEvent = new XButtonEvent();
            OS.memmove(xButtonEvent, xmAnyCallbackStruct.event, 60);
            event.time = xButtonEvent.time;
            switch (xButtonEvent.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.setInputState(event, xButtonEvent.state);
                }
            }
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }
}

