/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    boolean dragSent = false;

    ScrollBar() {
    }

    ScrollBar(Scrollable scrollable, int n) {
        super(scrollable, ScrollBar.checkStyle(n));
        this.parent = scrollable;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void createHandle(int n) {
        int[] nArray = new int[8];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNborderWidth;
        nArray[3] = (this.style & 0x800) != 0 ? 1 : 0;
        nArray[4] = OS.XmNorientation;
        nArray[5] = (this.style & 0x100) != 0 ? 2 : 1;
        nArray[6] = OS.XmNtraversalOn;
        int[] nArray2 = nArray;
        int n2 = this.parent.scrolledHandle;
        this.handle = OS.XmCreateScrollBar(n2, null, nArray2, nArray2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void destroyHandle() {
        super.destroyWidget();
    }

    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrement;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNpageIncrement;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvalue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public Point getSize() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[5] * 2;
        return new Point(nArray2[1] + n, nArray2[3] + n);
    }

    public int getThumb() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsliderSize;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.XtIsManaged(this.handle);
    }

    void hookEvents() {
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, n, 15);
        OS.XtAddCallback(this.handle, OS.XmNtoBottomCallback, n, 22);
        OS.XtAddCallback(this.handle, OS.XmNtoTopCallback, n, 23);
        OS.XtAddCallback(this.handle, OS.XmNincrementCallback, n, 18);
        OS.XtAddCallback(this.handle, OS.XmNdecrementCallback, n, 13);
        OS.XtAddCallback(this.handle, OS.XmNpageIncrementCallback, n, 21);
        OS.XtAddCallback(this.handle, OS.XmNpageDecrementCallback, n, 20);
        OS.XtAddEventHandler(this.handle, 4, false, n, 1);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void manageChildren() {
        int n = this.parent.scrolledHandle;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        if (n != 0) {
            OS.XtGetValues(n, nArray2, nArray2.length / 2);
        }
        OS.XtManageChild(this.handle);
        if (n != 0) {
            OS.XtResizeWidget(n, nArray2[1], nArray2[3], nArray2[5]);
        }
    }

    void propagateWidget(boolean bl) {
        this.propagateHandle(bl, this.handle, 0);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendScrollEvent(int n) {
        Event event = new Event();
        event.detail = n;
        this.sendEvent(13, event);
        Shell shell = this.parent.getShell();
        shell.bringToTop(true);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNsensitive, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNincrement, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNmaximum, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        nArray[4] = OS.XmNsliderSize;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[3] - n - nArray2[5] < 0) {
            nArray2[5] = nArray2[3] - n;
        }
        nArray2[1] = n;
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.setWarnings(bl);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNpageIncrement, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNvalue, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        n = Math.min(n, nArray2[3] - nArray2[1]);
        int[] nArray3 = new int[]{OS.XmNsliderSize, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        this.display.setWarnings(bl);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        int[] nArray = new int[]{OS.XmNvalue, n, OS.XmNminimum, n2, OS.XmNmaximum, n3, OS.XmNsliderSize, n4, OS.XmNincrement, n5, OS.XmNpageIncrement, n6};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.parent.setScrollBarVisible(this, bl)) {
            this.sendEvent(bl ? 22 : 23);
            this.parent.sendEvent(11);
        }
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        this.dragSent = false;
        return n5;
    }

    int XmNdecrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000001);
        return 0;
    }

    int XmNdragCallback(int n, int n2, int n3) {
        this.dragSent = true;
        this.sendScrollEvent(1);
        return 0;
    }

    int XmNincrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000002);
        return 0;
    }

    int XmNpageDecrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000005);
        return 0;
    }

    int XmNpageIncrementCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000006);
        return 0;
    }

    int XmNtoBottomCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000008);
        return 0;
    }

    int XmNtoTopCallback(int n, int n2, int n3) {
        this.sendScrollEvent(0x1000007);
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        if (!this.dragSent) {
            this.sendScrollEvent(1);
            this.dragSent = false;
        }
        this.sendScrollEvent(0);
        return 0;
    }
}

