/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    int index = -1;
    boolean checked;
    boolean grayed;
    boolean cached;
    String[] texts;
    int[] textWidths = new int[1];
    int customWidth = -1;
    int fontHeight;
    int[] fontHeights;
    int imageIndent;
    Image[] images;
    Color foreground;
    Color background;
    String[] displayTexts;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font font;
    Font[] cellFonts;
    static final int MARGIN_TEXT = 3;

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull((Table)table).itemsCount);
    }

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        int n3 = table.itemsCount;
        if (n2 < 0 || n2 > n3) {
            this.error(6);
        }
        this.parent = table;
        this.index = n2;
        int n4 = table.columns.length;
        if (n4 > 0) {
            this.displayTexts = new String[n4];
            if (n4 > 1) {
                this.texts = new String[n4];
                this.textWidths = new int[n4];
                this.images = new Image[n4];
            }
        }
        if (bl) {
            table.createItem(this);
        }
    }

    void addColumn(TableColumn tableColumn) {
        Object object;
        Object[] objectArray;
        int n = tableColumn.getIndex();
        int n2 = this.parent.columns.length;
        if (n2 > 1) {
            if (n2 == 2) {
                this.texts = new String[2];
            } else {
                objectArray = new String[n2];
                System.arraycopy(this.texts, 0, objectArray, 0, n);
                System.arraycopy(this.texts, n, objectArray, n + 1, n2 - n - 1);
                this.texts = objectArray;
            }
            if (n == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (n2 == 2) {
                this.images = new Image[2];
            } else {
                objectArray = new Image[n2];
                System.arraycopy(this.images, 0, objectArray, 0, n);
                System.arraycopy(this.images, n, objectArray, n + 1, n2 - n - 1);
                this.images = objectArray;
            }
            if (n == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
            objectArray = new int[n2];
            System.arraycopy(this.textWidths, 0, objectArray, 0, n);
            System.arraycopy(this.textWidths, n, objectArray, n + 1, n2 - n - 1);
            this.textWidths = (int[])objectArray;
        } else {
            this.customWidth = -1;
        }
        objectArray = new String[n2];
        if (n2 > 1) {
            System.arraycopy(this.displayTexts, 0, objectArray, 0, n);
            System.arraycopy(this.displayTexts, n, objectArray, n + 1, n2 - n - 1);
        }
        this.displayTexts = objectArray;
        if (this.cellBackgrounds != null) {
            object = new Color[n2];
            System.arraycopy(this.cellBackgrounds, 0, object, 0, n);
            System.arraycopy(this.cellBackgrounds, n, object, n + 1, n2 - n - 1);
            this.cellBackgrounds = object;
        }
        if (this.cellForegrounds != null) {
            object = new Color[n2];
            System.arraycopy(this.cellForegrounds, 0, object, 0, n);
            System.arraycopy(this.cellForegrounds, n, object, n + 1, n2 - n - 1);
            this.cellForegrounds = object;
        }
        if (this.cellFonts != null) {
            object = new Font[n2];
            System.arraycopy(this.cellFonts, 0, object, 0, n);
            System.arraycopy(this.cellFonts, n, object, n + 1, n2 - n - 1);
            this.cellFonts = object;
            int[] nArray = new int[n2];
            System.arraycopy(this.fontHeights, 0, nArray, 0, n);
            System.arraycopy(this.fontHeights, n, nArray, n + 1, n2 - n - 1);
            this.fontHeights = nArray;
        }
        if (n == 0 && n2 > 1 && (this.parent.style & 0x20) != 0) {
            object = new GC(this.parent);
            ((GC)object).setFont(this.getFont(1, false));
            this.computeDisplayText(1, (GC)object);
            ((Resource)object).dispose();
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.grayed = false;
        this.checked = false;
        this.texts = null;
        this.textWidths = new int[1];
        this.fontHeight = 0;
        this.fontHeights = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.displayTexts = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.cached = false;
        this.text = "";
        this.image = null;
        int n = this.parent.columns.length;
        if (n > 0) {
            this.displayTexts = new String[n];
            if (n > 1) {
                this.texts = new String[n];
                this.textWidths = new int[n];
                this.images = new Image[n];
            }
        }
    }

    void computeDisplayText(int n, GC gC) {
        Object object;
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n2 = this.parent.columns.length;
        if (n2 == 0) {
            String string = this.getText(0, false);
            this.textWidths[n] = gC.stringExtent((String)string).x;
            return;
        }
        TableColumn tableColumn = this.parent.columns[n];
        int n3 = tableColumn.width - 2 * this.parent.getCellPadding() - 6;
        if (n == 0) {
            n3 -= this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                n3 -= 3;
            }
            if ((this.parent.style & 0x20) != 0) {
                n3 -= this.parent.checkboxBounds.width;
                n3 -= 3;
            }
        } else {
            object = this.getImage(n, false);
            if (object != null) {
                n3 -= ((Image)object).getBounds().width;
                n3 -= 3;
            }
        }
        object = this.getText(n, false);
        int n4 = gC.stringExtent((String)object).x;
        if (n4 <= n3) {
            this.displayTexts[n] = object;
            this.textWidths[n] = n4;
            return;
        }
        int n5 = gC.stringExtent((String)"...").x;
        if ((n3 -= n5) <= 0) {
            this.displayTexts[n] = "...";
            this.textWidths[n] = n5;
            return;
        }
        int n6 = Math.min(n3 / gC.getFontMetrics().getAverageCharWidth(), ((String)object).length());
        n4 = gC.stringExtent((String)((String)object).substring((int)0, (int)n6)).x;
        if (n3 == n4) {
            this.displayTexts[n] = String.valueOf(((String)object).substring(0, n6)) + "...";
            this.textWidths[n] = n4 + n5;
            return;
        }
        if (n3 < n4) {
            do {
                if (--n6 < 0) {
                    this.displayTexts[n] = "...";
                    this.textWidths[n] = n5;
                    return;
                }
                object = ((String)object).substring(0, n6);
            } while (n3 < (n4 = gC.stringExtent((String)object).x));
            this.displayTexts[n] = String.valueOf(object) + "...";
            this.textWidths[n] = n4 + n5;
            return;
        }
        int n7 = 0;
        while (n4 < n3) {
            n7 = n4;
            n4 = gC.stringExtent((String)((String)object).substring((int)0, (int)(++n6))).x;
        }
        this.displayTexts[n] = String.valueOf(((String)object).substring(0, n6 - 1)) + "...";
        this.textWidths[n] = n7 + n5;
    }

    void computeDisplayTexts(GC gC) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n = this.parent.columns.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            gC.setFont(this.getFont(n2, false));
            this.computeDisplayText(n2, gC);
            ++n2;
        }
    }

    void computeTextWidths(GC gC) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n = Math.max(1, this.parent.columns.length);
        this.textWidths = new int[n];
        int n2 = 0;
        while (n2 < this.textWidths.length) {
            String string = this.getDisplayText(n2);
            if (string != null) {
                gC.setFont(this.getFont(n2, false));
                this.textWidths[n2] = gC.stringExtent((String)string).x;
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Table table = this.parent;
        int n = this.index;
        int n2 = table.itemsCount - 1;
        this.dispose(true);
        table.redrawItems(n, n2, false);
    }

    void dispose(boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        if (bl) {
            this.parent.destroyItem(this);
        }
        super.dispose();
        this.foreground = null;
        this.background = null;
        this.cellForegrounds = null;
        this.cellBackgrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.images = null;
        this.displayTexts = null;
        this.texts = null;
        this.fontHeights = null;
        this.textWidths = null;
        this.parent = null;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[n] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[n];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(true);
    }

    Rectangle getBounds(boolean bl) {
        TableColumn tableColumn;
        int n;
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = this.getTextX(0);
        int n3 = this.textWidths[0] + 6;
        if (this.parent.columns.length > 0 && n2 + n3 > (n = (tableColumn = this.parent.columns[0]).getX() + tableColumn.width)) {
            n3 = Math.max(0, n - n2);
        }
        return new Rectangle(n2, this.parent.getItemY(this), n3, this.parent.itemHeight);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TableColumn[] tableColumnArray = this.parent.columns;
        int n2 = tableColumnArray.length;
        int n3 = Math.max(1, n2);
        if (n < 0 || n >= n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 == 0) {
            int n4 = this.getContentWidth(0);
            return new Rectangle(this.getContentX(0), this.parent.getItemY(this), n4, this.parent.itemHeight - 1);
        }
        TableColumn tableColumn = tableColumnArray[n];
        if (n == 0) {
            int n5 = this.getContentX(0);
            int n6 = n5 - tableColumn.getX();
            int n7 = Math.max(0, tableColumn.width - n6 - 1);
            return new Rectangle(n5, this.parent.getItemY(this) + 1, n7, this.parent.itemHeight - 1);
        }
        return new Rectangle(tableColumn.getX(), this.parent.getItemY(this) + 1, tableColumn.width, this.parent.itemHeight - 1);
    }

    Rectangle getCellBounds(int n) {
        int n2 = this.parent.getItemY(this);
        if (this.parent.columns.length == 0) {
            int n3;
            if (this.customWidth != -1) {
                n3 = this.getContentX(0) + this.customWidth + this.parent.horizontalOffset;
            } else {
                int n4 = this.textWidths[0] + 6;
                n3 = this.getTextX(0) + n4 + this.parent.horizontalOffset;
            }
            return new Rectangle(-this.parent.horizontalOffset, n2, n3, this.parent.itemHeight);
        }
        TableColumn tableColumn = this.parent.columns[n];
        return new Rectangle(tableColumn.getX(), n2, tableColumn.width, this.parent.itemHeight);
    }

    Rectangle getCheckboxBounds() {
        if ((this.parent.getStyle() & 0x20) == 0) {
            return null;
        }
        Rectangle rectangle = this.parent.checkboxBounds;
        rectangle.x = this.parent.columns.length == 0 ? this.parent.getCellPadding() - this.parent.horizontalOffset : this.parent.columns[0].getX() + this.parent.getCellPadding();
        rectangle.y = this.parent.getItemY(this) + (this.parent.itemHeight - rectangle.height) / 2;
        return rectangle;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.checked;
    }

    int getContentWidth(int n) {
        int n2 = this.textWidths[n] + 6;
        if (n == 0) {
            n2 += this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                n2 += 3;
            }
        } else {
            Image image = this.getImage(n, false);
            if (image != null) {
                n2 += image.getBounds().width + 3;
            }
        }
        return n2;
    }

    int getContentX(int n) {
        Object object;
        int n2 = this.parent.getCellPadding();
        if (n == 0 && (object = this.getCheckboxBounds()) != null) {
            n2 += ((Rectangle)object).width + 3;
        }
        if (this.parent.columns.length == 0) {
            return n2 - this.parent.horizontalOffset;
        }
        object = this.parent.columns[n];
        int n3 = ((TableColumn)object).getX();
        if ((((TableColumn)object).style & 0x4000) != 0) {
            return n3 + n2;
        }
        int n4 = this.getContentWidth(n);
        int n5 = 0;
        n5 = (((TableColumn)object).style & 0x20000) != 0 ? ((TableColumn)object).width - this.parent.getCellPadding() - n4 : (((TableColumn)object).width - n4) / 2;
        return Math.max(n3 + n2, n3 + n5);
    }

    String getDisplayText(int n) {
        if (this.parent.columns.length == 0) {
            return this.getText(0, false);
        }
        String string = this.displayTexts[n];
        return string != null ? string : "";
    }

    Rectangle getFocusBounds() {
        int n;
        int n2 = 0;
        TableColumn[] tableColumnArray = this.parent.columns;
        int[] nArray = this.parent.getColumnOrder();
        if ((this.parent.style & 0x10000) != 0) {
            int n3 = n = nArray.length == 0 ? 0 : nArray[0];
            n2 = n == 0 ? this.getTextX(0) : -this.parent.horizontalOffset;
        } else {
            n2 = this.getTextX(0);
        }
        if (tableColumnArray.length > 0) {
            n = tableColumnArray[0].getX() + tableColumnArray[0].width;
            n2 = Math.min(n2, n - 1);
        }
        if (tableColumnArray.length == 0) {
            n = this.customWidth != -1 ? this.customWidth : this.textWidths[0] + 6;
        } else {
            TableColumn tableColumn = (this.parent.style & 0x10000) != 0 ? tableColumnArray[nArray[nArray.length - 1]] : tableColumnArray[0];
            n = tableColumn.getX() + tableColumn.width - n2 - 1;
        }
        return new Rectangle(n2, this.parent.getItemY(this) + (this.parent.linesVisible ? 1 : 0), n, this.parent.itemHeight - (this.parent.linesVisible ? 1 : 0));
    }

    public Font getFont() {
        this.checkWidget();
        return this.getFont(true);
    }

    Font getFont(boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        return this.getFont(n, true);
    }

    Font getFont(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getFont(bl);
        }
        if (this.cellFonts == null || this.cellFonts[n] == null) {
            return this.getFont(bl);
        }
        return this.cellFonts[n];
    }

    int getFontHeight() {
        if (this.fontHeight != 0) {
            return this.fontHeight;
        }
        return this.parent.fontHeight;
    }

    int getFontHeight(int n) {
        if (this.fontHeights == null || this.fontHeights[n] == 0) {
            return this.getFontHeight();
        }
        return this.fontHeights[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[n] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[n];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.grayed;
    }

    Rectangle getHitBounds() {
        int n;
        int[] nArray = this.parent.getColumnOrder();
        int n2 = 0;
        if ((this.parent.style & 0x10000) != 0) {
            int n3 = n = nArray.length == 0 ? 0 : nArray[0];
            n2 = n == 0 ? this.getContentX(0) : 0;
        } else {
            n2 = this.getContentX(0);
        }
        n = 0;
        TableColumn[] tableColumnArray = this.parent.columns;
        if (tableColumnArray.length == 0) {
            n = this.getContentWidth(0);
        } else {
            TableColumn tableColumn = (this.parent.style & 0x10000) != 0 ? tableColumnArray[nArray[nArray.length - 1]] : tableColumnArray[0];
            n = tableColumn.getX() + tableColumn.width - n2;
        }
        return new Rectangle(n2, this.parent.getItemY(this), n, this.parent.itemHeight);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        return this.getImage(n, true);
    }

    Image getImage(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return null;
        }
        if (n == 0) {
            return super.getImage();
        }
        return this.images[n];
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.getCellPadding();
        int n4 = this.getContentX(n);
        int n5 = this.parent.itemHeight;
        int n6 = n5 - 2 * n3;
        int n7 = this.parent.getItemY(this);
        Image image = this.getImage(n, false);
        int n8 = 0;
        if (n == 0) {
            n8 = this.parent.col0ImageWidth;
        } else if (image != null) {
            n8 = image.getBounds().width;
        }
        return new Rectangle(n4, n7 + n3, n8, n6);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.imageIndent;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(int n) {
        Object object;
        int n2 = 0;
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        n2 += gC.stringExtent((String)this.getText((int)n, (boolean)false)).x + 6;
        if (n == 0) {
            if (this.parent.col0ImageWidth > 0) {
                n2 += this.parent.col0ImageWidth;
                n2 += 3;
            }
        } else {
            object = this.getImage(n, false);
            if (object != null) {
                n2 += ((Image)object).getBounds().width;
                n2 += 3;
            }
        }
        if (this.parent.hooks(41)) {
            object = new Event();
            ((Event)object).item = this;
            ((Event)object).gc = gC;
            ((Event)object).index = n;
            ((Event)object).x = this.getContentX(n);
            ((Event)object).y = this.parent.getItemY(this);
            ((Event)object).width = n2;
            ((Event)object).height = this.parent.itemHeight;
            this.parent.sendEvent(41, (Event)object);
            if (this.parent.itemHeight != ((Event)object).height) {
                this.parent.customHeightSet = true;
                boolean bl = this.parent.setItemHeight(((Event)object).height + 2 * this.parent.getCellPadding());
                if (bl) {
                    this.parent.redraw();
                }
            }
            n2 = ((Event)object).width;
        }
        gC.dispose();
        if (n == 0 && (this.parent.style & 0x20) != 0) {
            n2 += this.parent.checkboxBounds.width;
            n2 += 3;
        }
        return n2 + 2 * this.parent.getCellPadding();
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        return this.getText(n, true);
    }

    String getText(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return "";
        }
        if (n == 0) {
            return super.getText();
        }
        if (this.texts[n] == null) {
            return "";
        }
        return this.texts[n];
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TableColumn[] tableColumnArray = this.parent.columns;
        int n2 = tableColumnArray.length;
        int n3 = Math.max(1, n2);
        if (n < 0 || n >= n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 == 0) {
            int n4 = this.getTextX(0) + 3;
            int n5 = Math.max(0, this.getContentX(0) + this.getContentWidth(0) - n4);
            return new Rectangle(n4, this.parent.getItemY(this), n5, this.parent.itemHeight - 1);
        }
        TableColumn tableColumn = tableColumnArray[n];
        if (n == 0) {
            int n6 = this.getTextX(0) + 3;
            int n7 = n6 - tableColumn.getX();
            int n8 = Math.max(0, tableColumn.width - n7 - 1);
            return new Rectangle(n6, this.parent.getItemY(this) + 1, n8, this.parent.itemHeight - 1);
        }
        int n9 = this.getTextX(n) + 3;
        int n10 = n9 - tableColumn.getX();
        int n11 = Math.max(0, tableColumn.width - n10 - 3);
        return new Rectangle(n9, this.parent.getItemY(this) + 1, n11, this.parent.itemHeight - 1);
    }

    int getTextX(int n) {
        int n2 = this.getContentX(n);
        if (n == 0) {
            n2 += this.parent.col0ImageWidth;
            if (this.parent.col0ImageWidth > 0) {
                n2 += 3;
            }
        } else {
            Image image = this.getImage(n, false);
            if (image != null) {
                n2 += image.getBounds().width + 3;
            }
        }
        return n2;
    }

    boolean isInViewport() {
        int n = this.parent.topIndex;
        if (this.index < n) {
            return false;
        }
        int n2 = this.parent.clientArea.height / this.parent.itemHeight;
        return this.index <= n + n2;
    }

    boolean isSelected() {
        return this.parent.getSelectionIndex(this) != -1;
    }

    boolean paint(GC gC, TableColumn tableColumn, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        if (!this.parent.checkData(this, true)) {
            return false;
        }
        int n6 = 0;
        int n7 = 0;
        if (tableColumn != null) {
            n6 = tableColumn.getIndex();
            n7 = tableColumn.getX();
        }
        int n8 = gC.getAlpha();
        boolean bl2 = gC.getAdvanced();
        int n9 = gC.getAntialias();
        Pattern pattern = gC.getBackgroundPattern();
        Pattern pattern2 = gC.getForegroundPattern();
        int n10 = gC.getInterpolation();
        int n11 = gC.getTextAntialias();
        if (this.parent.hooks(41)) {
            int n12 = this.getContentWidth(n6);
            int n13 = this.getContentX(n6);
            gC.setFont(this.getFont(n6, false));
            Event event = new Event();
            event.item = this;
            event.gc = gC;
            event.index = n6;
            event.x = n13;
            event.y = this.parent.getItemY(this);
            event.width = n12;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            event.gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setTextAntialias(n11);
            gC.setAdvanced(bl2);
            if (this.isDisposed()) {
                return false;
            }
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                n5 = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding()) ? 1 : 0;
                if (n5 != 0) {
                    this.parent.redraw();
                }
            }
            if (this.parent.columns.length == 0) {
                n5 = event.width - (this.customWidth != -1 ? this.customWidth : n12);
                if (event.width != n12 || this.customWidth != -1) {
                    this.customWidth = event.width;
                }
                if (n5 != 0) {
                    this.parent.updateHorizontalBar(n13 + event.width, n5);
                }
            }
        }
        Rectangle rectangle = this.parent.clientArea;
        if (rectangle.x + rectangle.width < n7) {
            return false;
        }
        Rectangle rectangle2 = this.getCellBounds(n6);
        if (this.parent.linesVisible) {
            ++rectangle2.y;
            --rectangle2.height;
        }
        int n14 = 0;
        n14 = tableColumn != null ? tableColumn.getX() + tableColumn.width : rectangle2.x + rectangle2.width;
        gC.setClipping(n7, rectangle2.y, rectangle.width - n7, rectangle2.height);
        n5 = this.parent.getItemY(this);
        int n15 = this.parent.itemHeight;
        if (tableColumn == null) {
            this.parent.drawBackground(gC, 0, n5, rectangle.width, n15);
        } else {
            n4 = rectangle2.width;
            if (this.parent.linesVisible) {
                --n4;
            }
            this.parent.drawBackground(gC, rectangle2.x, rectangle2.y, n4, rectangle2.height);
        }
        n4 = this.isSelected() ? 1 : 0;
        int n16 = this.parent.focusItem == this && this.parent.isFocusControl() ? 1 : 0;
        int n17 = 1;
        int n18 = 1;
        int n19 = n4;
        int n20 = n16;
        if (this.parent.hooks(40)) {
            n17 = this.background == null && (this.cellBackgrounds == null || this.cellBackgrounds[n6] == null) ? 0 : 1;
            gC.setFont(this.getFont(n6, false));
            if (n4 != 0 && (n6 == 0 || (this.parent.style & 0x10000) != 0)) {
                gC.setForeground(this.display.getSystemColor(27));
                gC.setBackground(this.display.getSystemColor(26));
            } else {
                gC.setForeground(this.getForeground(n6));
                gC.setBackground(this.getBackground(n6));
            }
            object = new Event();
            ((Event)object).item = this;
            ((Event)object).gc = gC;
            ((Event)object).index = n6;
            ((Event)object).doit = true;
            ((Event)object).detail = 16;
            if (n17 != 0) {
                ((Event)object).detail |= 8;
            }
            if (n4 != 0) {
                ((Event)object).detail |= 2;
            }
            if (n16 != 0) {
                ((Event)object).detail |= 4;
            }
            ((Event)object).x = rectangle2.x;
            ((Event)object).y = rectangle2.y;
            ((Event)object).width = rectangle2.width;
            ((Event)object).height = rectangle2.height;
            gC.setClipping(rectangle2);
            this.parent.sendEvent(40, (Event)object);
            ((Event)object).gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setClipping(rectangle2);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setTextAntialias(n11);
            gC.setAdvanced(bl2);
            if (this.isDisposed()) {
                return false;
            }
            if (!((Event)object).doit) {
                n20 = 0;
                n19 = 0;
                n18 = 0;
                n17 = 0;
            } else {
                n17 = n17 != 0 && (((Event)object).detail & 8) != 0 ? 1 : 0;
                n18 = (((Event)object).detail & 0x10) != 0 ? 1 : 0;
                n19 = n4 != 0 && (((Event)object).detail & 2) != 0 ? 1 : 0;
                int n21 = n20 = n16 != 0 && (((Event)object).detail & 4) != 0 ? 1 : 0;
            }
        }
        if (n17 != 0) {
            gC.setBackground(this.getBackground(n6));
            if (n6 == 0 && (tableColumn == null || tableColumn.getOrderIndex() == 0)) {
                object = this.getFocusBounds();
                n3 = 0;
                if (tableColumn == null) {
                    n3 = ((Rectangle)object).width;
                } else {
                    n3 = tableColumn.width - ((Rectangle)object).x;
                    if (this.parent.linesVisible) {
                        --n3;
                    }
                }
                gC.fillRectangle(((Rectangle)object).x, ((Rectangle)object).y, n3, ((Rectangle)object).height);
            } else {
                int n22 = rectangle2.width;
                gC.fillRectangle(rectangle2.x, rectangle2.y, n22, rectangle2.height);
            }
        }
        if (!(n19 == 0 || n6 != 0 && (this.parent.style & 0x10000) == 0 || !this.parent.hasFocus() && (this.parent.style & 0x8000) != 0)) {
            gC.setBackground(this.display.getSystemColor(26));
            if (n6 == 0) {
                int n23;
                Rectangle rectangle3 = this.getFocusBounds();
                n3 = tableColumn == null || tableColumn.getOrderIndex() == 0 || (this.parent.style & 0x10000) == 0 ? rectangle3.x + 1 : tableColumn.getX();
                if (tableColumn == null) {
                    n23 = rectangle3.width - 2;
                } else {
                    n23 = tableColumn.getX() + tableColumn.width - n3;
                    if (tableColumn.getOrderIndex() == this.parent.columns.length - 1 || (this.parent.style & 0x10000) == 0) {
                        n23 -= 2;
                    }
                }
                if (n23 > 0) {
                    gC.fillRectangle(n3, rectangle3.y + 1, n23, rectangle3.height - 2);
                }
            } else {
                int n24 = tableColumn.getX();
                n3 = tableColumn.width;
                if (tableColumn.getOrderIndex() == 0) {
                    ++n24;
                    --n3;
                }
                if (tableColumn.getOrderIndex() == this.parent.columns.length - 1) {
                    n3 -= 2;
                }
                if (n3 > 0) {
                    gC.fillRectangle(tableColumn.getX(), rectangle2.y + 1, n3, rectangle2.height - 2);
                }
            }
        }
        if (bl) {
            return false;
        }
        if (n6 == 0 && (this.parent.style & 0x20) != 0) {
            Image image = this.grayed ? this.parent.getGrayUncheckedImage() : this.parent.getUncheckedImage();
            Rectangle rectangle4 = this.getCheckboxBounds();
            gC.drawImage(image, rectangle4.x, rectangle4.y);
            if (this.checked) {
                Image image2 = this.parent.getCheckmarkImage();
                Rectangle rectangle5 = image2.getBounds();
                n2 = (rectangle4.width - rectangle5.width) / 2;
                n = (rectangle4.height - rectangle5.height) / 2;
                gC.drawImage(image2, rectangle4.x + n2, rectangle4.y + n);
            }
        }
        if (n18 != 0) {
            Image image = this.getImage(n6, false);
            String string = this.getDisplayText(n6);
            Rectangle rectangle6 = this.getImageBounds(n6);
            int n25 = rectangle6.x;
            n2 = this.parent.getCellPadding();
            gC.setClipping(n25, rectangle2.y + n2 - (this.parent.linesVisible ? 1 : 0), n14 - n25 - n2, rectangle2.height - 2 * (n2 - (this.parent.linesVisible ? 1 : 0)));
            if (image != null) {
                Rectangle rectangle7 = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle7.width, rectangle7.height, rectangle6.x, rectangle6.y, rectangle6.width, rectangle6.height);
            }
            if (string.length() > 0) {
                gC.setFont(this.getFont(n6, false));
                n = this.getFontHeight(n6);
                if (n19 != 0 && (n6 == 0 || (this.parent.style & 0x10000) != 0)) {
                    if (this.parent.hasFocus() || (this.parent.style & 0x8000) == 0) {
                        gC.setForeground(this.display.getSystemColor(27));
                    }
                } else if (n4 == 0 || n19 != 0) {
                    gC.setForeground(this.getForeground(n6));
                }
                n7 = this.getTextX(n6) + 3;
                gC.drawString(string, n7, n5 + (n15 - n) / 2, true);
            }
        }
        if (this.parent.hooks(42)) {
            int n26 = this.getContentWidth(n6);
            int n27 = this.getContentX(n6);
            gC.setFont(this.getFont(n6, false));
            if (n4 != 0 && (n6 == 0 || (this.parent.style & 0x10000) != 0)) {
                gC.setForeground(this.display.getSystemColor(27));
                gC.setBackground(this.display.getSystemColor(26));
            } else {
                gC.setForeground(this.getForeground(n6));
                gC.setBackground(this.getBackground(n6));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gC;
            event.index = n6;
            if (n4 != 0) {
                event.detail |= 2;
            }
            if (n20 != 0) {
                event.detail |= 4;
            }
            event.x = n27;
            event.y = rectangle2.y;
            event.width = n26;
            event.height = rectangle2.height;
            gC.setClipping(rectangle2);
            this.parent.sendEvent(42, event);
            event.gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setClipping(rectangle2);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setTextAntialias(n11);
            gC.setAdvanced(bl2);
            int n28 = n20 = n16 != 0 && (event.detail & 4) != 0 ? 1 : 0;
        }
        return n16 != 0 && n20 == 0;
    }

    void redraw(int n, int n2, int n3, int n4, int n5) {
        if (!this.parent.hooks(40) && !this.parent.hooks(42)) {
            this.parent.redraw(n, n2, n3, n4, false);
            return;
        }
        Rectangle rectangle = this.getCellBounds(n5);
        this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    void redrawItem() {
        this.parent.redraw(0, this.parent.getItemY(this), this.parent.clientArea.width, this.parent.itemHeight, false);
    }

    void removeColumn(TableColumn tableColumn, int n) {
        Object object;
        int n2 = this.parent.columns.length;
        if (n2 == 0) {
            this.cellForegrounds = null;
            this.cellBackgrounds = null;
            this.displayTexts = null;
            this.cellFonts = null;
            this.fontHeights = null;
            GC gC = new GC(this.parent);
            this.computeTextWidths(gC);
            gC.dispose();
            return;
        }
        String[] stringArray = new String[n2];
        System.arraycopy(this.texts, 0, stringArray, 0, n);
        System.arraycopy(this.texts, n + 1, stringArray, n, n2 - n);
        this.texts = stringArray;
        Image[] imageArray = new Image[n2];
        System.arraycopy(this.images, 0, imageArray, 0, n);
        System.arraycopy(this.images, n + 1, imageArray, n, n2 - n);
        this.images = imageArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.textWidths, 0, nArray, 0, n);
        System.arraycopy(this.textWidths, n + 1, nArray, n, n2 - n);
        this.textWidths = nArray;
        String[] stringArray2 = new String[n2];
        System.arraycopy(this.displayTexts, 0, stringArray2, 0, n);
        System.arraycopy(this.displayTexts, n + 1, stringArray2, n, n2 - n);
        this.displayTexts = stringArray2;
        if (this.cellBackgrounds != null) {
            object = new Color[n2];
            System.arraycopy(this.cellBackgrounds, 0, object, 0, n);
            System.arraycopy(this.cellBackgrounds, n + 1, object, n, n2 - n);
            this.cellBackgrounds = object;
        }
        if (this.cellForegrounds != null) {
            object = new Color[n2];
            System.arraycopy(this.cellForegrounds, 0, object, 0, n);
            System.arraycopy(this.cellForegrounds, n + 1, object, n, n2 - n);
            this.cellForegrounds = object;
        }
        if (this.cellFonts != null) {
            object = new Font[n2];
            System.arraycopy(this.cellFonts, 0, object, 0, n);
            System.arraycopy(this.cellFonts, n + 1, object, n, n2 - n);
            this.cellFonts = object;
            int[] nArray2 = new int[n2];
            System.arraycopy(this.fontHeights, 0, nArray2, 0, n);
            System.arraycopy(this.fontHeights, n + 1, nArray2, n, n2 - n);
            this.fontHeights = nArray2;
        }
        if (n == 0) {
            this.text = this.texts[0] != null ? this.texts[0] : "";
            this.texts[0] = null;
            this.image = this.images[0];
            this.images[0] = null;
            if ((this.parent.style & 0x20) != 0) {
                object = new GC(this.parent);
                ((GC)object).setFont(this.getFont(0, false));
                this.computeDisplayText(0, (GC)object);
                ((Resource)object).dispose();
            }
        }
        if (n2 < 2) {
            this.texts = null;
            this.images = null;
        }
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setBackground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellBackgrounds == null) {
            if (color == null) {
                return;
            }
            this.cellBackgrounds = new Color[n2];
        }
        if ((color2 = this.cellBackgrounds[n]) == color) {
            return;
        }
        this.cellBackgrounds[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCellBounds(n);
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.checked = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            if (this.parent.hooks(40) || this.parent.hooks(42)) {
                this.redrawItem();
            } else {
                Rectangle rectangle = this.getCheckboxBounds();
                this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(false));
        this.fontHeight = gC.getFontMetrics().getHeight();
        this.computeDisplayTexts(gC);
        this.computeTextWidths(gC);
        gC.dispose();
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            int n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
        this.redrawItem();
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellFonts == null) {
            if (font == null) {
                return;
            }
            this.cellFonts = new Font[n2];
        }
        if ((font2 = this.cellFonts[n]) == font) {
            return;
        }
        this.cellFonts[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        if (this.fontHeights == null) {
            this.fontHeights = new int[n2];
        }
        this.fontHeights[n] = gC.getFontMetrics().getHeight();
        this.computeDisplayText(n, gC);
        gC.dispose();
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCellBounds(n);
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setForeground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellForegrounds == null) {
            if (color == null) {
                return;
            }
            this.cellForegrounds = new Color[n2];
        }
        if ((color2 = this.cellForegrounds[n]) == color) {
            return;
        }
        this.cellForegrounds[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(n), this.parent.getItemY(this), this.textWidths[n] + 6, this.parent.itemHeight, n);
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCheckboxBounds();
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            if (imageArray[n] != null) {
                this.setImage(n, imageArray[n]);
            }
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        GC gC;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        TableColumn[] tableColumnArray = this.parent.columns;
        int n2 = Math.max(1, tableColumnArray.length);
        if (n < 0 || n >= n2) {
            return;
        }
        Image image2 = this.getImage(n, false);
        if (image == image2) {
            return;
        }
        if (image != null && image.equals(image2)) {
            return;
        }
        if (n == 0) {
            super.setImage(image);
        } else {
            this.images[n] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (tableColumnArray.length > 0) {
            gC = new GC(this.parent);
            gC.setFont(this.getFont(n, false));
            this.computeDisplayText(n, gC);
            gC.dispose();
        }
        if (image == null) {
            this.redrawItem();
            return;
        }
        if (this.parent.imageHeight == 0) {
            int n3 = this.parent.itemHeight;
            this.parent.setImageHeight(image.getBounds().height);
            if (n3 != this.parent.itemHeight) {
                if (n == 0) {
                    this.parent.col0ImageWidth = image.getBounds().width;
                    if (tableColumnArray.length > 0) {
                        GC gC2 = new GC(this.parent);
                        TableItem[] tableItemArray = this.parent.items;
                        int n4 = 0;
                        while (n4 < this.parent.itemsCount) {
                            tableItemArray[n4].updateColumnWidth(tableColumnArray[0], gC2);
                            ++n4;
                        }
                        gC2.dispose();
                    }
                }
                this.parent.redraw();
                return;
            }
        }
        if (n == 0 && this.parent.col0ImageWidth == 0) {
            this.parent.col0ImageWidth = image.getBounds().width;
            if (tableColumnArray.length == 0) {
                this.parent.redraw();
            } else {
                gC = new GC(this.parent);
                TableItem[] tableItemArray = this.parent.items;
                int n5 = 0;
                while (n5 < this.parent.itemsCount) {
                    tableItemArray[n5].updateColumnWidth(tableColumnArray[0], gC);
                    ++n5;
                }
                gC.dispose();
                this.parent.redraw(tableColumnArray[0].getX(), 0, tableColumnArray[0].width, this.parent.clientArea.height, false);
            }
            return;
        }
        this.redrawItem();
    }

    public void setImageIndent(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.imageIndent == n) {
            return;
        }
        this.imageIndent = n;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (string.equals(this.getText(n, false))) {
            return;
        }
        if (n == 0) {
            super.setText(string);
        } else {
            this.texts[n] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        int n3 = this.textWidths[n];
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        this.computeDisplayText(n, gC);
        gC.dispose();
        if (this.parent.columns.length == 0) {
            Rectangle rectangle = this.getBounds(false);
            int n4 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n4, this.textWidths[n] - n3);
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(n), this.parent.getItemY(this), Math.max(n3, this.textWidths[n]) + 6, this.parent.itemHeight, n);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        this.setText(0, string);
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            int n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                this.setText(n2, stringArray[n2]);
            }
            ++n2;
        }
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
    }

    void updateColumnWidth(TableColumn tableColumn, GC gC) {
        int n = tableColumn.getIndex();
        gC.setFont(this.getFont(n, false));
        String string = this.displayTexts[n];
        this.computeDisplayText(n, gC);
        if (this.isInViewport()) {
            boolean bl;
            boolean bl2 = bl = (tableColumn.style & 0x4000) != 0;
            if (!bl || this.parent.hooks(40) || this.parent.hooks(42)) {
                Rectangle rectangle = this.getCellBounds(n);
                this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                return;
            }
            if (string == null || !string.equals(this.displayTexts[n])) {
                Rectangle rectangle = this.getCellBounds(n);
                int n2 = this.getTextX(n);
                this.parent.redraw(n2, rectangle.y, rectangle.x + rectangle.width - n2, rectangle.height, false);
            }
        }
    }

    void updateFont(GC gC) {
        if (this.font == null) {
            this.computeDisplayTexts(gC);
            this.computeTextWidths(gC);
        }
    }
}

