/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    char echoCharacter;
    boolean ignoreChange;
    String hiddenText;
    String message;
    int drawCount;
    Color disabledColor;
    static final boolean IsGB18030;
    public static final int LIMIT;
    public static final String DELIMITER;
    static final RGB MSG_FOREGROUND;

    static {
        MSG_FOREGROUND = new RGB(172, 168, 153);
        LIMIT = Integer.MAX_VALUE;
        DELIMITER = "\n";
        IsGB18030 = Converter.defaultCodePage().endsWith("18030");
    }

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = OS.XmTextGetLastPosition(this.handle);
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetInsertionPosition(this.handle, n);
        OS.XmTextInsert(this.handle, n, byArray);
        n = OS.XmTextGetLastPosition(this.handle);
        OS.XmTextSetInsertionPosition(this.handle, n);
        this.display.setWarnings(bl);
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        OS.XmTextClearSelection(this.handle, OS.XtLastTimestampProcessed(n));
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1 || n2 == -1) {
            int n5;
            int n6;
            byte[] byArray;
            int n7 = OS.XmTextGetString(this.handle);
            if (n7 == 0) {
                return new Point(0, 0);
            }
            int n8 = OS.strlen(n7);
            if (n8 == 0) {
                if (n2 == -1) {
                    n4 = (this.style & 4) != 0 ? this.getLineHeight() : 64;
                }
                if (n == -1) {
                    n3 = 64;
                }
            } else {
                byArray = new byte[n8 + 1];
                OS.memmove(byArray, n7, n8);
                int n9 = n6 = (this.style & 2) != 0 && (this.style & 0x40) != 0 ? 1 : 0;
                if (n6 != 0 && n != -1) {
                    char[] cArray = Converter.mbcsToWcs(this.getCodePage(), byArray);
                    String string = new String(cArray);
                    String string2 = this.display.wrapText(string, this.font, n);
                    byArray = Converter.wcsToMbcs(this.getCodePage(), string2, true);
                }
                n5 = (this.style & 4) != 0 ? OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0) : OS.XmStringGenerate(byArray, OS.XmFONTLIST_DEFAULT_TAG, 0, null);
                int n10 = this.font.handle;
                if (n2 == -1) {
                    n4 = (this.style & 4) != 0 ? this.getLineHeight() : OS.XmStringHeight(n10, n5);
                }
                if (n == -1) {
                    n3 = OS.XmStringWidth(n10, n5);
                }
                OS.XmStringFree(n5);
            }
            OS.XtFree(n7);
            if ((this.style & 4) != 0 && this.message.length() > 0 && n == -1) {
                byArray = Converter.wcsToMbcs(this.getCodePage(), this.message, true);
                n6 = OS.XmStringGenerate(byArray, OS.XmFONTLIST_DEFAULT_TAG, 0, null);
                n5 = this.font.handle;
                n3 = Math.max(n3, OS.XmStringWidth(n5, n6));
                OS.XmStringFree(n6);
            }
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        Object object;
        this.checkWidget();
        if (this.horizontalBar != null) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNheight;
            object = nArray;
            OS.XtGetValues(this.horizontalBar.handle, object, ((int[])object).length / 2);
            n4 += object[1] + 4;
        }
        if (this.verticalBar != null) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNwidth;
            object = nArray;
            OS.XtGetValues(this.verticalBar.handle, object, ((int[])object).length / 2);
            n3 += object[1] + 4;
        }
        if ((this.style & 2) != 0) {
            n4 += 4;
        }
        object = new XRectangle();
        OS.XmWidgetGetDisplayRect(this.handle, (XRectangle)object);
        n -= object.x;
        n2 -= object.y;
        n3 += object.x * 2;
        n4 += object.y * 2;
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 2) != 0 || (this.style & 0x800) != 0) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNshadowThickness;
            nArray[2] = OS.XmNhighlightThickness;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            n5 = nArray2[1];
            n6 = nArray2[3];
        }
        return new Rectangle(n -= n5 + n6, n2 -= n5 + n6, n3 += (n5 + n6) * 2, n4 += (n5 + n6) * 2);
    }

    public void copy() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        OS.XmTextCopy(this.handle, OS.XtLastTimestampProcessed(n));
    }

    void createHandle(int n) {
        int[] nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = OS.XmNverifyBell;
        nArray2[2] = OS.XmNeditMode;
        nArray2[3] = (this.style & 4) != 0 ? 1 : 0;
        nArray2[4] = OS.XmNscrollHorizontal;
        nArray2[5] = (this.style & 0x100) != 0 ? 1 : 0;
        nArray2[6] = OS.XmNscrollVertical;
        nArray2[7] = (this.style & 0x200) != 0 ? 1 : 0;
        nArray2[8] = OS.XmNwordWrap;
        nArray2[9] = !IsGB18030 && (this.style & 0x40) != 0 ? 1 : 0;
        nArray2[10] = OS.XmNeditable;
        nArray2[11] = (this.style & 8) != 0 ? 0 : 1;
        nArray2[12] = OS.XmNcursorPositionVisible;
        nArray2[13] = (this.style & 8) != 0 ? 0 : 1;
        nArray2[14] = OS.XmNancestorSensitive;
        nArray2[15] = 1;
        int[] nArray3 = nArray2;
        int n2 = this.parent.handle;
        if ((this.style & 4) != 0) {
            this.handle = OS.XmCreateTextField(n2, null, nArray3, nArray3.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            int[] nArray4 = new int[2];
            nArray4[0] = OS.XmNcursorPositionVisible;
            nArray = nArray4;
            OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        } else {
            this.handle = OS.XmCreateScrolledText(n2, new byte[1], nArray3, nArray3.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.XtParent(this.handle);
        }
        if ((this.style & 0x800) == 0) {
            int[] nArray5 = new int[4];
            nArray5[0] = OS.XmNmarginHeight;
            nArray5[2] = OS.XmNshadowThickness;
            nArray = nArray5;
            OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        }
        OS.XmDropSiteUnregister(this.handle);
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.message = "";
        this.hiddenText = "";
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('*');
        }
        if ((this.style & 4) != 0) {
            this.disabledColor = new Color(this.display, MSG_FOREGROUND);
        }
    }

    public void cut() {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        OS.XmTextCut(this.handle, OS.XtLastTimestampProcessed(n));
    }

    int defaultBackground() {
        return this.display.textBackground;
    }

    Font defaultFont() {
        return this.display.textFont;
    }

    int defaultForeground() {
        return this.display.textForeground;
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if (bl) {
            int n3;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.XmTextGetSelectionPosition(this.handle, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n3 = OS.XmTextXYToPos(this.handle, (short)n, (short)n2)) && n3 < nArray2[0] && super.dragDetect(n, n2, bl, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return this.getLineNumber(OS.XmTextGetInsertionPosition(this.handle));
    }

    public Point getCaretLocation() {
        this.checkWidget();
        int n = OS.XmTextGetInsertionPosition(this.handle);
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XmTextPosToXY(this.handle, n, sArray, sArray2);
        return new Point(sArray[0], sArray2[0] - this.getFontAscent(this.font.handle));
    }

    public int getCaretPosition() {
        this.checkWidget();
        return OS.XmTextGetInsertionPosition(this.handle);
    }

    public int getCharCount() {
        this.checkWidget();
        return OS.XmTextGetLastPosition(this.handle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNselectionArrayCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 1;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNeditable;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        int n = this.echoCharacter != '\u0000' ? this.hiddenText.length() : OS.XmTextGetLastPosition(this.handle);
        return this.getLineNumber(n) + 1;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.getFontHeight(this.font.handle);
    }

    int getLineNumber(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 1024;
        char[] cArray = new char[n4 + 1];
        byte[] byArray = null;
        if (OS.IsLinux) {
            byArray = new byte[n4 + 1];
        }
        int n5 = (n + n4 - 1) / n4 * n4;
        while (n3 < n5) {
            int n6;
            int n7 = n4;
            if (n3 + n4 > n) {
                n7 = n - n3;
            }
            if (this.echoCharacter != '\u0000') {
                this.hiddenText.getChars(n3, n3 + n7, cArray, 0);
            } else if (OS.IsLinux) {
                OS.XmTextGetSubstring(this.handle, n3, n7, byArray.length, byArray);
                n6 = 0;
                while (n6 < n7) {
                    cArray[n6] = (char)byArray[n6];
                    ++n6;
                }
            } else {
                OS.XmTextGetSubstringWcs(this.handle, n3, n7, cArray.length, cArray);
            }
            n6 = 0;
            while (n6 < n7) {
                if (cArray[n6] == '\n') {
                    ++n2;
                }
                ++n6;
            }
            n3 += n4;
        }
        return n2;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    int getNavigationType() {
        if ((this.style & 4) != 0) {
            return super.getNavigationType();
        }
        int n = OS.XtMalloc(4);
        if (n == 0) {
            return 0;
        }
        int[] nArray = new int[]{OS.XmNnavigationType, n};
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, n, 4);
        OS.XtFree(n);
        return nArray2[0];
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return OS.XmTextXYToPos(this.handle, (short)point.x, (short)point.y);
    }

    public Point getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, nArray, nArray2);
        if (nArray[0] == nArray2[0]) {
            nArray[0] = nArray2[0] = OS.XmTextGetInsertionPosition(this.handle);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, nArray, nArray2);
        return nArray2[0] - nArray[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.echoCharacter != '\u0000') {
            Point point = this.getSelection();
            return this.getText(point.x, point.y);
        }
        int n = OS.XmTextGetSelection(this.handle);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        OS.XtFree(n);
        return new String(Converter.mbcsToWcs(this.getCodePage(), byArray));
    }

    public int getTabs() {
        this.checkWidget();
        return 8;
    }

    public String getText() {
        this.checkWidget();
        if (this.echoCharacter != '\u0000') {
            return this.hiddenText;
        }
        int n = OS.XmTextGetString(this.handle);
        if (n == 0) {
            return "";
        }
        int n2 = OS.strlen(n);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, n, n2);
        OS.XtFree(n);
        return new String(Converter.mbcsToWcs(this.getCodePage(), byArray));
    }

    public String getText(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2 || n2 < 0) {
            return "";
        }
        boolean bl = this.echoCharacter != '\u0000';
        int n4 = n3 = bl ? this.hiddenText.length() : OS.XmTextGetLastPosition(this.handle);
        if (n3 == 0) {
            return "";
        }
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        if (bl) {
            return this.hiddenText.substring(n, n2 + 1);
        }
        int n5 = n2 - n + 1;
        int n6 = n5 * OS.MB_CUR_MAX() + 1;
        byte[] byArray = new byte[n6];
        int n7 = OS.XmTextGetSubstring(this.handle, n, n5, n6, byArray);
        switch (n7) {
            case 0: 
            case 2: {
                this.error(12);
            }
        }
        char[] cArray = Converter.mbcsToWcs(this.getCodePage(), byArray);
        return new String(cArray, 0, n5);
    }

    public int getTextLimit() {
        this.checkWidget();
        return OS.XmTextGetMaxLength(this.handle);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        if (this.scrolledHandle == 0) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNverticalScrollBar;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0) {
            return 0;
        }
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNvalue;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
        return nArray4[1];
    }

    public int getTopPixel() {
        this.checkWidget();
        return this.getTopIndex() * this.getLineHeight();
    }

    boolean hasIMSupport() {
        return true;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNactivateCallback, n, 9);
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(this.handle, OS.XmNmodifyVerifyCallback, n, 19);
    }

    int inputContext() {
        return 0;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XmTextGetSelectionPosition(this.handle, nArray, nArray2);
        if (nArray[0] == nArray2[0]) {
            nArray[0] = nArray2[0] = OS.XmTextGetInsertionPosition(this.handle);
        }
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextReplace(this.handle, nArray[0], nArray2[0], byArray);
        int n = nArray[0] + Math.max(0, byArray.length - 1);
        OS.XmTextSetInsertionPosition(this.handle, n);
        this.display.setWarnings(bl);
    }

    void overrideTranslations() {
        if ((this.style & 4) != 0) {
            OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
        }
    }

    public void paste() {
        this.checkWidget();
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        if ((this.style & 4) != 0) {
            OS.XmTextFieldPaste(this.handle);
        } else {
            OS.XmTextPaste(this.handle);
        }
        this.display.setWarnings(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.message = null;
        this.hiddenText = null;
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.disabledColor = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendIMKeyEvent(int n, XKeyEvent xKeyEvent) {
        return super.sendIMKeyEvent(n, xKeyEvent, this.handle);
    }

    public void selectAll() {
        int n;
        this.checkWidget();
        int n2 = OS.XmTextGetLastPosition(this.handle);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((n = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(this.handle, 0, n2, OS.XtLastTimestampProcessed(n));
        OS.XmTextSetInsertionPosition(this.handle, 0);
        this.display.setWarnings(bl);
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = this.display.getWarnings();
        this.display.setWarnings(false);
        boolean bl4 = super.setBounds(n, n2, n3, n4, bl, bl2);
        this.display.setWarnings(bl3);
        return bl4;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNselectionArrayCount, bl ? 4 : 1};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setEchoChar(char c) {
        String string;
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.echoCharacter == c) {
            return;
        }
        if (c == '\u0000') {
            string = this.hiddenText;
            this.hiddenText = "";
        } else {
            string = this.hiddenText = this.getText();
        }
        this.echoCharacter = c;
        Point point = this.getSelection();
        boolean bl = this.ignoreChange;
        this.ignoreChange = true;
        this.setText(string);
        this.setSelection(point);
        this.ignoreChange = bl;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        OS.XmTextSetEditable(this.handle, bl);
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNcursorPositionVisible, bl && this.hasFocus() ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        this.redrawHandle(0, 0, 0, 0, true, this.handle);
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (bl) {
            if (--this.drawCount == 0) {
                OS.XmTextEnableRedisplay(this.handle);
            }
        } else if (this.drawCount++ == 0) {
            OS.XmTextDisableRedisplay(this.handle);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = OS.XtDisplay(this.handle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XmTextGetLastPosition(this.handle);
        int n4 = Math.min(Math.max(n, 0), n3);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextClearSelection(this.handle, OS.XtLastTimestampProcessed(n2));
        OS.XmTextSetInsertionPosition(this.handle, n4);
        this.display.setWarnings(bl);
    }

    public void setSelection(int n, int n2) {
        int n3;
        this.checkWidget();
        int n4 = OS.XmTextGetLastPosition(this.handle);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((n3 = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        n = Math.min(Math.max(n, 0), n4);
        n2 = Math.min(Math.max(n2, 0), n4);
        int n5 = Math.min(n, n2);
        int n6 = Math.max(n, n2);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(this.handle, n5, n6, OS.XtLastTimestampProcessed(n3));
        if (n > n2) {
            OS.XmTextSetInsertionPosition(this.handle, n5);
        } else {
            OS.XmTextSetInsertionPosition(this.handle, n6);
        }
        this.display.setWarnings(bl);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(this.handle, byArray);
        OS.XmTextSetInsertionPosition(this.handle, 0);
        this.display.setWarnings(bl);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.XmTextSetMaxLength(this.handle, n);
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.scrolledHandle == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNverticalScrollBar;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0) {
            return;
        }
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNvalue;
        int[] nArray4 = nArray3;
        OS.XtGetValues(nArray2[1], nArray4, nArray4.length / 2);
        OS.XmTextScroll(this.handle, n - nArray4[1]);
    }

    public void showSelection() {
        this.checkWidget();
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        int n = OS.XmTextGetInsertionPosition(this.handle);
        OS.XmTextShowPosition(this.handle, n);
        this.display.setWarnings(bl);
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        int n2 = super.traversalCode(n, xKeyEvent);
        if ((this.style & 8) != 0) {
            return n2;
        }
        if ((this.style & 2) != 0) {
            n2 &= 0xFFFFFFFB;
            if (n == 65289 && xKeyEvent != null) {
                boolean bl;
                boolean bl2 = bl = (xKeyEvent.state & 1) == 0;
                if (bl && (xKeyEvent.state & 4) == 0) {
                    n2 &= 0xFFFFFFE7;
                }
            }
        }
        return n2;
    }

    int XExposure(int n, int n2, int n3, int n4) {
        if ((this.style & 4) != 0 && this.message.length() > 0 && !this.hasFocus() && OS.XmTextGetLastPosition(this.handle) == 0) {
            int[] nArray = new int[12];
            nArray[0] = OS.XmNmarginWidth;
            nArray[2] = OS.XmNmarginHeight;
            nArray[4] = OS.XmNshadowThickness;
            nArray[6] = OS.XmNhighlightThickness;
            nArray[8] = OS.XmNwidth;
            nArray[10] = OS.XmNheight;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n5 = nArray2[1] + nArray2[5] + nArray2[7];
            int n6 = nArray2[3] + nArray2[5] + nArray2[7];
            Rectangle rectangle = new Rectangle(n5, n6, nArray2[9] - 2 * n5, nArray2[11] - 2 * n6);
            GCData gCData = new GCData();
            GC gC = GC.motif_new(this, gCData);
            gC.setForeground(this.disabledColor);
            gC.setClipping(rectangle);
            gC.drawString(this.message, rectangle.x, rectangle.y, true);
            gC.dispose();
        }
        return super.XExposure(n, n2, n3, n4);
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        super.xFocusIn(xFocusChangeEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 0xC) != 0) {
            int[] nArray = new int[]{OS.XmNcursorPositionVisible, 1};
            OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        }
        if ((this.style & 0x80) != 0) {
            this.redrawHandle(0, 0, 0, 0, true, this.handle);
        }
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        super.xFocusOut(xFocusChangeEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 0xC) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNcursorPositionVisible;
            int[] nArray2 = nArray;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        if ((this.style & 0x80) != 0) {
            this.redrawHandle(0, 0, 0, 0, true, this.handle);
        }
        return 0;
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        this.postEvent(14);
        return 0;
    }

    int XmNmodifyVerifyCallback(int n, int n2, int n3) {
        Object object;
        Object object2;
        String string;
        int n4 = super.XmNmodifyVerifyCallback(n, n2, n3);
        if (n4 != 0) {
            return n4;
        }
        if (this.echoCharacter == '\u0000' && !this.hooks(25) && !this.filters(25)) {
            return n4;
        }
        XmTextVerifyCallbackStruct xmTextVerifyCallbackStruct = new XmTextVerifyCallbackStruct();
        OS.memmove(xmTextVerifyCallbackStruct, n3, 32);
        XmTextBlockRec xmTextBlockRec = new XmTextBlockRec();
        OS.memmove(xmTextBlockRec, xmTextVerifyCallbackStruct.text, 12);
        byte[] byArray = new byte[xmTextBlockRec.length];
        OS.memmove(byArray, xmTextBlockRec.ptr, xmTextBlockRec.length);
        String string2 = this.getCodePage();
        String string3 = string = new String(Converter.mbcsToWcs(string2, byArray));
        if (!this.ignoreChange) {
            object2 = new Event();
            if (xmTextVerifyCallbackStruct.event != 0) {
                object = new XKeyEvent();
                OS.memmove((XKeyEvent)object, xmTextVerifyCallbackStruct.event, 60);
                ((Event)object2).time = ((XKeyEvent)object).time;
                this.setKeyState((Event)object2, (XKeyEvent)object);
            }
            ((Event)object2).start = xmTextVerifyCallbackStruct.startPos;
            ((Event)object2).end = xmTextVerifyCallbackStruct.endPos;
            ((Event)object2).doit = xmTextVerifyCallbackStruct.doit == 1;
            ((Event)object2).text = string;
            this.sendEvent(25, (Event)object2);
            string3 = ((Event)object2).text;
            xmTextVerifyCallbackStruct.doit = (byte)(((Event)object2).doit && string3 != null ? 1 : 0);
        }
        if (string3 != null) {
            if (this.echoCharacter != '\u0000' && xmTextVerifyCallbackStruct.doit != 0) {
                object2 = this.hiddenText.substring(0, xmTextVerifyCallbackStruct.startPos);
                object = this.hiddenText.substring(xmTextVerifyCallbackStruct.endPos, this.hiddenText.length());
                this.hiddenText = String.valueOf(object2) + string3 + (String)object;
                char[] cArray = new char[string3.length()];
                int n5 = 0;
                while (n5 < cArray.length) {
                    cArray[n5] = this.echoCharacter;
                    ++n5;
                }
                string3 = new String(cArray);
            }
            if (string3 != string) {
                OS.XtFree(xmTextBlockRec.ptr);
                object2 = Converter.wcsToMbcs(string2, string3, true);
                int n6 = ((Object)object2).length;
                int n7 = OS.XtMalloc(n6);
                OS.memmove(n7, (byte[])object2, n6);
                xmTextBlockRec.ptr = n7;
                xmTextBlockRec.length = ((Object)object2).length - 1;
                OS.memmove(xmTextVerifyCallbackStruct.text, xmTextBlockRec, 12);
            }
        }
        OS.memmove(n3, xmTextVerifyCallbackStruct, 32);
        return n4;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        if (!this.ignoreChange) {
            this.sendEvent(24);
        }
        return 0;
    }
}

