/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    Tree parent;
    TreeItem parentItem;
    TreeItem[] items = Tree.NO_ITEMS;
    int availableIndex = -1;
    int depth = 0;
    boolean checked;
    boolean grayed;
    boolean expanded;
    boolean cached;
    String[] texts;
    int[] textWidths = new int[1];
    int customWidth = -1;
    int fontHeight;
    int[] fontHeights;
    Image[] images;
    Color foreground;
    Color background;
    String[] displayTexts;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font font;
    Font[] cellFonts;
    static final int INDENT_HIERARCHY = 6;
    static final int MARGIN_TEXT = 3;

    public TreeItem(Tree tree, int n) {
        this(tree, n, TreeItem.checkNull((Tree)tree).items.length);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(tree, n, n2, true);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(treeItem, n, TreeItem.checkNull((TreeItem)treeItem).items.length);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(treeItem, n, n2, true);
    }

    TreeItem(TreeItem treeItem, int n, int n2, boolean bl) {
        super(treeItem, n);
        int n3;
        this.parentItem = treeItem;
        this.parent = treeItem.parent;
        this.depth = treeItem.depth + 1;
        int n4 = treeItem.items.length;
        if (n2 < 0 || n2 > n4) {
            this.error(6);
        }
        if ((n3 = this.parent.columns.length) > 0) {
            this.displayTexts = new String[n3];
            if (n3 > 1) {
                this.texts = new String[n3];
                this.textWidths = new int[n3];
                this.images = new Image[n3];
            }
        }
        if (bl) {
            treeItem.addItem(this, n2);
        }
    }

    TreeItem(Tree tree, int n, int n2, boolean bl) {
        super(tree, n);
        int n3 = tree.items.length;
        if (n2 < 0 || n2 > n3) {
            this.error(6);
        }
        this.parent = tree;
        int n4 = tree.columns.length;
        if (n4 > 0) {
            this.displayTexts = new String[n4];
            if (n4 > 1) {
                this.texts = new String[n4];
                this.textWidths = new int[n4];
                this.images = new Image[n4];
            }
        }
        if (bl) {
            tree.createItem(this, n2);
        }
    }

    void addColumn(TreeColumn treeColumn) {
        int n;
        Object[] objectArray;
        Resource[] resourceArray;
        Object[] objectArray2;
        int n2 = treeColumn.getIndex();
        int n3 = this.parent.columns.length;
        if (n3 > 1) {
            if (n3 == 2) {
                this.texts = new String[2];
            } else {
                objectArray2 = new String[n3];
                System.arraycopy(this.texts, 0, objectArray2, 0, n2);
                System.arraycopy(this.texts, n2, objectArray2, n2 + 1, n3 - n2 - 1);
                this.texts = objectArray2;
            }
            if (n2 == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (n3 == 2) {
                this.images = new Image[2];
            } else {
                objectArray2 = new Image[n3];
                System.arraycopy(this.images, 0, objectArray2, 0, n2);
                System.arraycopy(this.images, n2, objectArray2, n2 + 1, n3 - n2 - 1);
                this.images = objectArray2;
            }
            if (n2 == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
            objectArray2 = new int[n3];
            System.arraycopy(this.textWidths, 0, objectArray2, 0, n2);
            System.arraycopy(this.textWidths, n2, objectArray2, n2 + 1, n3 - n2 - 1);
            this.textWidths = (int[])objectArray2;
        } else {
            this.customWidth = -1;
        }
        objectArray2 = new String[n3];
        if (n3 > 1) {
            System.arraycopy(this.displayTexts, 0, objectArray2, 0, n2);
            System.arraycopy(this.displayTexts, n2, objectArray2, n2 + 1, n3 - n2 - 1);
        }
        this.displayTexts = objectArray2;
        if (this.cellBackgrounds != null) {
            resourceArray = new Color[n3];
            System.arraycopy(this.cellBackgrounds, 0, resourceArray, 0, n2);
            System.arraycopy(this.cellBackgrounds, n2, resourceArray, n2 + 1, n3 - n2 - 1);
            this.cellBackgrounds = resourceArray;
        }
        if (this.cellForegrounds != null) {
            resourceArray = new Color[n3];
            System.arraycopy(this.cellForegrounds, 0, resourceArray, 0, n2);
            System.arraycopy(this.cellForegrounds, n2, resourceArray, n2 + 1, n3 - n2 - 1);
            this.cellForegrounds = resourceArray;
        }
        if (this.cellFonts != null) {
            resourceArray = new Font[n3];
            System.arraycopy(this.cellFonts, 0, resourceArray, 0, n2);
            System.arraycopy(this.cellFonts, n2, resourceArray, n2 + 1, n3 - n2 - 1);
            this.cellFonts = resourceArray;
            objectArray = new int[n3];
            System.arraycopy(this.fontHeights, 0, objectArray, 0, n2);
            System.arraycopy(this.fontHeights, n2, objectArray, n2 + 1, n3 - n2 - 1);
            this.fontHeights = (int[])objectArray;
        }
        if ((n = treeColumn.getOrderIndex()) == 0 && n3 > 1) {
            objectArray = this.parent.getOrderedColumns();
            int n4 = objectArray[1].getIndex();
            GC gC = new GC(this.parent);
            gC.setFont(this.getFont(n4, false));
            this.computeDisplayText(n4, gC);
            gC.dispose();
        }
        int n5 = 0;
        while (n5 < this.items.length) {
            this.items[n5].addColumn(treeColumn);
            ++n5;
        }
    }

    void addItem(TreeItem treeItem, int n) {
        TreeItem[] treeItemArray = new TreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, treeItemArray, 0, n);
        treeItemArray[n] = treeItem;
        System.arraycopy(this.items, n, treeItemArray, n + 1, this.items.length - n);
        this.items = treeItemArray;
        if (!treeItem.isAvailable()) {
            if (this.isInViewport() && this.items.length == 1) {
                Rectangle rectangle = this.getExpanderBounds();
                this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            return;
        }
        this.parent.makeAvailable(treeItem);
        Rectangle rectangle = treeItem.getBounds(false);
        int n2 = rectangle.x + rectangle.width;
        this.parent.updateHorizontalBar(n2, n2);
        this.parent.updateVerticalBar();
        if (treeItem.availableIndex < this.parent.topIndex) {
            ++this.parent.topIndex;
            ScrollBar scrollBar = this.parent.getVerticalBar();
            if (scrollBar != null) {
                scrollBar.setSelection(this.parent.topIndex);
            }
            return;
        }
        this.parent.redrawFromItemDownwards(this.availableIndex);
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.grayed = false;
        this.checked = false;
        this.texts = null;
        this.textWidths = new int[1];
        this.fontHeight = 0;
        this.fontHeights = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.displayTexts = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.cached = false;
        this.text = "";
        this.image = null;
        int n = this.parent.columns.length;
        if (n > 0) {
            this.displayTexts = new String[n];
            if (n > 1) {
                this.texts = new String[n];
                this.textWidths = new int[n];
                this.images = new Image[n];
            }
        }
    }

    public void clear(int n, boolean bl) {
        Rectangle rectangle;
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        TreeItem treeItem = this.items[n];
        TreeItem[] treeItemArray = null;
        int n2 = 0;
        if (treeItem.availableIndex != -1 && this.parent.columns.length == 0) {
            if (bl) {
                treeItemArray = treeItem.computeAvailableDescendents();
                int n3 = 0;
                while (n3 < treeItemArray.length) {
                    rectangle = treeItemArray[n3].getBounds(false);
                    n2 = Math.max(n2, rectangle.x + rectangle.width);
                    ++n3;
                }
            } else {
                Rectangle rectangle2 = treeItem.getBounds(false);
                n2 = rectangle2.x + rectangle2.width;
            }
        }
        treeItem.clear();
        if (bl) {
            treeItem.clearAll(true, false);
        }
        if (treeItem.availableIndex == -1) {
            return;
        }
        if (this.parent.columns.length == 0) {
            int n4 = 0;
            if (bl) {
                int n5 = 0;
                while (n5 < treeItemArray.length) {
                    Rectangle rectangle3 = treeItemArray[n5].getBounds(false);
                    n4 = Math.max(n4, rectangle3.x + rectangle3.width);
                    ++n5;
                }
            } else {
                rectangle = treeItem.getBounds(false);
                n4 = rectangle.x + rectangle.width;
            }
            this.parent.updateHorizontalBar(n4, n4 - n2);
        }
        if (bl) {
            int n6 = treeItemArray == null ? treeItem.computeAvailableDescendentCount() : treeItemArray.length;
            this.parent.redrawItems(treeItem.availableIndex, treeItem.availableIndex + n6 - 1, false);
        } else {
            this.parent.redrawItem(treeItem.availableIndex, false);
        }
    }

    public void clearAll(boolean bl) {
        this.clearAll(bl, true);
    }

    void clearAll(boolean bl, boolean bl2) {
        Rectangle rectangle;
        int n;
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        TreeItem[] treeItemArray = null;
        int n2 = 0;
        if (bl2 && this.availableIndex != -1 && this.expanded && this.parent.columns.length == 0) {
            if (bl) {
                treeItemArray = this.computeAvailableDescendents();
                n = 1;
                while (n < treeItemArray.length) {
                    rectangle = treeItemArray[n].getBounds(false);
                    n2 = Math.max(n2, rectangle.x + rectangle.width);
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.items.length) {
                    rectangle = this.items[n].getBounds(false);
                    n2 = Math.max(n2, rectangle.x + rectangle.width);
                    ++n;
                }
            }
        }
        n = 0;
        while (n < this.items.length) {
            this.items[n].clear();
            if (bl) {
                this.items[n].clearAll(true, false);
            }
            ++n;
        }
        if (!bl2 || this.availableIndex == -1 || !this.expanded) {
            return;
        }
        if (this.parent.columns.length == 0) {
            n = 0;
            if (bl) {
                int n3 = 1;
                while (n3 < treeItemArray.length) {
                    Rectangle rectangle2 = treeItemArray[n3].getBounds(false);
                    n = Math.max(n, rectangle2.x + rectangle2.width);
                    ++n3;
                }
            } else {
                rectangle = this.items[0].getBounds(false);
                n = rectangle.x + rectangle.width;
            }
            this.parent.updateHorizontalBar(n, n - n2);
        }
        if (bl) {
            n = this.items[0].availableIndex;
            TreeItem treeItem = this.items[this.items.length - 1];
            int n4 = treeItem.availableIndex + treeItem.computeAvailableDescendentCount() - 1;
            this.parent.redrawItems(n, n4, false);
        } else {
            n = 0;
            while (n < this.items.length) {
                this.parent.redrawItem(this.items[n].availableIndex, false);
                ++n;
            }
        }
    }

    TreeItem[] computeAllDescendents() {
        int n = this.items.length;
        TreeItem[][] treeItemArrayArray = new TreeItem[n][];
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            treeItemArrayArray[n3] = this.items[n3].computeAllDescendents();
            n2 += treeItemArrayArray[n3].length;
            ++n3;
        }
        TreeItem[] treeItemArray = new TreeItem[n2];
        int n4 = 0;
        treeItemArray[n4++] = this;
        int n5 = 0;
        while (n5 < n) {
            System.arraycopy(treeItemArrayArray[n5], 0, treeItemArray, n4, treeItemArrayArray[n5].length);
            n4 += treeItemArrayArray[n5].length;
            ++n5;
        }
        return treeItemArray;
    }

    int computeAvailableDescendentCount() {
        int n = 1;
        if (!this.expanded) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            n += this.items[n2].computeAvailableDescendentCount();
            ++n2;
        }
        return n;
    }

    TreeItem[] computeAvailableDescendents() {
        if (!this.expanded) {
            return new TreeItem[]{this};
        }
        int n = this.items.length;
        TreeItem[][] treeItemArrayArray = new TreeItem[n][];
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            treeItemArrayArray[n3] = this.items[n3].computeAvailableDescendents();
            n2 += treeItemArrayArray[n3].length;
            ++n3;
        }
        TreeItem[] treeItemArray = new TreeItem[n2];
        int n4 = 0;
        treeItemArray[n4++] = this;
        int n5 = 0;
        while (n5 < n) {
            System.arraycopy(treeItemArrayArray[n5], 0, treeItemArray, n4, treeItemArrayArray[n5].length);
            n4 += treeItemArrayArray[n5].length;
            ++n5;
        }
        return treeItemArray;
    }

    void computeDisplayText(int n, GC gC) {
        int n2;
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n3 = this.parent.columns.length;
        if (n3 == 0) {
            String string = this.getText(0, false);
            this.textWidths[n] = gC.stringExtent((String)string).x;
            return;
        }
        int n4 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        TreeColumn treeColumn = this.parent.columns[n];
        if (n4 == 0) {
            n2 = treeColumn.getX() + treeColumn.width - this.getTextX(n) - 6;
        } else {
            n2 = treeColumn.width - 2 * this.parent.getCellPadding() - 6;
            if (this.images[n] != null) {
                n2 -= this.images[n].getBounds().width;
                n2 -= 3;
            }
        }
        String string = this.getText(n, false);
        int n5 = gC.stringExtent((String)string).x;
        if (n5 <= n2) {
            this.displayTexts[n] = string;
            this.textWidths[n] = n5;
            return;
        }
        int n6 = gC.stringExtent((String)"...").x;
        if ((n2 -= n6) <= 0) {
            this.displayTexts[n] = "...";
            this.textWidths[n] = n6;
            return;
        }
        int n7 = Math.min(n2 / gC.getFontMetrics().getAverageCharWidth(), string.length());
        n5 = gC.stringExtent((String)string.substring((int)0, (int)n7)).x;
        if (n2 == n5) {
            this.displayTexts[n] = String.valueOf(string.substring(0, n7)) + "...";
            this.textWidths[n] = n5 + n6;
            return;
        }
        if (n2 < n5) {
            do {
                if (--n7 < 0) {
                    this.displayTexts[n] = "...";
                    this.textWidths[n] = n6;
                    return;
                }
                string = string.substring(0, n7);
            } while (n2 < (n5 = gC.stringExtent((String)string).x));
            this.displayTexts[n] = String.valueOf(string) + "...";
            this.textWidths[n] = n5 + n6;
            return;
        }
        int n8 = 0;
        while (n5 < n2) {
            n8 = n5;
            n5 = gC.stringExtent((String)string.substring((int)0, (int)(++n7))).x;
        }
        this.displayTexts[n] = String.valueOf(string.substring(0, n7 - 1)) + "...";
        this.textWidths[n] = n8 + n6;
    }

    void computeDisplayTexts(GC gC) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n = this.parent.columns.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            gC.setFont(this.getFont(n2, false));
            this.computeDisplayText(n2, gC);
            ++n2;
        }
    }

    void computeTextWidths(GC gC) {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return;
        }
        int n = Math.max(1, this.parent.columns.length);
        this.textWidths = new int[n];
        int n2 = 0;
        while (n2 < this.textWidths.length) {
            String string = this.getDisplayText(n2);
            if (string != null) {
                gC.setFont(this.getFont(n2, false));
                this.textWidths[n2] = gC.stringExtent((String)string).x;
            }
            ++n2;
        }
    }

    public void dispose() {
        TreeItem treeItem;
        if (this.isDisposed()) {
            return;
        }
        int n = -1;
        int n2 = -1;
        Tree tree = this.parent;
        int n3 = this.getIndex();
        if (this.isAvailable()) {
            n = this.isLastChild() && n3 > 0 ? (this.parentItem != null ? this.parentItem.items[n3 - 1].availableIndex : tree.items[n3 - 1].availableIndex) : this.availableIndex;
            n2 = tree.availableItemsCount - 1;
        }
        if ((treeItem = tree.focusItem) != null && treeItem.hasAncestor(this)) {
            tree.setFocusItem(this, false);
            tree.reassignFocus();
            treeItem = tree.focusItem;
            if (treeItem != null) {
                tree.redrawItem(treeItem.availableIndex, true);
            }
        }
        if (this.parentItem != null) {
            this.parentItem.removeItem(this, n3);
        }
        this.dispose(true);
        if (n != -1) {
            tree.redrawItems(n, n2, false);
        }
    }

    void dispose(boolean bl) {
        if (this.isDisposed()) {
            return;
        }
        int n = 0;
        while (n < this.items.length) {
            this.items[n].dispose(bl);
            ++n;
        }
        if (bl) {
            this.parent.destroyItem(this);
        }
        super.dispose();
        this.foreground = null;
        this.background = null;
        this.cellForegrounds = null;
        this.cellBackgrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.images = null;
        this.displayTexts = null;
        this.texts = null;
        this.fontHeights = null;
        this.textWidths = null;
        this.parent = null;
        this.parentItem = null;
        this.items = null;
    }

    void expandAncestors() {
        if (this.parentItem != null) {
            this.parentItem.expandAncestors();
        }
        this.setExpanded(true);
        Event event = new Event();
        event.item = this;
        this.parent.inExpand = true;
        this.parent.sendEvent(17, event);
        this.parent.inExpand = false;
        if (this.isDisposed()) {
            return;
        }
        if (this.items.length == 0) {
            this.expanded = false;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[n] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[n];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(true);
    }

    Rectangle getBounds(boolean bl) {
        TreeColumn treeColumn;
        int n;
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] treeColumnArray = this.parent.getOrderedColumns();
        int n2 = treeColumnArray.length == 0 ? 0 : treeColumnArray[0].getIndex();
        int n3 = this.getTextX(n2);
        int n4 = this.textWidths[n2] + 6;
        if (treeColumnArray.length > 0 && n3 + n4 > (n = (treeColumn = treeColumnArray[0]).getX() + treeColumn.width)) {
            n4 = Math.max(0, n - n3);
        }
        return new Rectangle(n3, this.parent.getItemY(this), n4, this.parent.itemHeight);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] treeColumnArray = this.parent.columns;
        int n2 = treeColumnArray.length;
        int n3 = Math.max(1, n2);
        if (n < 0 || n >= n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 == 0) {
            return new Rectangle(this.getContentX(0), this.parent.getItemY(this), this.getContentWidth(0), this.parent.itemHeight - 1);
        }
        TreeColumn treeColumn = treeColumnArray[n];
        if (treeColumn.getOrderIndex() == 0) {
            int n4 = this.getContentX(n);
            int n5 = n4 - treeColumn.getX();
            int n6 = Math.max(0, treeColumn.width - n5 - 1);
            return new Rectangle(n4, this.parent.getItemY(this) + 1, n6, this.parent.itemHeight - 1);
        }
        return new Rectangle(treeColumn.getX(), this.parent.getItemY(this) + 1, treeColumn.width, this.parent.itemHeight - 1);
    }

    Rectangle getCellBounds(int n) {
        int n2 = this.parent.getItemY(this);
        if (this.parent.columns.length == 0) {
            int n3;
            if (this.customWidth != -1) {
                n3 = this.getContentX(0) + this.customWidth + this.parent.horizontalOffset;
            } else {
                int n4 = this.textWidths[0] + 6;
                n3 = this.getTextX(0) + n4 + this.parent.horizontalOffset;
            }
            return new Rectangle(-this.parent.horizontalOffset, n2, n3, this.parent.itemHeight);
        }
        TreeColumn treeColumn = this.parent.columns[n];
        return new Rectangle(treeColumn.getX(), n2, treeColumn.width, this.parent.itemHeight);
    }

    Rectangle getCheckboxBounds() {
        if ((this.parent.getStyle() & 0x20) == 0) {
            return null;
        }
        int n = this.parent.itemHeight;
        Rectangle rectangle = this.parent.checkboxBounds;
        Point[] pointArray = this.getHconnectorEndpoints();
        rectangle.x = pointArray[1].x;
        rectangle.y = this.parent.getItemY(this) + (n - rectangle.height) / 2;
        return rectangle;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.checked;
    }

    int getContentWidth(int n) {
        int n2;
        int n3 = this.textWidths[n] + 6;
        int n4 = n2 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        if (n2 == 0) {
            n3 += this.parent.orderedCol0imageWidth;
            if (this.parent.orderedCol0imageWidth > 0) {
                n3 += 3;
            }
        } else {
            Image image = this.getImage(n, false);
            if (image != null) {
                n3 += image.getBounds().width + 3;
            }
        }
        return n3;
    }

    int getContentX(int n) {
        int n2;
        int n3 = n2 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        if (n2 > 0) {
            TreeColumn treeColumn = this.parent.columns[n];
            int n4 = treeColumn.getX() + this.parent.getCellPadding();
            if ((treeColumn.style & 0x4000) != 0) {
                return n4;
            }
            int n5 = this.getContentWidth(n);
            if ((treeColumn.style & 0x20000) != 0) {
                int n6 = this.parent.getCellPadding();
                n4 = Math.max(n4, treeColumn.getX() + treeColumn.width - n6 - n5);
            } else {
                n4 = Math.max(n4, treeColumn.getX() + (treeColumn.width - n5) / 2);
            }
            return n4;
        }
        if ((this.parent.style & 0x20) != 0) {
            Rectangle rectangle = this.getCheckboxBounds();
            return rectangle.x + rectangle.width + 3;
        }
        int n7 = this.parent.getCellPadding() - this.parent.horizontalOffset;
        if (this.parentItem != null) {
            int n8 = this.parent.expanderBounds.width + 6;
            n7 += n8 * this.depth;
        }
        return (n7 += this.parent.expanderBounds.width) + 3 + 6;
    }

    String getDisplayText(int n) {
        if (this.parent.columns.length == 0) {
            return this.getText(0, false);
        }
        String string = this.displayTexts[n];
        return string != null ? string : "";
    }

    public boolean getExpanded() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.expanded;
    }

    Rectangle getExpanderBounds() {
        int n = this.parent.itemHeight;
        int n2 = this.parent.getCellPadding() - this.parent.horizontalOffset;
        int n3 = this.parent.getItemY(this);
        if (this.parentItem != null) {
            int n4 = this.parent.expanderBounds.width + 6;
            n2 += n4 * this.depth;
        }
        return new Rectangle(n2, n3 + (n - this.parent.expanderBounds.height) / 2, this.parent.expanderBounds.width, this.parent.expanderBounds.height);
    }

    Rectangle getFocusBounds() {
        int n;
        TreeColumn[] treeColumnArray = this.parent.columns;
        int n2 = treeColumnArray.length == 0 ? 0 : this.parent.getOrderedColumns()[0].getIndex();
        int n3 = this.getTextX(n2);
        if (treeColumnArray.length > 0) {
            TreeColumn treeColumn;
            int n4 = treeColumnArray[n2].getX() + treeColumnArray[n2].width;
            n3 = Math.min(n3, n4 - 1);
            if ((this.parent.style & 0x10000) != 0) {
                int[] nArray = this.parent.getColumnOrder();
                treeColumn = treeColumnArray[nArray[nArray.length - 1]];
            } else {
                treeColumn = treeColumnArray[n2];
            }
            n = treeColumn.getX() + treeColumn.width - n3 - 1;
        } else {
            n = this.customWidth != -1 ? this.customWidth : this.textWidths[0] + 6;
        }
        return new Rectangle(n3, this.parent.getItemY(this) + (this.parent.linesVisible ? 1 : 0), n, this.parent.itemHeight - (this.parent.linesVisible ? 1 : 0));
    }

    public Font getFont() {
        this.checkWidget();
        return this.getFont(true);
    }

    Font getFont(boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        return this.getFont(n, true);
    }

    Font getFont(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getFont(bl);
        }
        if (this.cellFonts == null || this.cellFonts[n] == null) {
            return this.getFont(bl);
        }
        return this.cellFonts[n];
    }

    int getFontHeight() {
        if (this.fontHeight != 0) {
            return this.fontHeight;
        }
        return this.parent.fontHeight;
    }

    int getFontHeight(int n) {
        if (this.fontHeights == null || this.fontHeights[n] == 0) {
            return this.getFontHeight();
        }
        return this.fontHeights[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[n] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[n];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.grayed;
    }

    Point[] getHconnectorEndpoints() {
        int n;
        int n2;
        Rectangle rectangle = this.getExpanderBounds();
        if (this.items.length == 0) {
            n2 = rectangle.x + Compatibility.ceil(rectangle.width, 2);
            n = Compatibility.floor(rectangle.width, 2) + 6;
        } else {
            n2 = rectangle.x + rectangle.width;
            n = 6;
        }
        int n3 = rectangle.y + rectangle.height / 2;
        return new Point[]{new Point(n2, n3), new Point(n2 + n, n3)};
    }

    Rectangle getHitBounds() {
        int[] nArray = this.parent.getColumnOrder();
        int n = nArray.length == 0 ? 0 : this.parent.columns[nArray[0]].getIndex();
        int n2 = this.getContentX(n);
        int n3 = 0;
        TreeColumn[] treeColumnArray = this.parent.columns;
        if (treeColumnArray.length == 0) {
            n3 = this.getContentWidth(0);
        } else {
            TreeColumn treeColumn = (this.parent.style & 0x10000) != 0 ? treeColumnArray[nArray[nArray.length - 1]] : treeColumnArray[n];
            n3 = treeColumn.getX() + treeColumn.width - n2;
        }
        return new Rectangle(n2, this.parent.getItemY(this), n3, this.parent.itemHeight);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        return this.getImage(n, true);
    }

    Image getImage(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return null;
        }
        if (n == 0) {
            return super.getImage();
        }
        return this.images[n];
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n3 = this.parent.getCellPadding();
        int n4 = this.getContentX(n);
        int n5 = this.parent.itemHeight;
        int n6 = n5 - 2 * n3;
        int n7 = this.parent.getItemY(this);
        int n8 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        Image image = this.getImage(n, false);
        int n9 = 0;
        if (n8 == 0) {
            n9 = this.parent.orderedCol0imageWidth;
        } else if (image != null) {
            n9 = image.getBounds().width;
        }
        return new Rectangle(n4, n7 + n3, n9, n6);
    }

    int getIndex() {
        TreeItem[] treeItemArray = this.parentItem != null ? this.parentItem.items : this.parent.items;
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n] == this) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.items.length;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        TreeItem[] treeItemArray = new TreeItem[this.items.length];
        System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
        return treeItemArray;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    int getPreferredWidth(int n) {
        Object object;
        int n2;
        int n3 = 0;
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        n3 += gC.stringExtent((String)this.getText((int)n, (boolean)false)).x + 6;
        int n4 = n2 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        if (n2 == 0) {
            if (this.parent.orderedCol0imageWidth > 0) {
                n3 += this.parent.orderedCol0imageWidth;
                n3 += 3;
            }
        } else {
            object = this.getImage(n, false);
            if (object != null) {
                n3 += ((Image)object).getBounds().width;
                n3 += 3;
            }
        }
        if (this.parent.hooks(41)) {
            object = new Event();
            ((Event)object).item = this;
            ((Event)object).gc = gC;
            ((Event)object).index = n;
            ((Event)object).x = this.getContentX(n);
            ((Event)object).y = this.parent.getItemY(this);
            ((Event)object).width = n3;
            ((Event)object).height = this.parent.itemHeight;
            this.parent.sendEvent(41, (Event)object);
            if (this.parent.itemHeight != ((Event)object).height) {
                this.parent.customHeightSet = true;
                boolean bl = this.parent.setItemHeight(((Event)object).height + 2 * this.parent.getCellPadding());
                if (bl) {
                    this.parent.redraw();
                }
            }
            n3 = ((Event)object).width;
        }
        gC.dispose();
        if (n2 == 0) {
            return this.getContentX(n) + this.parent.horizontalOffset + n3 + this.parent.getCellPadding();
        }
        return n3 + 2 * this.parent.getCellPadding();
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        return this.getText(n, true);
    }

    String getText(int n, boolean bl) {
        if (bl && !this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return "";
        }
        if (n == 0) {
            return super.getText();
        }
        if (this.texts[n] == null) {
            return "";
        }
        return this.texts[n];
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (!this.isAvailable()) {
            return new Rectangle(0, 0, 0, 0);
        }
        TreeColumn[] treeColumnArray = this.parent.columns;
        int n2 = treeColumnArray.length;
        int n3 = Math.max(1, n2);
        if (n < 0 || n >= n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 == 0) {
            int n4 = this.getTextX(0) + 3;
            int n5 = Math.max(0, this.getContentX(0) + this.getContentWidth(0) - n4);
            return new Rectangle(n4, this.parent.getItemY(this), n5, this.parent.itemHeight - 1);
        }
        TreeColumn treeColumn = treeColumnArray[n];
        if (treeColumn.getOrderIndex() == 0) {
            int n6 = this.getTextX(n) + 3;
            int n7 = n6 - treeColumn.getX();
            int n8 = Math.max(0, treeColumn.width - n7 - 1);
            return new Rectangle(n6, this.parent.getItemY(this) + 1, n8, this.parent.itemHeight - 1);
        }
        int n9 = this.getTextX(n) + 3;
        int n10 = n9 - treeColumn.getX();
        int n11 = Math.max(0, treeColumn.width - n10 - 3);
        return new Rectangle(n9, this.parent.getItemY(this) + 1, n11, this.parent.itemHeight - 1);
    }

    int getTextX(int n) {
        int n2 = this.parent.columns.length == 0 ? 0 : this.parent.columns[n].getOrderIndex();
        int n3 = this.getContentX(n);
        if (n2 == 0) {
            n3 += this.parent.orderedCol0imageWidth;
            if (this.parent.orderedCol0imageWidth > 0) {
                n3 += 3;
            }
        } else {
            Image image = this.getImage(n, false);
            if (image != null) {
                n3 += image.getBounds().width + 3;
            }
        }
        return n3;
    }

    boolean hasAncestor(TreeItem treeItem) {
        if (this == treeItem) {
            return true;
        }
        if (this.parentItem == null) {
            return false;
        }
        return this.parentItem.hasAncestor(treeItem);
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != this) {
            return -1;
        }
        return treeItem.getIndex();
    }

    boolean isAvailable() {
        if (this.parentItem == null) {
            return true;
        }
        if (!this.parentItem.expanded) {
            return false;
        }
        return this.parentItem.isAvailable();
    }

    boolean isInViewport() {
        if (this.availableIndex == -1) {
            return false;
        }
        int n = this.parent.topIndex;
        if (this.availableIndex < n) {
            return false;
        }
        int n2 = this.parent.clientArea.height / this.parent.itemHeight;
        return this.availableIndex <= n + n2;
    }

    boolean isLastChild() {
        if (this.parentItem != null) {
            return this.getIndex() == this.parentItem.items.length - 1;
        }
        return this.getIndex() == this.parent.items.length - 1;
    }

    boolean isSelected() {
        return this.parent.getSelectionIndex(this) != -1;
    }

    boolean paint(GC gC, TreeColumn treeColumn, boolean bl) {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        int n4;
        if (!this.parent.checkData(this, true)) {
            return false;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (treeColumn != null) {
            n5 = treeColumn.getIndex();
            n6 = treeColumn.getOrderIndex();
            n7 = treeColumn.getX();
        }
        int n8 = gC.getAlpha();
        boolean bl2 = gC.getAdvanced();
        int n9 = gC.getAntialias();
        Pattern pattern = gC.getBackgroundPattern();
        Pattern pattern2 = gC.getForegroundPattern();
        int n10 = gC.getInterpolation();
        int[] nArray = gC.getLineDash();
        int n11 = gC.getLineWidth();
        int n12 = gC.getTextAntialias();
        if (this.parent.hooks(41)) {
            int n13 = this.getContentWidth(n5);
            int n14 = this.getContentX(n5);
            gC.setFont(this.getFont(n5, false));
            Event event = new Event();
            event.item = this;
            event.gc = gC;
            event.index = n5;
            event.x = n14;
            event.y = this.parent.getItemY(this);
            event.width = n13;
            event.height = this.parent.itemHeight;
            this.parent.sendEvent(41, event);
            event.gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setLineDash(nArray);
            gC.setLineWidth(n11);
            gC.setTextAntialias(n12);
            gC.setAdvanced(bl2);
            if (this.isDisposed()) {
                return false;
            }
            if (this.parent.itemHeight != event.height) {
                this.parent.customHeightSet = true;
                n4 = this.parent.setItemHeight(event.height + 2 * this.parent.getCellPadding()) ? 1 : 0;
                if (n4 != 0) {
                    this.parent.redraw();
                }
            }
            if (this.parent.columns.length == 0) {
                n4 = event.width - (this.customWidth != -1 ? this.customWidth : n13);
                if (event.width != n13 || this.customWidth != -1) {
                    this.customWidth = event.width;
                }
                if (n4 != 0) {
                    this.parent.updateHorizontalBar(n14 + event.width, n4);
                }
            }
        }
        Rectangle rectangle = this.parent.clientArea;
        if (rectangle.x + rectangle.width < n7) {
            return false;
        }
        Rectangle rectangle2 = this.getCellBounds(n5);
        if (this.parent.linesVisible) {
            ++rectangle2.y;
            --rectangle2.height;
        }
        int n15 = 0;
        n15 = treeColumn != null ? treeColumn.getX() + treeColumn.width : rectangle2.x + rectangle2.width;
        gC.setClipping(n7, rectangle2.y, rectangle.width - n7, rectangle2.height);
        n4 = this.parent.getItemY(this);
        int n16 = this.parent.itemHeight;
        if (treeColumn == null) {
            this.parent.drawBackground(gC, 0, n4, rectangle.width, n16);
        } else {
            n3 = rectangle2.width;
            if (this.parent.linesVisible) {
                --n3;
            }
            this.parent.drawBackground(gC, rectangle2.x, rectangle2.y, n3, rectangle2.height);
        }
        n3 = this.isSelected() ? 1 : 0;
        int n17 = this.parent.focusItem == this && this.parent.isFocusControl() ? 1 : 0;
        int n18 = 1;
        int n19 = 1;
        int n20 = n3;
        int n21 = n17;
        if (this.parent.hooks(40)) {
            n18 = this.background == null && (this.cellBackgrounds == null || this.cellBackgrounds[n5] == null) ? 0 : 1;
            gC.setFont(this.getFont(n5, false));
            if (n3 != 0 && (n5 == 0 || (this.parent.style & 0x10000) != 0)) {
                gC.setForeground(this.display.getSystemColor(27));
                gC.setBackground(this.display.getSystemColor(26));
            } else {
                gC.setForeground(this.getForeground(n5));
                gC.setBackground(this.getBackground(n5));
            }
            object2 = new Event();
            ((Event)object2).item = this;
            ((Event)object2).gc = gC;
            ((Event)object2).index = n5;
            ((Event)object2).doit = true;
            ((Event)object2).detail = 16;
            if (n18 != 0) {
                ((Event)object2).detail |= 8;
            }
            if (n3 != 0) {
                ((Event)object2).detail |= 2;
            }
            if (n17 != 0) {
                ((Event)object2).detail |= 4;
            }
            ((Event)object2).x = rectangle2.x;
            ((Event)object2).y = rectangle2.y;
            ((Event)object2).width = rectangle2.width;
            ((Event)object2).height = rectangle2.height;
            gC.setClipping(rectangle2);
            this.parent.sendEvent(40, (Event)object2);
            ((Event)object2).gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setClipping(rectangle2);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setLineDash(nArray);
            gC.setLineWidth(n11);
            gC.setTextAntialias(n12);
            gC.setAdvanced(bl2);
            if (this.isDisposed()) {
                return false;
            }
            if (!((Event)object2).doit) {
                n21 = 0;
                n20 = 0;
                n19 = 0;
                n18 = 0;
            } else {
                n18 = n18 != 0 && (((Event)object2).detail & 8) != 0 ? 1 : 0;
                n19 = (((Event)object2).detail & 0x10) != 0 ? 1 : 0;
                n20 = n3 != 0 && (((Event)object2).detail & 2) != 0 ? 1 : 0;
                int n22 = n21 = n17 != 0 && (((Event)object2).detail & 4) != 0 ? 1 : 0;
            }
        }
        if (n18 != 0) {
            gC.setBackground(this.getBackground(n5));
            if (n5 == 0 && (treeColumn == null || treeColumn.getOrderIndex() == 0)) {
                object2 = this.getFocusBounds();
                n2 = 0;
                if (treeColumn == null) {
                    n2 = ((Rectangle)object2).width;
                } else {
                    n2 = treeColumn.width - ((Rectangle)object2).x;
                    if (this.parent.linesVisible) {
                        --n2;
                    }
                }
                gC.fillRectangle(((Rectangle)object2).x, ((Rectangle)object2).y, n2, ((Rectangle)object2).height);
            } else {
                int n23 = rectangle2.width;
                gC.fillRectangle(rectangle2.x, rectangle2.y, n23, rectangle2.height);
            }
        }
        if (n20 != 0 && n3 != 0 && (n6 == 0 || (this.parent.style & 0x10000) != 0)) {
            gC.setBackground(this.display.getSystemColor(26));
            if (n6 == 0) {
                Rectangle rectangle3 = this.getFocusBounds();
                n2 = rectangle3.width;
                if (this.parent.columns.length < 2 || (this.parent.style & 0x10000) == 0) {
                    n2 -= 2;
                }
                if (n2 > 0) {
                    gC.fillRectangle(rectangle3.x + 1, rectangle3.y + 1, n2, rectangle3.height - 2);
                }
            } else {
                int n24 = treeColumn.width;
                int[] nArray2 = this.parent.getColumnOrder();
                if (n5 == nArray2[nArray2.length - 1]) {
                    n24 -= 2;
                }
                if (n24 > 0) {
                    gC.fillRectangle(treeColumn.getX(), rectangle2.y + 1, n24, rectangle2.height - 2);
                }
            }
        }
        if (bl) {
            return false;
        }
        if (n6 == 0) {
            Object object3;
            gC.setClipping(rectangle2);
            Rectangle rectangle4 = this.getExpanderBounds();
            Color color = gC.getForeground();
            gC.setForeground(this.parent.getConnectorColor());
            int n25 = rectangle4.x + rectangle4.width / 2;
            n = rectangle4.y;
            if (this.items.length == 0) {
                n += rectangle4.height / 2;
            }
            if (this.parentItem != null || this.getIndex() != 0) {
                gC.drawLine(n25, n4, n25, n);
            }
            if (!this.isLastChild()) {
                if (this.items.length != 0) {
                    n += rectangle4.height;
                }
                gC.drawLine(n25, n, n25, n4 + n16);
            }
            Point[] pointArray = this.getHconnectorEndpoints();
            gC.drawLine(pointArray[0].x, pointArray[0].y, pointArray[1].x - 3, pointArray[1].y);
            object = this.parentItem;
            while (object != null) {
                if (!((TreeItem)object).isLastChild()) {
                    object3 = ((TreeItem)object).getExpanderBounds();
                    n25 = ((Rectangle)object3).x + ((Rectangle)object3).width / 2;
                    gC.drawLine(n25, n4, n25, n4 + n16);
                }
                object = ((TreeItem)object).parentItem;
            }
            gC.setForeground(color);
            if (this.items.length > 0) {
                object3 = this.expanded ? this.parent.getExpandedImage() : this.parent.getCollapsedImage();
                gC.drawImage((Image)object3, rectangle4.x, rectangle4.y);
            }
            if ((this.parent.style & 0x20) != 0) {
                object3 = this.grayed ? this.parent.getGrayUncheckedImage() : this.parent.getUncheckedImage();
                Rectangle rectangle5 = this.getCheckboxBounds();
                gC.drawImage((Image)object3, rectangle5.x, rectangle5.y);
                if (this.checked) {
                    Image image = this.parent.getCheckmarkImage();
                    Rectangle rectangle6 = image.getBounds();
                    int n26 = (rectangle5.width - rectangle6.width) / 2;
                    int n27 = (rectangle5.height - rectangle6.height) / 2;
                    gC.drawImage(image, rectangle5.x + n26, rectangle5.y + n27);
                }
            }
        }
        if (n19 != 0) {
            Image image = this.getImage(n5, false);
            String string = this.getDisplayText(n5);
            Rectangle rectangle7 = this.getImageBounds(n5);
            n = rectangle7.x;
            int n28 = this.parent.getCellPadding();
            gC.setClipping(n, rectangle2.y + n28 - (this.parent.linesVisible ? 1 : 0), n15 - n - n28, rectangle2.height - 2 * (n28 - (this.parent.linesVisible ? 1 : 0)));
            if (image != null) {
                object = image.getBounds();
                gC.drawImage(image, 0, 0, ((Rectangle)object).width, ((Rectangle)object).height, rectangle7.x, rectangle7.y, rectangle7.width, rectangle7.height);
            }
            if (string.length() > 0) {
                gC.setFont(this.getFont(n5, false));
                int n29 = this.getFontHeight(n5);
                if (n20 != 0 && (n6 == 0 || (this.parent.style & 0x10000) != 0)) {
                    gC.setForeground(this.display.getSystemColor(27));
                } else if (n3 == 0 || n20 != 0) {
                    gC.setForeground(this.getForeground(n5));
                }
                n7 = this.getTextX(n5) + 3;
                gC.drawString(string, n7, n4 + (n16 - n29) / 2, true);
            }
        }
        if (this.parent.hooks(42)) {
            int n30 = this.getContentWidth(n5);
            int n31 = this.getContentX(n5);
            gC.setFont(this.getFont(n5, false));
            if (n3 != 0 && (n5 == 0 || (this.parent.style & 0x10000) != 0)) {
                gC.setForeground(this.display.getSystemColor(27));
                gC.setBackground(this.display.getSystemColor(26));
            } else {
                gC.setForeground(this.getForeground(n5));
                gC.setBackground(this.getBackground(n5));
            }
            Event event = new Event();
            event.item = this;
            event.gc = gC;
            event.index = n5;
            if (n3 != 0) {
                event.detail |= 2;
            }
            if (n21 != 0) {
                event.detail |= 4;
            }
            event.x = n31;
            event.y = rectangle2.y;
            event.width = n30;
            event.height = rectangle2.height;
            gC.setClipping(rectangle2);
            this.parent.sendEvent(42, event);
            event.gc = null;
            if (gC.isDisposed()) {
                return false;
            }
            gC.setAlpha(n8);
            gC.setAntialias(n9);
            gC.setBackgroundPattern(pattern);
            gC.setClipping(rectangle2);
            gC.setForegroundPattern(pattern2);
            gC.setInterpolation(n10);
            gC.setLineDash(nArray);
            gC.setLineWidth(n11);
            gC.setTextAntialias(n12);
            gC.setAdvanced(bl2);
            int n32 = n21 = n17 != 0 && (event.detail & 4) != 0 ? 1 : 0;
        }
        return n17 != 0 && n21 == 0;
    }

    void redraw(int n, int n2, int n3, int n4, int n5) {
        if (!this.parent.hooks(40) && !this.parent.hooks(42)) {
            this.parent.redraw(n, n2, n3, n4, false);
            return;
        }
        Rectangle rectangle = this.getCellBounds(n5);
        this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    void redrawItem() {
        if (!this.isAvailable()) {
            return;
        }
        this.parent.redraw(0, this.parent.getItemY(this), this.parent.clientArea.width, this.parent.itemHeight, false);
    }

    void removeColumn(TreeColumn treeColumn, int n, int n2) {
        Object object;
        Resource[] resourceArray;
        int n3 = this.parent.columns.length;
        if (n3 == 0) {
            this.cellForegrounds = null;
            this.cellBackgrounds = null;
            this.displayTexts = null;
            this.cellFonts = null;
            this.fontHeights = null;
            GC gC = new GC(this.parent);
            this.computeTextWidths(gC);
            gC.dispose();
            int n4 = 0;
            while (n4 < this.items.length) {
                this.items[n4].removeColumn(treeColumn, n, n2);
                ++n4;
            }
            return;
        }
        String[] stringArray = new String[n3];
        System.arraycopy(this.texts, 0, stringArray, 0, n);
        System.arraycopy(this.texts, n + 1, stringArray, n, n3 - n);
        this.texts = stringArray;
        Image[] imageArray = new Image[n3];
        System.arraycopy(this.images, 0, imageArray, 0, n);
        System.arraycopy(this.images, n + 1, imageArray, n, n3 - n);
        this.images = imageArray;
        int[] nArray = new int[n3];
        System.arraycopy(this.textWidths, 0, nArray, 0, n);
        System.arraycopy(this.textWidths, n + 1, nArray, n, n3 - n);
        this.textWidths = nArray;
        String[] stringArray2 = new String[n3];
        System.arraycopy(this.displayTexts, 0, stringArray2, 0, n);
        System.arraycopy(this.displayTexts, n + 1, stringArray2, n, n3 - n);
        this.displayTexts = stringArray2;
        if (this.cellBackgrounds != null) {
            resourceArray = new Color[n3];
            System.arraycopy(this.cellBackgrounds, 0, resourceArray, 0, n);
            System.arraycopy(this.cellBackgrounds, n + 1, resourceArray, n, n3 - n);
            this.cellBackgrounds = resourceArray;
        }
        if (this.cellForegrounds != null) {
            resourceArray = new Color[n3];
            System.arraycopy(this.cellForegrounds, 0, resourceArray, 0, n);
            System.arraycopy(this.cellForegrounds, n + 1, resourceArray, n, n3 - n);
            this.cellForegrounds = resourceArray;
        }
        if (this.cellFonts != null) {
            resourceArray = new Font[n3];
            System.arraycopy(this.cellFonts, 0, resourceArray, 0, n);
            System.arraycopy(this.cellFonts, n + 1, resourceArray, n, n3 - n);
            this.cellFonts = resourceArray;
            object = new int[n3];
            System.arraycopy(this.fontHeights, 0, object, 0, n);
            System.arraycopy(this.fontHeights, n + 1, object, n, n3 - n);
            this.fontHeights = (int[])object;
        }
        if (n == 0) {
            this.text = this.texts[0] != null ? this.texts[0] : "";
            this.texts[0] = null;
            this.image = this.images[0];
            this.images[0] = null;
        }
        if (n2 == 0) {
            int n5 = this.parent.getOrderedColumns()[0].getIndex();
            object = new GC(this.parent);
            ((GC)object).setFont(this.getFont(n5, false));
            this.computeDisplayText(n5, (GC)object);
            ((Resource)object).dispose();
        }
        if (n3 < 2) {
            this.texts = null;
            this.images = null;
        }
        int n6 = 0;
        while (n6 < this.items.length) {
            this.items[n6].removeColumn(treeColumn, n, n2);
            ++n6;
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        int n = this.parent.availableItemsCount - 1;
        TreeItem treeItem = this.parent.focusItem;
        if (treeItem != null && treeItem.hasAncestor(this)) {
            this.parent.setFocusItem(this, false);
        }
        while (this.items.length > 0) {
            this.items[0].dispose(true);
            this.removeItem(this.items[0], 0);
        }
        this.items = Tree.NO_ITEMS;
        this.expanded = false;
        if (this.isAvailable()) {
            this.parent.redrawItems(this.availableIndex, n, false);
        }
    }

    void removeItem(TreeItem treeItem, int n) {
        if (this.isDisposed()) {
            return;
        }
        TreeItem[] treeItemArray = new TreeItem[this.items.length - 1];
        System.arraycopy(this.items, 0, treeItemArray, 0, n);
        System.arraycopy(this.items, n + 1, treeItemArray, n, treeItemArray.length - n);
        this.items = treeItemArray;
        if (this.items.length == 0) {
            this.items = Tree.NO_ITEMS;
            if (!this.parent.inExpand) {
                this.expanded = false;
                if (this.isInViewport()) {
                    Rectangle rectangle = this.getExpanderBounds();
                    this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            }
            return;
        }
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setBackground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellBackgrounds == null) {
            if (color == null) {
                return;
            }
            this.cellBackgrounds = new Color[n2];
        }
        if ((color2 = this.cellBackgrounds[n]) == color) {
            return;
        }
        this.cellBackgrounds[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCellBounds(n);
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.checked = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            if (this.parent.hooks(40) || this.parent.hooks(42)) {
                this.redrawItem();
            } else {
                Rectangle rectangle = this.getCheckboxBounds();
                this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
        }
    }

    public void setExpanded(boolean bl) {
        Object object;
        this.checkWidget();
        if (this.expanded == bl) {
            return;
        }
        if (this.items.length == 0) {
            return;
        }
        if (this.parent.inExpand) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (bl) {
            Object object2;
            int n;
            this.expanded = bl;
            if (this.availableIndex == -1) {
                return;
            }
            object = this.computeAvailableDescendents();
            int n2 = ((TreeItem[])object).length;
            if (this.availableIndex != this.parent.availableItemsCount - 1) {
                Rectangle rectangle = this.parent.clientArea;
                n = this.parent.getItemY(this) + this.parent.itemHeight;
                if (n > 0 && n < rectangle.height && this.parent.drawCount <= 0) {
                    this.parent.update();
                    object2 = new GC(this.parent);
                    ((GC)object2).copyArea(0, n, rectangle.width, rectangle.height - n, 0, n + (n2 - 1) * this.parent.itemHeight);
                    ((Resource)object2).dispose();
                }
            }
            this.parent.makeDescendentsAvailable(this, (TreeItem[])object);
            int n3 = 0;
            n = 1;
            while (n < ((TreeItem[])object).length) {
                object2 = object[n].getBounds(false);
                n3 = Math.max(n3, ((Rectangle)object2).x + ((Rectangle)object2).width);
                ++n;
            }
            this.parent.updateHorizontalBar(n3, n3);
            this.parent.updateVerticalBar();
            if (this.availableIndex < this.parent.topIndex) {
                this.parent.topIndex += n2 - 1;
                ScrollBar scrollBar = this.parent.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.parent.topIndex);
                }
                return;
            }
            n = this.availableIndex + 1;
            int n4 = n + n2 - 2;
            this.parent.redrawItems(n, n4, false);
        } else {
            object = this.computeAvailableDescendents();
            this.expanded = bl;
            if (this.availableIndex == -1) {
                return;
            }
            Rectangle rectangle = this.parent.clientArea;
            int n = this.parent.getItemY(this) + this.parent.itemHeight;
            int n5 = n + (((TreeItem[])object).length - 1) * this.parent.itemHeight;
            if (n < rectangle.height && n5 > 0 && this.parent.drawCount <= 0) {
                this.parent.update();
                GC gC = new GC(this.parent);
                gC.copyArea(0, n5, rectangle.width, rectangle.height - n5, 0, n);
                gC.dispose();
                int n6 = n + Math.max(0, rectangle.height - n5);
                this.parent.redraw(0, n6, rectangle.width, rectangle.height - n6, false);
            }
            this.parent.makeDescendentsUnavailable(this, (TreeItem[])object);
            int n7 = this.availableIndex + ((TreeItem[])object).length - 1;
            if (n7 < this.parent.topIndex) {
                this.parent.topIndex = this.parent.topIndex - ((TreeItem[])object).length + 1;
                ScrollBar scrollBar = this.parent.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.parent.topIndex);
                }
            }
            this.parent.updateHorizontalBar();
            this.parent.updateVerticalBar();
            TreeItem treeItem = this.parent.focusItem;
            if (treeItem != null && treeItem != this && treeItem.hasAncestor(this)) {
                this.parent.setFocusItem(this, false);
                if ((this.parent.style & 4) != 0) {
                    this.parent.selectItem(this, false);
                }
                Event event = new Event();
                event.item = this;
                this.parent.sendEvent(13, event);
                if (this.isDisposed()) {
                    return;
                }
                this.parent.showItem(this);
                this.parent.redrawItem(this.availableIndex, true);
            }
        }
        if (this.isInViewport()) {
            object = this.getExpanderBounds();
            this.parent.redraw(object.x, object.y, object.width, object.height, false);
        }
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(false));
        this.fontHeight = gC.getFontMetrics().getHeight();
        this.computeDisplayTexts(gC);
        this.computeTextWidths(gC);
        gC.dispose();
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            int n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
        this.redrawItem();
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellFonts == null) {
            if (font == null) {
                return;
            }
            this.cellFonts = new Font[n2];
        }
        if ((font2 = this.cellFonts[n]) == font) {
            return;
        }
        this.cellFonts[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        if (this.fontHeights == null) {
            this.fontHeights = new int[n2];
        }
        this.fontHeights[n] = gC.getFontMetrics().getHeight();
        this.computeDisplayText(n, gC);
        gC.dispose();
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCellBounds(n);
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redrawItem();
    }

    public void setForeground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (this.cellForegrounds == null) {
            if (color == null) {
                return;
            }
            this.cellForegrounds = new Color[n2];
        }
        if ((color2 = this.cellForegrounds[n]) == color) {
            return;
        }
        this.cellForegrounds[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(n), this.parent.getItemY(this), this.textWidths[n] + 6, this.parent.itemHeight, n);
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.isInViewport()) {
            Rectangle rectangle = this.getCheckboxBounds();
            this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            if (imageArray[n] != null) {
                this.setImage(n, imageArray[n]);
            }
            ++n;
        }
    }

    public void setImage(int n, Image image) {
        Object object;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        TreeColumn[] treeColumnArray = this.parent.columns;
        int n2 = Math.max(1, treeColumnArray.length);
        if (n < 0 || n >= n2) {
            return;
        }
        Image image2 = this.getImage(n, false);
        if (image == image2) {
            return;
        }
        if (image != null && image.equals(image2)) {
            return;
        }
        if (n == 0) {
            super.setImage(image);
        } else {
            this.images[n] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (treeColumnArray.length > 0) {
            object = new GC(this.parent);
            ((GC)object).setFont(this.getFont(n, false));
            this.computeDisplayText(n, (GC)object);
            ((Resource)object).dispose();
        }
        if (image == null) {
            this.redrawItem();
            return;
        }
        if (treeColumnArray.length == 0) {
            if (this.parent.imageHeight == 0) {
                object = image.getBounds();
                this.parent.orderedCol0imageWidth = ((Rectangle)object).width;
                this.parent.setImageHeight(((Rectangle)object).height);
                this.parent.redrawItems(0, this.parent.availableItemsCount - 1, false);
            } else {
                this.redrawItem();
            }
            return;
        }
        object = treeColumnArray[n];
        int n3 = ((TreeColumn)object).getOrderIndex();
        Rectangle rectangle = image.getBounds();
        if (((TreeColumn)object).itemImageWidth == 0) {
            ((TreeColumn)object).itemImageWidth = rectangle.width;
        }
        if (this.parent.imageHeight == 0) {
            int n4 = this.parent.itemHeight;
            this.parent.setImageHeight(rectangle.height);
            if (n3 == 0) {
                this.parent.orderedCol0imageWidth = rectangle.width;
                TreeItem[] treeItemArray = this.parent.items;
                GC gC = new GC(this.parent);
                int n5 = 0;
                while (n5 < treeItemArray.length) {
                    treeItemArray[n5].updateColumnWidth((TreeColumn)object, gC);
                    ++n5;
                }
                gC.dispose();
                if (n4 != this.parent.itemHeight) {
                    this.parent.redraw();
                } else {
                    this.parent.redraw(((TreeColumn)object).getX(), 0, ((TreeColumn)object).width, this.parent.clientArea.height, false);
                }
            } else if (n4 != this.parent.itemHeight) {
                this.parent.redraw();
            } else {
                this.redrawItem();
            }
            return;
        }
        if (n3 == 0 && this.parent.orderedCol0imageWidth == 0) {
            this.parent.orderedCol0imageWidth = rectangle.width;
            TreeItem[] treeItemArray = this.parent.items;
            GC gC = new GC(this.parent);
            int n6 = 0;
            while (n6 < treeItemArray.length) {
                treeItemArray[n6].updateColumnWidth((TreeColumn)object, gC);
                ++n6;
            }
            gC.dispose();
            this.parent.redraw(((TreeColumn)object).getX(), 0, ((TreeColumn)object).width, this.parent.clientArea.height, false);
            return;
        }
        this.redrawItem();
    }

    public void setItemCount(int n) {
        int n2;
        int n3;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.items.length) {
            return;
        }
        if (n < this.items.length) {
            n3 = n > 0 ? this.items[n - 1].availableIndex : this.availableIndex;
            n2 = this.parent.availableItemsCount - 1;
            int n4 = n;
            while (n4 < this.items.length) {
                this.items[n4].dispose(true);
                ++n4;
            }
            if (n == 0) {
                this.items = Tree.NO_ITEMS;
            } else {
                TreeItem[] treeItemArray = new TreeItem[n];
                System.arraycopy(this.items, 0, treeItemArray, 0, n);
                this.items = treeItemArray;
            }
            if (n == 0) {
                this.expanded = false;
            }
        } else {
            int n5 = this.computeAvailableDescendentCount();
            int n6 = n - this.items.length;
            n3 = this.items.length == 0 ? this.availableIndex : this.items[this.items.length - 1].availableIndex;
            n2 = this.expanded && this.isAvailable() ? this.parent.availableItemsCount + n6 - 1 : n3;
            TreeItem[] treeItemArray = new TreeItem[n];
            System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
            this.items = treeItemArray;
            int n7 = this.items.length - n6;
            while (n7 < n) {
                this.items[n7] = new TreeItem(this, 0, n7, false);
                ++n7;
            }
            if (this.expanded && this.availableIndex != -1) {
                if (this.parent.availableItems.length < this.parent.availableItemsCount + n6) {
                    TreeItem[] treeItemArray2 = new TreeItem[this.parent.availableItemsCount + n6];
                    System.arraycopy(this.parent.availableItems, 0, treeItemArray2, 0, this.parent.availableItemsCount);
                    this.parent.availableItems = treeItemArray2;
                }
                TreeItem[] treeItemArray3 = this.parent.availableItems;
                int n8 = this.availableIndex + n5 + n6;
                System.arraycopy(treeItemArray3, this.availableIndex + n5, treeItemArray3, n8, treeItemArray3.length - n8);
                this.parent.availableItemsCount += n6;
                System.arraycopy(this.items, this.items.length - n6, treeItemArray3, this.availableIndex + n5, n6);
                int n9 = this.availableIndex + n5;
                while (n9 < this.parent.availableItemsCount) {
                    treeItemArray3[n9].availableIndex = n9;
                    ++n9;
                }
            }
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.availableIndex != -1) {
            if (this.expanded) {
                this.parent.updateVerticalBar();
            }
            this.parent.redrawItems(n3, n2, false);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        this.setText(0, string);
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            int n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        Rectangle rectangle = this.getBounds(false);
        int n = rectangle.x + rectangle.width;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                this.setText(n2, stringArray[n2]);
            }
            ++n2;
        }
        if (this.parent.columns.length == 0) {
            rectangle = this.getBounds(false);
            n2 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n2, n2 - n);
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = Math.max(1, this.parent.columns.length);
        if (n < 0 || n >= n2) {
            return;
        }
        if (string.equals(this.getText(n, false))) {
            return;
        }
        if (n == 0) {
            super.setText(string);
        } else {
            this.texts[n] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        int n3 = this.textWidths[n];
        GC gC = new GC(this.parent);
        gC.setFont(this.getFont(n, false));
        this.computeDisplayText(n, gC);
        gC.dispose();
        if (this.availableIndex == -1) {
            return;
        }
        if (this.parent.columns.length == 0) {
            Rectangle rectangle = this.getBounds(false);
            int n4 = rectangle.x + rectangle.width;
            this.parent.updateHorizontalBar(n4, this.textWidths[n] - n3);
        }
        if (this.isInViewport()) {
            this.redraw(this.getTextX(n), this.parent.getItemY(this), Math.max(n3, this.textWidths[n]) + 6, this.parent.itemHeight, n);
        }
    }

    void updateColumnWidth(TreeColumn treeColumn, GC gC) {
        int n;
        int n2 = treeColumn.getIndex();
        gC.setFont(this.getFont(n2, false));
        String string = this.displayTexts[n2];
        this.computeDisplayText(n2, gC);
        if (this.isInViewport()) {
            Rectangle rectangle;
            int n3 = n = (treeColumn.style & 0x4000) != 0 ? 1 : 0;
            if (n == 0 || this.parent.hooks(40) || this.parent.hooks(42)) {
                rectangle = this.getCellBounds(n2);
                this.parent.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            } else if (string == null || !string.equals(this.displayTexts[n2])) {
                rectangle = this.getCellBounds(n2);
                int n4 = this.getTextX(n2);
                this.parent.redraw(n4, rectangle.y, rectangle.x + rectangle.width - n4, rectangle.height, false);
            }
        }
        n = 0;
        while (n < this.items.length) {
            this.items[n].updateColumnWidth(treeColumn, gC);
            ++n;
        }
    }

    void updateFont(GC gC) {
        if (this.font == null) {
            this.computeDisplayTexts(gC);
            this.computeTextWidths(gC);
        }
        int n = 0;
        while (n < this.items.length) {
            this.items[n].updateFont(gC);
            ++n;
        }
    }
}

