/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

class FactoryOverrideRegistryReader
extends RegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";
    static final String ATT_PREDECESSOR = "predecessor";

    public FactoryOverrideRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "factory_override");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                    if (ePackageDescriptor instanceof EPackage.Descriptor) {
                        if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                            RegistryReader.EFactoryDescriptor oldFactoryDescriptor = (RegistryReader.EFactoryDescriptor)ePackageDescriptor;
                            String oldPredecessor = oldFactoryDescriptor.element.getAttribute(ATT_PREDECESSOR);
                            if (oldPredecessor != null && oldPredecessor.equals(element.getAttribute(ATT_CLASS))) {
                                return true;
                            }
                            String newPredecessor = element.getAttribute(ATT_PREDECESSOR);
                            if (newPredecessor == null || !newPredecessor.equals(oldFactoryDescriptor.element.getAttribute(ATT_CLASS))) {
                                EcorePlugin.INSTANCE.log("Both '" + oldFactoryDescriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a factory override for '" + packageURI + "'");
                            }
                        }
                        RegistryReader.EFactoryDescriptor newFactoryDescriptor = new RegistryReader.EFactoryDescriptor(element, ATT_CLASS, (EPackage.Descriptor)ePackageDescriptor);
                        EPackage.Registry.INSTANCE.put(packageURI, newFactoryDescriptor);
                    }
                    return true;
                }
                Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                    EPackage.Registry.INSTANCE.put(packageURI, ((RegistryReader.EFactoryDescriptor)ePackageDescriptor).getOverridenDescriptor());
                }
                return true;
            }
        }
        return false;
    }
}

