/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    int modelHandle;
    int topIndex;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    static final int TEXT_COLUMN = 0;
    double cachedAdjustment;
    double currentAdjustment;
    boolean rowActivated;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        GTK.gtk_list_store_append(this.modelHandle, iter);
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        if (index == count) {
            GTK.gtk_list_store_append(this.modelHandle, iter);
        } else {
            GTK.gtk_list_store_insert(this.modelHandle, iter, index);
        }
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int index) {
        int columnHandle;
        int textRenderer;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = GTK.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = new int[]{OS.G_TYPE_STRING()};
        this.modelHandle = GTK.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((textRenderer = GTK.gtk_cell_renderer_text_new()) == 0) {
            this.error(2);
        }
        if ((columnHandle = GTK.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        GTK.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, 0);
        GTK.gtk_tree_view_column_set_min_width(columnHandle, 0);
        GTK.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        GTK.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        GTK.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(selectionHandle, mode);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            GTK.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.getShell().style & 0x4000) != 0) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        GTK.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (GTK.GTK3 && size.y == 0 && hHint == -1) {
            size.y = this.getItemCount() * this.getItemHeightInPixels();
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handleRGBA;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        GTK.gtk_tree_selection_unselect_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start < 0 && end < 0) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (start >= count && end >= count) {
            return;
        }
        start = Math.min(count - 1, Math.max(0, start));
        end = Math.min(count - 1, Math.max(0, end));
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            GTK.gtk_tree_selection_unselect_iter(selection, iter);
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index <= count - 1) {
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                GTK.gtk_tree_selection_unselect_iter(selection, iter);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselectAll() {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean selected = false;
        if (OS.isX11()) {
            boolean dragDetect;
            if (filter) {
                int[] path = new int[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                    if (path[0] != 0) {
                        int selection = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                            selected = true;
                        }
                        GTK.gtk_tree_path_free(path[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
                consume[0] = true;
            }
            return dragDetect;
        }
        double[] startX = new double[1];
        double[] startY = new double[1];
        int[] path = new int[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)startX[0], (int)startY[0], path, null, null, null)) {
                if (path[0] != 0) {
                    boolean dragDetect = super.dragDetect(x, y, filter, false, consume);
                    if (dragDetect && selected && consume != null) {
                        consume[0] = true;
                    }
                    return dragDetect;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    @Override
    GdkColor getBackgroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getBaseGdkColor();
    }

    public int getFocusIndex() {
        this.checkWidget();
        int[] path = new int[1];
        GTK.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0) {
            return -1;
        }
        int indices = GTK.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[]{-1};
        if (indices != 0) {
            C.memmove(index, indices, 4);
        }
        GTK.gtk_tree_path_free(path[0]);
        return index[0];
    }

    @Override
    GdkColor getForegroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int[] ptr = new int[1];
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
        OS.g_free(iter);
        if (ptr[0] == 0) {
            return null;
        }
        int length = C.strlen(ptr[0]);
        byte[] buffer2 = new byte[length];
        C.memmove(buffer2, ptr[0], length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(buffer2));
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int column = GTK.gtk_tree_view_get_column(this.handle, 0);
        if (itemCount == 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            GTK.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            int height = h[0];
            if (GTK.GTK3) {
                int textRenderer = this.getTextRenderer(column);
                if (textRenderer != 0) {
                    GTK.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
                }
                height += h[0];
            }
            return height;
        }
        int height = 0;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        GTK.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int[] w = new int[1];
        int[] h = new int[1];
        GTK.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
        if (GTK.GTK3) {
            int textRenderer = this.getTextRenderer(column);
            int[] ypad = new int[1];
            if (textRenderer != 0) {
                GTK.gtk_cell_renderer_get_padding(textRenderer, null, ypad);
            }
            height = h[0] + ypad[0];
        } else {
            height = h[0];
        }
        OS.g_free(iter);
        return height;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int[] ptr = new int[1];
        String[] result = new String[count];
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int index = 0;
        while (index < count) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
            if (ptr[0] != 0) {
                int length = C.strlen(ptr[0]);
                byte[] buffer = new byte[length];
                C.memmove(buffer, ptr[0], length);
                OS.g_free(ptr[0]);
                result[index] = new String(Converter.mbcsToWcs(buffer));
            }
            ++index;
        }
        OS.g_free(iter);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        int list;
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        int originalList = list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0) {
            int[] index = new int[1];
            boolean foundIndex = false;
            while (list != 0) {
                int indices;
                int data = OS.g_list_data(list);
                if (!foundIndex && (indices = GTK.gtk_tree_path_get_indices(data)) != 0) {
                    C.memmove(index, indices, 4);
                    foundIndex = true;
                }
                list = OS.g_list_next(list);
                GTK.gtk_tree_path_free(data);
            }
            OS.g_list_free(originalList);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        int list;
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        int originalList = list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                int data = OS.g_list_data(list);
                int indices = GTK.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    int[] index = new int[1];
                    C.memmove(index, indices, 4);
                    treeSelection[length] = index[0];
                    ++length;
                }
                GTK.gtk_tree_path_free(data);
                list = OS.g_list_next(list);
                ++i;
            }
            OS.g_list_free(originalList);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    int getTextRenderer(int column) {
        int list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0) {
            return 0;
        }
        int originalList = list;
        int textRenderer = 0;
        while (list != 0) {
            int renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public int getTopIndex() {
        this.checkWidget();
        int vAdjustment = GTK.GTK3 ? GTK.gtk_scrollable_get_vadjustment(this.handle) : GTK.gtk_tree_view_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        if (this.cachedAdjustment == this.currentAdjustment) {
            return this.topIndex;
        }
        int[] path = new int[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0) {
            return 0;
        }
        int indices = GTK.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0) {
            C.memmove(index, indices, 4);
        }
        GTK.gtk_tree_path_free(path[0]);
        return index[0];
    }

    @Override
    int gtk_changed(int widget) {
        this.sendSelectionEvent(13);
        return 0;
    }

    @Override
    int gtk_event_after(int widget, int gdkEvent) {
        switch (GDK.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    int gtk_button_press_event(int widget, int event) {
        int button;
        int selection;
        int[] path;
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11() && gdkEvent.type == 4) {
            int nextEvent = GDK.gdk_event_peek();
            if (nextEvent == 0) {
                path = new int[1];
                selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path, null, null, null) && path[0] != 0) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(selection, path[0]) && ((gdkEvent.state & 5) == 0 || (gdkEvent.state & 4) != 0)) {
                        int gtk_false_funcPtr = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(selection, gtk_false_funcPtr, 0, 0);
                    }
                }
            } else {
                GDK.gdk_event_free(nextEvent);
            }
        }
        if ((button = gdkEvent.button) == 3 && gdkEvent.type == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1;
            }
            GTK.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            GTK.gtk_tree_path_free(path[0]);
        }
        if (gdkEvent.type == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return result;
    }

    @Override
    int gtk_row_activated(int tree, int path, int column) {
        this.rowActivated = true;
        return 0;
    }

    @Override
    int gtk_key_press_event(int widget, int event) {
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, event, GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        this.keyPressDefaultSelectionHandler(event, key);
        return super.gtk_key_press_event(widget, event);
    }

    @Override
    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (gdkEvent.window != GTK.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11()) {
            int[] path = new int[1];
            int selection = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(selection, 0, 0, 0);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path, null, null, null) && path[0] != 0 && GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((gdkEvent.state & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
                }
                if ((gdkEvent.state & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(selection, path[0]);
                }
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    void keyPressDefaultSelectionHandler(int event, int key) {
        int keymask = this.gdk_event_get_state(event);
        switch (key) {
            case 65293: {
                if ((keymask & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        Event event = new Event();
        event.index = this.getFocusIndex();
        if (event.index >= 0) {
            event.text = this.getItem(event.index);
        }
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] items = this.getItems();
        int i = start;
        while (i < items.length) {
            if (items[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(Integer.toString(index), true);
        int path = GTK.gtk_tree_path_new_from_string(buffer);
        boolean answer = GTK.gtk_tree_selection_path_is_selected(selection, path);
        GTK.gtk_tree_path_free(path);
        return answer;
    }

    @Override
    int paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_list_store_remove(this.modelHandle, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = end;
        while (index >= start) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            GTK.gtk_list_store_remove(this.modelHandle, iter);
            --index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                GTK.gtk_list_store_remove(this.modelHandle, iter);
                last = index;
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        GTK.gtk_tree_selection_select_iter(selection, iter);
        if ((this.style & 4) != 0) {
            int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_set_cursor(this.handle, path, 0, false);
            GTK.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            GTK.gtk_tree_selection_select_iter(selection, iter);
            if ((this.style & 4) != 0) {
                int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                GTK.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                GTK.gtk_tree_path_free(path);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < count) {
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                GTK.gtk_tree_selection_select_iter(selection, iter);
                if ((this.style & 4) != 0) {
                    int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                    GTK.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                    GTK.gtk_tree_path_free(path);
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    void selectFocusIndex(int index) {
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (index < 0 || index >= count) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_view_set_cursor(this.handle, path, 0, false);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        GTK.gtk_widget_modify_base(this.handle, 0, color);
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        GTK.gtk_widget_realize(this.handle);
        return result;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        byte[] buffer = Converter.wcsToMbcs(string, true);
        GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void setItems(String ... items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            byte[] buffer = Converter.wcsToMbcs(string, true);
            GTK.gtk_list_store_append(this.modelHandle, iter);
            GTK.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
            ++i2;
        }
        OS.g_free(iter);
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            GdkRGBA toSet = rgba == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : rgba;
            this.setForegroundGdkRGBA(this.handle, toSet);
        } else {
            super.setForegroundGdkRGBA(rgba);
        }
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        this.setForegroundColor(this.handle, color, false);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean first = true;
        int i = 0;
        while (i < length) {
            int index = 0;
            String string = items[i];
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    if ((this.style & 2) != 0) {
                        if (first) {
                            first = false;
                            this.selectFocusIndex(index);
                        } else {
                            this.select(index);
                        }
                    } else {
                        this.selectFocusIndex(index);
                        break;
                    }
                    ++index;
                }
            }
            ++i;
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        int vAdjustment = GTK.GTK3 ? GTK.gtk_scrollable_get_vadjustment(this.handle) : GTK.gtk_tree_view_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        this.topIndex = index;
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        GTK.gtk_widget_realize(this.handle);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0, false, 0.0f, 0.0f);
        GdkRectangle visibleRect = new GdkRectangle();
        GTK.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        GdkRectangle cellRect = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
        int[] tx = new int[1];
        int[] ty = new int[1];
        GTK.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        if (ty[0] < visibleRect.y) {
            GTK.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        } else {
            int height = Math.min(visibleRect.height, cellRect.height);
            if (ty[0] + height > visibleRect.y + visibleRect.height) {
                ty[0] = ty[0] + (cellRect.height - visibleRect.height);
                GTK.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
            }
        }
        GTK.gtk_tree_path_free(path);
        OS.g_free(iter);
    }
}

