/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.Utils;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static String SSH_HOME_DEFAULT = null;
    public static String SSH_OLD_WIN32_HOME_DEFAULT = null;

    static {
        SSH_HOME_DEFAULT = System.getProperty("user.home");
        if (SSH_HOME_DEFAULT != null) {
            SSH_OLD_WIN32_HOME_DEFAULT = String.valueOf(SSH_HOME_DEFAULT) + File.separator + "ssh";
            SSH_HOME_DEFAULT = String.valueOf(SSH_HOME_DEFAULT) + File.separator + ".ssh";
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences defaultNode = DefaultScope.INSTANCE.getNode(JSchCorePlugin.ID);
        if (SSH_HOME_DEFAULT != null) {
            defaultNode.put("SSH2HOME", SSH_HOME_DEFAULT);
        }
        defaultNode.put("PRIVATEKEY", "id_dsa,id_rsa");
        this.changeDefaultWin32SshHome();
        Utils.migrateSSH2Preferences();
    }

    private void changeDefaultWin32SshHome() {
        if (!Platform.getOS().equals("win32")) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(JSchCorePlugin.ID);
        boolean defaultWin32SshHomeChanged = preferences.getBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", false);
        boolean existingWorkspace = true;
        if (!defaultWin32SshHomeChanged) {
            if (preferences.get("SSH2HOME", null) == null && SSH_OLD_WIN32_HOME_DEFAULT != null && new File(SSH_OLD_WIN32_HOME_DEFAULT).exists() && (SSH_HOME_DEFAULT == null || !new File(SSH_HOME_DEFAULT).exists() || existingWorkspace)) {
                preferences.put("SSH2HOME", SSH_OLD_WIN32_HOME_DEFAULT);
            }
            preferences.putBoolean("org.eclipse.jsch.core.hasChangedDefaultWin32SshHome", true);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                JSchCorePlugin.log((IStatus)new Status(1, JSchCorePlugin.ID, "Could not flush preferences.", (Throwable)e));
            }
        }
    }
}

