/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.css2.CSS2PrimitiveValueImpl;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontPropertiesImpl;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.swt.helpers.ThemeElementDefinitionHelper;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSSWTFontHelper {
    public static final String FONT_DEFINITION_MARKER = "#";
    private static final String DEFAULT_FONT = "defaultFont";

    public static CSS2FontProperties getCSS2FontProperties(Widget widget, Font font, CSSElementContext context) {
        CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)context);
        if (fontProperties == null) {
            fontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)fontProperties, (CSSElementContext)context);
        }
        return fontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Widget widget, CSSElementContext context) {
        return CSSSWTFontHelper.getCSS2FontProperties(CSSSWTFontHelper.getFont(widget), context);
    }

    public static CSS2FontProperties getCSS2FontProperties(Font font, CSSElementContext context) {
        CSS2FontProperties fontProperties = CSS2FontPropertiesHelpers.getCSS2FontProperties((CSSElementContext)context);
        if (fontProperties == null && font != null) {
            fontProperties = CSSSWTFontHelper.getCSS2FontProperties(font);
            CSS2FontPropertiesHelpers.setCSS2FontProperties((CSS2FontProperties)fontProperties, (CSSElementContext)context);
        }
        return fontProperties;
    }

    public static CSS2FontProperties getCSS2FontProperties(Font font) {
        CSS2FontPropertiesImpl fontProperties = new CSS2FontPropertiesImpl();
        if (font != null) {
            FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
            String fontFamily = CSSSWTFontHelper.getFontFamily(font);
            fontProperties.setFamily((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontFamily));
            int fontSize = fontData.getHeight();
            fontProperties.setSize((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontSize));
            String fontWeight = CSSSWTFontHelper.getFontWeight(font);
            fontProperties.setWeight((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontWeight));
            String fontStyle = CSSSWTFontHelper.getFontStyle(font);
            fontProperties.setStyle((CSSPrimitiveValue)new CSS2PrimitiveValueImpl(fontStyle));
        }
        return fontProperties;
    }

    public static Font getFont(CSS2FontProperties fontProperties, Control control) {
        FontData oldFontData = CSSSWTFontHelper.getFirstFontData(control.getFont());
        return CSSSWTFontHelper.getFont(fontProperties, oldFontData, control.getDisplay());
    }

    public static Font getFont(CSS2FontProperties fontProperties, FontData oldFontData, Display display) {
        FontData newFontData = CSSSWTFontHelper.getFontData(fontProperties, oldFontData);
        return new Font((Device)display, newFontData);
    }

    public static FontData getFontData(CSS2FontProperties fontProperties, FontData oldFontData) {
        boolean fontFamilySet;
        FontData newFontData = new FontData();
        CSSPrimitiveValue cssFontFamily = fontProperties.getFamily();
        FontData[] fontDataByDefinition = new FontData[]{};
        boolean fontDefinitionAsFamily = CSSSWTFontHelper.hasFontDefinitionAsFamily((CSSValue)fontProperties);
        if (fontDefinitionAsFamily) {
            fontDataByDefinition = CSSSWTFontHelper.findFontDataByDefinition(cssFontFamily);
            if (fontDataByDefinition.length > 0) {
                newFontData.setName(fontDataByDefinition[0].getName());
            }
        } else if (cssFontFamily != null) {
            newFontData.setName(cssFontFamily.getStringValue());
        }
        boolean bl = fontFamilySet = newFontData.getName() != null && newFontData.getName().trim().length() > 0;
        if (!fontFamilySet && oldFontData != null) {
            newFontData.setName(oldFontData.getName());
        }
        int style = CSSSWTFontHelper.getSWTStyle(fontProperties, oldFontData);
        if (fontDefinitionAsFamily && fontDataByDefinition.length > 0) {
            style |= fontDataByDefinition[0].getStyle();
        }
        newFontData.setStyle(style);
        CSSPrimitiveValue cssFontSize = fontProperties.getSize();
        boolean fontHeightSet = false;
        if (cssFontSize == null || cssFontSize.getCssText() == null) {
            if (fontDefinitionAsFamily && fontDataByDefinition.length > 0) {
                newFontData.setHeight(fontDataByDefinition[0].getHeight());
                fontHeightSet = true;
            }
        } else {
            newFontData.setHeight((int)cssFontSize.getFloatValue((short)9));
            fontHeightSet = true;
        }
        if (!fontHeightSet && oldFontData != null) {
            newFontData.setHeight(oldFontData.getHeight());
        }
        return newFontData;
    }

    public static boolean hasFontDefinitionAsFamily(CSSValue value) {
        if (value instanceof CSS2FontProperties) {
            CSS2FontProperties props = (CSS2FontProperties)value;
            return props.getFamily() != null && props.getFamily().getStringValue().startsWith(FONT_DEFINITION_MARKER);
        }
        return false;
    }

    private static FontData[] findFontDataByDefinition(CSSPrimitiveValue cssFontFamily) {
        FontData[] fontData;
        IColorAndFontProvider provider = CSSActivator.getDefault().getColorAndFontProvider();
        FontData[] result = new FontData[]{};
        if (provider != null && (fontData = provider.getFont(ThemeElementDefinitionHelper.normalizeId(cssFontFamily.getStringValue().substring(1)))) != null) {
            result = fontData;
        }
        return result;
    }

    public static int getSWTStyle(CSS2FontProperties fontProperties, FontData fontData) {
        CSSPrimitiveValue cssFontWeight;
        CSSPrimitiveValue cssFontStyle;
        int fontStyle = 0;
        if (fontData != null) {
            fontStyle = fontData.getStyle();
        }
        if ((cssFontStyle = fontProperties.getStyle()) != null) {
            String style = cssFontStyle.getStringValue();
            if ("italic".equals(style)) {
                fontStyle |= 2;
            } else if (fontStyle == (fontStyle | 2)) {
                fontStyle ^= 2;
            }
        }
        if ((cssFontWeight = fontProperties.getWeight()) != null) {
            String weight = cssFontWeight.getStringValue();
            if ("bold".equals(weight.toLowerCase())) {
                fontStyle |= 1;
            } else if (fontStyle == (fontStyle | 1)) {
                fontStyle ^= 1;
            }
        }
        return fontStyle;
    }

    public static String getFontFamily(Widget widget) {
        return CSSSWTFontHelper.getFontFamily(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontFamily(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontFamily(fontData);
    }

    public static String getFontFamily(FontData fontData) {
        if (fontData != null) {
            String family = fontData.getName();
            return CSS2FontHelper.getFontFamily((String)family);
        }
        return null;
    }

    public static String getFontSize(Widget widget) {
        return CSSSWTFontHelper.getFontSize(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontSize(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontSize(fontData);
    }

    public static String getFontSize(FontData fontData) {
        if (fontData != null) {
            return CSS2FontHelper.getFontSize((int)fontData.getHeight());
        }
        return null;
    }

    public static String getFontStyle(Widget widget) {
        return CSSSWTFontHelper.getFontStyle(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontStyle(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontStyle(fontData);
    }

    public static String getFontStyle(FontData fontData) {
        boolean isItalic = false;
        if (fontData != null) {
            isItalic = CSSSWTFontHelper.isItalic(fontData);
        }
        return CSS2FontHelper.getFontStyle((boolean)isItalic);
    }

    public static boolean isItalic(FontData fontData) {
        int fontStyle = fontData.getStyle();
        return (fontStyle | 2) == fontStyle;
    }

    public static String getFontWeight(Widget widget) {
        return CSSSWTFontHelper.getFontWeight(CSSSWTFontHelper.getFont(widget));
    }

    public static String getFontWeight(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontWeight(fontData);
    }

    public static String getFontWeight(FontData fontData) {
        boolean isBold = false;
        if (fontData != null) {
            isBold = CSSSWTFontHelper.isBold(fontData);
        }
        return CSS2FontHelper.getFontWeight((boolean)isBold);
    }

    public static boolean isBold(FontData fontData) {
        int fontStyle = fontData.getStyle();
        return (fontStyle | 1) == fontStyle;
    }

    public static String getFontComposite(Control control) {
        return CSSSWTFontHelper.getFontComposite(control.getFont());
    }

    public static String getFontComposite(Font font) {
        FontData fontData = CSSSWTFontHelper.getFirstFontData(font);
        return CSSSWTFontHelper.getFontComposite(fontData);
    }

    public static String getFontComposite(FontData fontData) {
        if (fontData != null) {
            StringBuilder composite = new StringBuilder();
            composite.append(CSSSWTFontHelper.getFontFamily(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontSize(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontWeight(fontData));
            composite.append(" ");
            composite.append(CSSSWTFontHelper.getFontStyle(fontData));
            return composite.toString();
        }
        return null;
    }

    public static FontData getFirstFontData(Control control) {
        Font font = control.getFont();
        if (font == null || font.isDisposed()) {
            return null;
        }
        return CSSSWTFontHelper.getFirstFontData(font);
    }

    public static FontData getFirstFontData(Font font) {
        FontData[] fontDatas;
        FontData[] fontDataArray = fontDatas = !font.isDisposed() ? font.getFontData() : null;
        if (fontDatas == null || fontDatas.length < 1) {
            return null;
        }
        return fontDatas[0];
    }

    private static Font getFont(Widget widget) {
        if (widget instanceof CTabItem) {
            return ((CTabItem)widget).getFont();
        }
        if (widget instanceof Control) {
            return ((Control)widget).getFont();
        }
        return null;
    }

    public static void storeDefaultFont(Control control) {
        CSSSWTFontHelper.storeDefaultFont((Widget)control, control.getFont());
    }

    public static void storeDefaultFont(CTabItem item) {
        CSSSWTFontHelper.storeDefaultFont((Widget)item, item.getFont());
    }

    private static void storeDefaultFont(Widget widget, Font font) {
        if (widget.getData(DEFAULT_FONT) == null) {
            widget.setData(DEFAULT_FONT, (Object)font);
        }
    }

    public static void restoreDefaultFont(Control control) {
        Font defaultFont = (Font)control.getData(DEFAULT_FONT);
        if (defaultFont != null) {
            if (defaultFont.isDisposed()) {
                defaultFont = control.getDisplay().getSystemFont();
            }
            if (!CSSSWTFontHelper.equals(defaultFont, control.getFont())) {
                control.setFont(defaultFont);
            }
        }
    }

    public static void restoreDefaultFont(CTabItem item) {
        Font defaultFont = (Font)item.getData(DEFAULT_FONT);
        if (defaultFont != null) {
            if (defaultFont.isDisposed()) {
                defaultFont = item.getDisplay().getSystemFont();
            }
            if (!CSSSWTFontHelper.equals(defaultFont, item.getFont())) {
                item.setFont(defaultFont);
            }
        }
    }

    public static void setFont(Control control, Font font) {
        if (!CSSSWTFontHelper.equals(control.getFont(), font)) {
            CSSSWTFontHelper.storeDefaultFont(control);
            control.setFont(font);
        }
    }

    public static void setFont(CTabItem item, Font font) {
        if (!CSSSWTFontHelper.equals(item.getFont(), font)) {
            CSSSWTFontHelper.storeDefaultFont(item);
            item.setFont(font);
        }
    }

    public static boolean equals(Font f1, Font f2) {
        FontData[] fd2;
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        if (f1.equals((Object)f2)) {
            return true;
        }
        FontData[] fd1 = f1.getFontData();
        if (fd1.length != (fd2 = f2.getFontData()).length) {
            return false;
        }
        int i = 0;
        while (i < fd1.length) {
            if (!fd1[i].equals((Object)fd2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

