/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.base;

import org.eclipse.nebula.cwt.animation.AnimationRunner;
import org.eclipse.nebula.cwt.animation.effects.Resize;
import org.eclipse.nebula.cwt.animation.movement.LinearInOut;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VButtonPainter;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VSimpleLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class BaseCombo
extends Canvas {
    protected static int SWT_MODAL_FIX_VERSION = 3346;
    protected static final boolean carbon = "carbon".equals(SWT.getPlatform());
    protected static final boolean gtk = "gtk".equals(SWT.getPlatform());
    protected static final boolean win32 = "win32".equals(SWT.getPlatform());
    protected static final boolean winxp = "win32".equals(SWT.getPlatform()) && "5.0".equals(System.getProperty("os.version"));
    protected static final boolean vista = "win32".equals(SWT.getPlatform()) && "6.0".equals(System.getProperty("os.version"));
    protected static final int textMarginHeight = win32 ? 4 : 0;
    protected static final int BUTTON_ONLY = 0;
    protected static final int BUTTON_ALWAYS = 1;
    protected static final int BUTTON_NEVER = 2;
    protected static final int BUTTON_AUTO = 3;
    protected VPanel panel = null;
    protected VButton button = null;
    protected boolean defaultButtonImage = true;
    protected VNative<Text> text = null;
    protected Shell contentShell = null;
    protected Control content;
    protected int style;
    protected boolean simple;
    protected boolean leftAlign = false;
    private int buttonVisibility;
    private Listener buttonVisibilityListener;
    private boolean dropDown;
    private boolean open = false;
    private boolean holdOpen = false;
    private VControl positionControl;
    private VControl stretchControl;
    private Listener textListener;
    private Listener shellListener;
    private Listener comboListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 10: {
                    if (!BaseCombo.this.isOpen()) break;
                    BaseCombo.this.setOpen(false);
                    break;
                }
                case 11: {
                    if (BaseCombo.this.isOpen()) {
                        BaseCombo.this.setOpen(false);
                    }
                    BaseCombo.this.layout(true);
                }
            }
        }
    };
    private Listener disposeListener = new Listener(){

        public void handleEvent(Event event) {
            if (!BaseCombo.this.isDisposed()) {
                BaseCombo.this.getShell().removeListener(27, BaseCombo.this.comboListener);
                if (BaseCombo.this.checkContentShell()) {
                    BaseCombo.this.contentShell.dispose();
                }
            }
        }
    };

    private static int checkStyle(int style) {
        int rstyle = 0;
        if ((style & 0x800) != 0 && (win32 || (style & 0x40) != 0)) {
            rstyle |= 0x800;
        }
        if (win32) {
            rstyle |= 0x20000000;
        }
        return rstyle;
    }

    protected static boolean containsControl(Control control, Composite composite) {
        if (composite != null && !composite.isDisposed()) {
            Control[] children;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!child.isDisposed()) {
                    if (child == control) {
                        return true;
                    }
                    if (child instanceof Composite) {
                        return BaseCombo.containsControl(control, (Composite)child);
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public BaseCombo(Composite parent, int style) {
        super(parent, BaseCombo.checkStyle(style));
        this.panel = new VPanel((Composite)this, 0);
        this.panel.setWidget((Composite)this);
        this.init(style);
    }

    protected void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.checkText()) {
            this.text.getControl().addModifyListener(listener);
        }
    }

    private void addTextListener() {
        this.text.getControl().addListener(1, this.textListener);
        this.text.getControl().addListener(24, this.textListener);
    }

    protected boolean checkButton() {
        return this.button != null && !this.button.isDisposed();
    }

    protected boolean checkContent() {
        return this.content != null && !this.content.isDisposed();
    }

    protected boolean checkContentShell() {
        return this.contentShell != null && !this.contentShell.isDisposed();
    }

    protected boolean checkText() {
        return this.text != null && !this.text.isDisposed();
    }

    private void createButton(int style) {
        int mask = 0x80000E;
        int buttonStyle = style & mask;
        this.button = new VButton(this.panel, buttonStyle | 0x80000);
        if (!false) {
            this.button.setMargins(0, 0);
        }
        this.button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BaseCombo.this.setOpen(!BaseCombo.this.isOpen());
            }
        });
        if (win32) {
            this.button.setPainter(new VButtonPainter(){

                public void paintBackground(VControl control, Event e) {
                    VButton button = (VButton)control;
                    if (button.hasState(2)) {
                        Rectangle r = button.getBounds();
                        e.gc.setBackground(e.display.getSystemColor(15));
                        e.gc.fillRoundRectangle(r.x, r.y, r.width - 1, r.height - 1, 2, 2);
                        e.gc.drawRoundRectangle(r.x, r.y, r.width - 1, r.height - 1, 2, 2);
                    }
                }
            });
        }
    }

    private void createContentShell() {
        this.contentShell = new Shell(this.getShell(), 16392);
        this.contentShell.addListener(21, this.shellListener);
        this.contentShell.addListener(27, this.shellListener);
    }

    private void createText(int style) {
        this.textListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.stateMask != 262144 || event.keyCode != 32) break;
                        event.doit = false;
                        BaseCombo.this.setOpen(true);
                        break;
                    }
                    case 24: {
                        Event e = new Event();
                        e.time = event.time;
                        BaseCombo.this.setModifyEventProperties(e);
                        BaseCombo.this.notifyListeners(24, e);
                    }
                }
            }
        };
        int mask = 147456;
        int textStyle = 4 | style & mask;
        if (!win32 && (style & 0x800) != 0) {
            textStyle |= 0x800;
        }
        this.text = VNative.create(Text.class, this.panel, textStyle);
        this.addTextListener();
    }

    protected final void doSetButtonImage(Image image) {
        if (this.checkButton()) {
            this.button.setImage(image);
        }
    }

    protected Control getContent() {
        return this.content;
    }

    protected Shell getContentShell() {
        if (this.contentShell == null) {
            this.createContentShell();
        }
        return this.contentShell;
    }

    public boolean getEditable() {
        return this.checkText() ? this.text.getControl().getEditable() : this.getEnabled();
    }

    public boolean getEnabled() {
        return this.checkText() ? this.text.getEnabled() : super.getEnabled();
    }

    protected boolean getHoldOpen() {
        return this.holdOpen;
    }

    public Menu getMenu() {
        if (this.checkText()) {
            return this.text.getMenu();
        }
        return super.getMenu();
    }

    protected VControl getStretchControl() {
        return this.stretchControl;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.checkText() ? this.text.getText() : "";
    }

    private void init(int style) {
        this.style = style;
        this.simple = (style & 0x40) != 0;
        this.dropDown = (style & 4) != 0;
        boolean bl = this.leftAlign = (style & 0x4000) != 0;
        if (this.simple) {
            this.panel.setLayout(new VSimpleLayout());
        } else if (this.dropDown) {
            this.createButton(style);
            if (!false) {
                this.createText(style);
                if (win32) {
                    this.setPositionControl(this.panel);
                } else {
                    this.setPositionControl(this.text);
                }
                this.panel.setLayout(new DropComboLayout());
            } else {
                this.setPositionControl(this.button);
                this.panel.setLayout(new VSimpleLayout());
            }
            this.shellListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 21: {
                            event.doit = false;
                            BaseCombo.this.setOpen(false);
                            break;
                        }
                        case 27: {
                            if (BaseCombo.this.checkContent() && BaseCombo.this.content.getMenu() != null && BaseCombo.this.content.getMenu().isVisible()) break;
                            BaseCombo.this.setOpen(false);
                        }
                    }
                }
            };
            this.addListener(10, this.comboListener);
            this.addListener(11, this.comboListener);
        } else {
            this.panel.setLayout(new VSimpleLayout());
            this.createText(style);
        }
        this.addListener(12, this.disposeListener);
    }

    protected boolean isDropDown() {
        return this.dropDown;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isRTL() {
        return (this.getShell().getStyle() & 0x4000000) == 0x4000000;
    }

    protected boolean isSimple() {
        return this.simple;
    }

    protected void postClose(Shell popup) {
    }

    protected void postOpen(Shell popup) {
    }

    protected void preClose(Shell popup) {
    }

    protected void preOpen(Shell popup) {
    }

    protected void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.checkText()) {
            this.text.getControl().removeModifyListener(listener);
        }
    }

    private void removeTextListener() {
        this.text.getControl().removeListener(1, this.textListener);
        this.text.getControl().removeListener(24, this.textListener);
    }

    protected void setButtonAlignment(int alignment) {
        if (16384 == alignment) {
            this.leftAlign = true;
        } else if (131072 == alignment) {
            this.leftAlign = false;
        }
        this.layout(true);
    }

    protected void setButtonImage(Image image) {
        this.doSetButtonImage(image);
    }

    protected void setButtonText(String text) {
        if (this.checkButton()) {
            this.button.setText(text);
        }
    }

    protected void setButtonVisibility(int visibility) {
        this.buttonVisibility = visibility;
        this.setButtonVisible(false);
        if (this.buttonVisibility == 3) {
            this.buttonVisibilityListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 15: {
                            BaseCombo.this.setButtonVisible(true);
                            break;
                        }
                        case 16: {
                            BaseCombo.this.setButtonVisible(false);
                        }
                    }
                }
            };
            this.addListener(15, this.buttonVisibilityListener);
            this.addListener(16, this.buttonVisibilityListener);
        } else if (this.buttonVisibilityListener != null) {
            this.removeListener(15, this.buttonVisibilityListener);
            this.removeListener(16, this.buttonVisibilityListener);
            this.buttonVisibilityListener = null;
        }
    }

    protected void setButtonVisible(boolean visible) {
        if (!this.checkButton()) {
            return;
        }
        if (1 == this.buttonVisibility) {
            visible = true;
        } else if (2 == this.buttonVisibility) {
            visible = false;
        }
        this.button.setVisible(visible);
        this.layout(true);
        this.update();
    }

    protected void setContent(Control content) {
        this.content = content;
        if (this.content != null && !this.simple) {
            this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        }
    }

    protected abstract boolean setContentFocus();

    public void setEditable(boolean editable) {
        this.panel.setStyle(8, !editable);
        if (this.checkButton()) {
            this.button.setEnabled(editable);
        }
        if (this.checkText() && editable != this.text.getControl().getEditable()) {
            this.text.getControl().setEditable(editable);
            if (editable) {
                this.addTextListener();
            } else {
                this.removeTextListener();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.panel.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.panel.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.checkButton()) {
            this.button.setFont(font);
        }
        if (this.checkText()) {
            this.text.setFont(font);
        }
        if (this.checkContent()) {
            this.content.setFont(font);
        }
    }

    protected void setHoldOpen(boolean holdOpen) {
        this.holdOpen = holdOpen;
    }

    public void setMenu(Menu menu) {
        if (this.checkText()) {
            this.text.getControl().setMenu(menu);
        } else {
            super.setMenu(menu);
        }
    }

    protected void setModifyEventProperties(Event e) {
    }

    protected void setOpen(boolean open) {
        this.setOpen(open, null);
    }

    protected synchronized void setOpen(boolean open, final Runnable callback) {
        if (this.isOpen() == open) {
            return;
        }
        if (this.content == null || this.content.isDisposed()) {
            if (this.contentShell != null) {
                this.contentShell.dispose();
                this.contentShell = null;
            }
            this.open = false;
            return;
        }
        if (this.contentShell == null || this.contentShell.isDisposed()) {
            this.createContentShell();
        }
        if (this.getShell() != this.contentShell.getParent()) {
            this.content.setParent((Composite)this);
            this.contentShell.dispose();
            this.contentShell = null;
            this.createContentShell();
        }
        if (this.content.getParent() != this.contentShell) {
            this.content.setParent((Composite)this.contentShell);
        }
        if (!open) {
            if (!this.holdOpen) {
                this.open = false;
                this.preClose(this.contentShell);
                Point start = this.contentShell.getSize();
                Point end = new Point(start.x, 0);
                Runnable runnable = new Runnable(){

                    public void run() {
                        BaseCombo.this.postClose(BaseCombo.this.contentShell);
                        if (callback != null) {
                            callback.run();
                        }
                    }
                };
                AnimationRunner runner = new AnimationRunner();
                runner.runEffect(new Resize((Control)this.contentShell, start, end, 200L, new LinearInOut(), runnable, runnable));
                if (this.checkText()) {
                    this.text.setFocus();
                }
            }
        } else {
            this.open = true;
            Point size = this.content.computeSize(-1, -1);
            this.content.setSize(size);
            Point location = this.positionControl.getComposite().toDisplay(this.positionControl.getLocation());
            location.y += this.positionControl.getSize().y + 2;
            int dHeight = this.positionControl.getControl().getMonitor().getClientArea().height;
            if (location.y + size.y > dHeight) {
                location.y -= this.positionControl.getSize().y + size.y + 4;
            }
            if (this.stretchControl != null && size.x < this.stretchControl.getSize().x) {
                size.x = this.stretchControl.getSize().x;
            }
            if (this.leftAlign || this.isRTL()) {
                location.x -= this.positionControl.getLocation().x;
                if (this.isRTL()) {
                    location.x -= this.getBounds().width;
                }
            } else {
                location.x += this.positionControl.getSize().x - size.x;
                Monitor monitor = this.positionControl.getControl().getMonitor();
                Rectangle monitorBounds = monitor.getBounds();
                location.x = Math.max(monitorBounds.x, location.x);
            }
            if (win32) {
                location.x += 2;
            } else if (carbon) {
                location.y += 8;
            }
            this.contentShell.setBounds(location.x, location.y, size.x, 0);
            this.preOpen(this.contentShell);
            Point start = new Point(size.x, 0);
            Point end = new Point(size.x, size.y);
            Runnable runnable = new Runnable(){

                public void run() {
                    BaseCombo.this.setContentFocus();
                    BaseCombo.this.postOpen(BaseCombo.this.contentShell);
                    if (callback != null) {
                        callback.run();
                    }
                }
            };
            this.contentShell.setVisible(true);
            AnimationRunner runner = new AnimationRunner();
            runner.runEffect(new Resize((Control)this.contentShell, start, end, 200L, new LinearInOut(), runnable, runnable));
            this.contentShell.setRedraw(true);
        }
        if (3 == this.buttonVisibility) {
            this.setButtonVisible(!open);
        }
    }

    protected void setPositionControl(VControl positionControl) {
        this.positionControl = positionControl == null ? this.panel : positionControl;
    }

    protected void setStretch(boolean stretch) {
        this.stretchControl = stretch ? this.panel : null;
    }

    public void setToolTipText(String tooltip) {
        this.text.setToolTipText(tooltip);
        this.button.setToolTipText(tooltip);
        super.setToolTipText(tooltip);
    }

    protected class DropComboLayout
    extends VLayout {
        protected DropComboLayout() {
        }

        protected Point computeSize(VPanel panel, int wHint, int hHint, boolean flushCache) {
            Point size = BaseCombo.this.text.computeSize(-1, -1);
            if (BaseCombo.this.button.getVisible()) {
                size.x += size.y;
            }
            size.y += textMarginHeight;
            if (wHint != -1) {
                size.x = Math.min(size.x, wHint);
            }
            if (hHint != -1) {
                size.y = Math.min(size.y, hHint);
            }
            return size;
        }

        protected void layout(VPanel panel, boolean flushCache) {
            Point bSize;
            Rectangle cRect = panel.getClientArea();
            Point tSize = BaseCombo.this.text.computeSize(-1, -1);
            tSize.y += textMarginHeight;
            Point point = bSize = BaseCombo.this.button.getVisible() ? new Point(tSize.y, tSize.y) : new Point(0, 0);
            if (BaseCombo.this.leftAlign) {
                BaseCombo.this.text.setBounds(cRect.x + bSize.x, cRect.y + (win32 ? BaseCombo.this.getBorderWidth() : 0), cRect.width - bSize.x, tSize.y);
                BaseCombo.this.button.setBounds(cRect.x, cRect.y, bSize.x, bSize.y);
            } else {
                BaseCombo.this.text.setBounds(cRect.x + (win32 ? 1 : 0), cRect.y + (win32 ? 1 : 0), cRect.width - bSize.x - (win32 ? 2 : 0), tSize.y - (win32 ? 2 : 0));
                BaseCombo.this.button.setBounds(win32 ? cRect.x + cRect.width - cRect.height + 1 : cRect.x + cRect.width - bSize.x, cRect.y, win32 ? cRect.height - 1 : bSize.x, win32 ? cRect.height : bSize.y);
            }
        }
    }
}

