/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class DragAndDropUtil {
    public static final String IGNORE_AS_DROP_TARGET = "ignore_as_drop_target";

    DragAndDropUtil() {
    }

    public static Rectangle getDisplayBounds(Control boundsControl) {
        Composite parent = boundsControl.getParent();
        if (parent == null || boundsControl instanceof Shell) {
            return boundsControl.getBounds();
        }
        return Geometry.toDisplay((Control)parent, (Rectangle)boundsControl.getBounds());
    }

    public static Control findControl(Display displayToSearch, Point locationToFind) {
        Shell[] shells = displayToSearch.getShells();
        return DragAndDropUtil.findControl((Control[])shells, locationToFind);
    }

    public static Control findControl(Control[] toSearch, Point locationToFind) {
        int idx = toSearch.length - 1;
        while (idx >= 0) {
            Rectangle bounds;
            Control next = toSearch[idx];
            if (next.getData(IGNORE_AS_DROP_TARGET) == null && !next.isDisposed() && next.isVisible() && (bounds = DragAndDropUtil.getDisplayBounds(next)).contains(locationToFind)) {
                Control result;
                if (next instanceof Composite && (result = DragAndDropUtil.findControl((Composite)next, locationToFind)) != null) {
                    return result;
                }
                return next;
            }
            --idx;
        }
        return null;
    }

    public static Control findControl(Composite toSearch, Point locationToFind) {
        Control[] children = toSearch.getChildren();
        return DragAndDropUtil.findControl(children, locationToFind);
    }
}

