/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.progress.AbstractProgressViewer;
import org.eclipse.ui.internal.progress.JobTreeElement;

public class ProgressCanvasViewer
extends AbstractProgressViewer {
    Canvas canvas;
    Object[] displayedItems = new Object[0];
    private FontMetrics fontMetrics;
    private int numShowItems = 1;
    private int maxCharacterWidth;
    private int orientation = 256;

    ProgressCanvasViewer(Composite parent, int style, int itemsToShow, int numChars, int orientation) {
        this.orientation = orientation;
        this.numShowItems = itemsToShow;
        this.maxCharacterWidth = numChars;
        this.canvas = new Canvas(parent, style);
        this.hookControl((Control)this.canvas);
        GC gc = new GC((Drawable)this.canvas);
        gc.setFont(JFaceResources.getDefaultFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.initializeListeners();
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(event -> this.handleDispose(event));
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.canvas.redraw();
    }

    protected List getSelectionFromWidget() {
        return Collections.EMPTY_LIST;
    }

    protected void internalRefresh(Object element) {
        this.displayedItems = this.getSortedChildren(this.getRoot());
        this.canvas.redraw();
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Control getControl() {
        return this.canvas;
    }

    private void initializeListeners() {
        this.canvas.addPaintListener(event -> {
            GC gc = event.gc;
            Transform transform = null;
            if (this.orientation == 512) {
                transform = new Transform((Device)event.display);
                transform.translate((float)TrimUtil.TRIM_DEFAULT_HEIGHT, 0.0f);
                transform.rotate(90.0f);
            }
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            int itemCount = Math.min(this.displayedItems.length, this.numShowItems);
            int yOffset = 0;
            int xOffset = 0;
            if (this.numShowItems == 1) {
                Rectangle clientArea = this.canvas.getParent().getClientArea();
                if (this.orientation == 256) {
                    int size1 = clientArea.height;
                    yOffset = size1 - this.fontMetrics.getHeight();
                    yOffset /= 2;
                } else {
                    int size2 = clientArea.width;
                    xOffset = size2 - this.fontMetrics.getHeight();
                    xOffset /= 2;
                }
            }
            int i = 0;
            while (i < itemCount) {
                String string = labelProvider.getText(this.displayedItems[i]);
                if (string == null) {
                    string = "";
                }
                if (this.orientation == 256) {
                    gc.drawString(string, 2, yOffset + i * this.fontMetrics.getHeight(), true);
                } else {
                    gc.setTransform(transform);
                    gc.drawString(string, xOffset + i * this.fontMetrics.getHeight(), 2, true);
                }
                ++i;
            }
            if (transform != null) {
                transform.dispose();
            }
        });
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public Point getSizeHints() {
        Display display = this.canvas.getDisplay();
        GC gc = new GC((Drawable)this.canvas);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int charHeight = fm.getHeight();
        int maxWidth = display.getBounds().width / 2;
        int maxHeight = display.getBounds().height / 6;
        int fontWidth = charWidth * this.maxCharacterWidth;
        int fontHeight = charHeight * this.numShowItems;
        if (maxWidth < fontWidth) {
            fontWidth = maxWidth;
        }
        if (maxHeight < fontHeight) {
            fontHeight = maxHeight;
        }
        gc.dispose();
        return new Point(fontWidth, fontHeight);
    }

    @Override
    public void add(JobTreeElement ... elements) {
        this.refresh(true);
    }

    @Override
    public void remove(JobTreeElement ... elements) {
        this.refresh(true);
    }
}

