/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.util.table;

import org.eclipse.oomph.internal.util.table.Cell;
import org.eclipse.oomph.internal.util.table.Range;

public interface Formula {
    public Object evaluate();

    public static class Avg
    implements Formula {
        private final Range range;

        public Avg(Range range) {
            this.range = range;
        }

        public Double evaluate() {
            double sum = 0.0;
            int count = 0;
            for (Cell cell : this.range) {
                Number number = cell.number();
                if (number == null) continue;
                sum += number.doubleValue();
                ++count;
            }
            if (count == 0) {
                ++count;
            }
            return sum / (double)count;
        }
    }

    public static class CountNumbers
    implements Formula {
        private final Range range;

        public CountNumbers(Range range) {
            this.range = range;
        }

        public Integer evaluate() {
            int count = 0;
            for (Cell cell : this.range) {
                Number number = cell.number();
                if (number == null) continue;
                ++count;
            }
            return count;
        }
    }

    public static class Max
    implements Formula {
        private final Range range;

        public Max(Range range) {
            this.range = range;
        }

        public Double evaluate() {
            double max = Double.MIN_VALUE;
            boolean empty = true;
            for (Cell cell : this.range) {
                Number number = cell.number();
                if (number == null) continue;
                max = Math.max(max, number.doubleValue());
                empty = false;
            }
            return empty ? null : Double.valueOf(max);
        }
    }

    public static class Min
    implements Formula {
        private final Range range;

        public Min(Range range) {
            this.range = range;
        }

        public Double evaluate() {
            double min = Double.MAX_VALUE;
            boolean empty = true;
            for (Cell cell : this.range) {
                Number number = cell.number();
                if (number == null) continue;
                min = Math.min(min, number.doubleValue());
                empty = false;
            }
            return empty ? null : Double.valueOf(min);
        }
    }

    public static class Percent
    extends Sum {
        private final Cell cell;

        public Percent(Range range, Cell cell) {
            super(range);
            this.cell = cell;
        }

        public Double evaluate() {
            Number number = this.cell.number();
            if (number == null) {
                return null;
            }
            double value = number.doubleValue();
            if (value == 0.0) {
                return value;
            }
            Double sum = super.evaluate();
            if (sum == null) {
                return null;
            }
            double EPSILON = 1.0E-5;
            if (sum >= -1.0E-5 && sum <= 1.0E-5) {
                return value < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return value / sum;
        }
    }

    public static class Sum
    implements Formula {
        private final Range range;

        public Sum(Range range) {
            this.range = range;
        }

        public Double evaluate() {
            double sum = 0.0;
            for (Cell cell : this.range) {
                Number number = cell.number();
                if (number == null) continue;
                sum += number.doubleValue();
            }
            return sum;
        }
    }
}

