/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.DynamicMenuContributionItem;
import org.eclipse.ui.internal.menus.DynamicToolBarContributionItem;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.menus.CommandContributionItem;

public class MenuAdditionCacheEntry {
    private static final String AFTER_ADDITIONS = "after=additions";
    static final String TRIM_COMMAND1 = "org.eclipse.ui.trim.command1";
    static final String TRIM_COMMAND2 = "org.eclipse.ui.trim.command2";
    static final String TRIM_VERTICAL1 = "org.eclipse.ui.trim.vertical1";
    static final String TRIM_VERTICAL2 = "org.eclipse.ui.trim.vertical2";
    static final String TRIM_STATUS = "org.eclipse.ui.trim.status";
    private MApplication application;
    private IConfigurationElement configElement;
    private MenuLocationURI location;
    private String namespaceIdentifier;
    private IActivityManager activityManager;
    private IdListener idUpdater = new IdListener();

    static boolean isInWorkbenchTrim(MenuLocationURI location) {
        String path = location.getPath();
        return "org.eclipse.ui.main.toolbar".equals(path) || TRIM_COMMAND1.equals(path) || TRIM_COMMAND2.equals(path) || TRIM_VERTICAL1.equals(path) || TRIM_VERTICAL2.equals(path) || TRIM_STATUS.equals(path);
    }

    public MenuAdditionCacheEntry(MApplication application, IEclipseContext appContext, IConfigurationElement configElement, String attribute, String namespaceIdentifier) {
        this.application = application;
        assert (appContext.equals(this.application.getContext()));
        this.configElement = configElement;
        this.location = new MenuLocationURI(attribute);
        this.namespaceIdentifier = namespaceIdentifier;
        IWorkbenchActivitySupport activitySupport = (IWorkbenchActivitySupport)application.getContext().get(IWorkbenchActivitySupport.class);
        this.activityManager = activitySupport.getActivityManager();
    }

    private boolean inToolbar() {
        return this.location.getScheme().startsWith("toolbar");
    }

    public void mergeIntoModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IConfigurationElement[] menus;
        boolean hasAdditions = false;
        if ("menu:help?after=additions".equals(this.location.toString()) && (menus = this.configElement.getChildren("menu")).length == 1 && "org.eclipse.update.ui.updateMenu".equals(MenuHelper.getId(menus[0]))) {
            return;
        }
        if (this.location.getPath() == null || this.location.getPath().isEmpty()) {
            WorkbenchPlugin.log("MenuAdditionCacheEntry.mergeIntoModel: Invalid menu URI: " + this.location);
            return;
        }
        if (this.inToolbar()) {
            if (MenuAdditionCacheEntry.isInWorkbenchTrim(this.location)) {
                this.processTrimChildren(trimContributions, toolBarContributions, this.configElement);
            } else {
                String query = this.location.getQuery();
                hasAdditions = AFTER_ADDITIONS.equals(query);
                if (query == null || query.isEmpty()) {
                    query = AFTER_ADDITIONS;
                }
                this.processToolbarChildren(toolBarContributions, this.configElement, this.location.getPath(), query, hasAdditions);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        menuContribution.getPersistedState().put("persistState", Boolean.FALSE.toString());
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(idContrib);
        }
        String query = this.location.getQuery();
        if ("org.eclipse.ui.popup.any".equals(this.location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(this.location.getPath());
            hasAdditions = AFTER_ADDITIONS.equals(query);
        }
        if (query == null || query.isEmpty()) {
            query = AFTER_ADDITIONS;
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + this.location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(this.location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(this.configElement));
        this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, this.configElement, filter);
        if (hasAdditions) {
            menuContributions.add(0, menuContribution);
        } else {
            menuContributions.add(menuContribution);
        }
        this.processMenuChildren(menuContributions, this.configElement, filter);
    }

    private void processMenuChildren(ArrayList<MMenuContribution> menuContributions, IConfigurationElement element, String filter) {
        IConfigurationElement[] menus = element.getChildren("menu");
        if (menus.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement menu = iConfigurationElementArray[n2];
            MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
            menuContribution.getPersistedState().put("persistState", Boolean.FALSE.toString());
            String idContrib = MenuHelper.getId(menu);
            if (idContrib != null && idContrib.length() > 0) {
                menuContribution.setElementId(idContrib);
            }
            menuContribution.setParentId(idContrib);
            menuContribution.setPositionInParent(AFTER_ADDITIONS);
            menuContribution.getTags().add("scheme:" + this.location.getScheme());
            menuContribution.getTags().add(filter);
            menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(menu));
            this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, menu, filter);
            menuContributions.add(menuContribution);
            this.processMenuChildren(menuContributions, menu, filter);
            ++n2;
        }
    }

    private void addMenuChildren(MElementContainer<MMenuElement> container, IConfigurationElement parent, String filter) {
        IConfigurationElement[] iConfigurationElementArray = parent.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement element;
            final IConfigurationElement child = iConfigurationElementArray[n2];
            String itemType = child.getName();
            String id = MenuHelper.getId(child);
            if ("command".equals(itemType)) {
                element = this.createMenuCommandAddition(child);
                container.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createMenuSeparatorAddition(child);
                container.getChildren().add(element);
            } else if ("menu".equals(itemType)) {
                element = this.createMenuAddition(child, filter);
                container.getChildren().add(element);
            } else if ("toolbar".equals(itemType)) {
                System.out.println("Toolbar: " + id + " in " + this.location);
            } else if ("dynamic".equals(itemType)) {
                ContextFunction generator = new ContextFunction(){

                    public Object compute(IEclipseContext context, String contextKey) {
                        ServiceLocator sl = new ServiceLocator();
                        sl.setContext(context);
                        return new DynamicMenuContributionItem(MenuHelper.getId(child), sl, child);
                    }
                };
                MMenuItem menuItem = RenderedElementUtil.createRenderedMenuItem();
                menuItem.setElementId(id);
                RenderedElementUtil.setContributionManager((MUIElement)menuItem, (Object)generator);
                menuItem.setVisibleWhen(MenuHelper.getVisibleWhen(child));
                container.getChildren().add(menuItem);
            }
            ++n2;
        }
    }

    private MMenuElement createMenuCommandAddition(IConfigurationElement commandAddition) {
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.getPersistedState().put("persistState", Boolean.FALSE.toString());
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconURI(commandAddition, "icon");
        if (iconUrl == null) {
            ImageDescriptor descriptor;
            ICommandImageService commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(commandId);
            if (descriptor == null) {
                ImageDescriptor imageDescriptor2 = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId());
            }
            if (descriptor != null) {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        item.setLabel(MenuHelper.getLabel(commandAddition));
        item.setMnemonics(MenuHelper.getMnemonic(commandAddition));
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        String helpContextId = MenuHelper.getHelpContextId(commandAddition);
        if (helpContextId != null) {
            item.getPersistedState().put("HelpContextId", helpContextId);
        }
        this.createIdentifierTracker((MApplicationElement)item);
        return item;
    }

    private void createIdentifierTracker(MApplicationElement item) {
        if (item.getElementId() != null && item.getElementId().length() > 0) {
            String id = String.valueOf(this.namespaceIdentifier) + "/" + item.getElementId();
            item.getPersistedState().put("IIdentifier", id);
            IIdentifier identifier = this.activityManager.getIdentifier(id);
            if (identifier != null) {
                this.application.getContext().set(identifier.getId(), (Object)identifier.isEnabled());
                identifier.addIdentifierListener(this.idUpdater);
            }
        }
    }

    private MMenuElement createMenuSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MMenuSeparator element = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        element.getPersistedState().put("persistState", Boolean.FALSE.toString());
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setVisible(false);
            element.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
        }
        return element;
    }

    private MMenu createMenuAddition(IConfigurationElement menuAddition, String filter) {
        if (this.inToolbar()) {
            return null;
        }
        MMenu menu = MenuHelper.createMenuAddition(menuAddition);
        menu.getTags().add(filter);
        return menu;
    }

    private boolean isUndefined(String query) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        int index = query.indexOf(61);
        return index == -1 || query.substring(index + 1).equals("additions");
    }

    private void processTrimLocation(MTrimContribution contribution) {
        String query = this.location.getQuery();
        if (TRIM_COMMAND2.equals(this.location.getPath())) {
            contribution.setParentId("org.eclipse.ui.main.toolbar");
            if (this.isUndefined(query)) {
                query = "endof";
            }
            contribution.setPositionInParent(query);
        } else {
            contribution.setParentId(this.location.getPath());
            if (query == null || query.isEmpty()) {
                query = AFTER_ADDITIONS;
            }
            contribution.setPositionInParent(query);
        }
    }

    private void processTrimChildren(ArrayList<MTrimContribution> trimContributions, ArrayList<MToolBarContribution> toolBarContributions, IConfigurationElement element) {
        IConfigurationElement[] toolbars = element.getChildren("toolbar");
        if (toolbars.length == 0) {
            return;
        }
        MTrimContribution trimContribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        trimContribution.getPersistedState().put("persistState", Boolean.FALSE.toString());
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            trimContribution.setElementId(idContrib);
        }
        String query = this.location.getQuery();
        boolean hasAdditions = AFTER_ADDITIONS.equals(query);
        this.processTrimLocation(trimContribution);
        trimContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] iConfigurationElementArray = toolbars;
        int n = toolbars.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolbar = iConfigurationElementArray[n2];
            MToolBar item = MenuFactoryImpl.eINSTANCE.createToolBar();
            item.getPersistedState().put("persistState", Boolean.FALSE.toString());
            item.setElementId(MenuHelper.getId(toolbar));
            item.getTransientData().put("Name", MenuHelper.getLabel(toolbar));
            this.processToolbarChildren(toolBarContributions, toolbar, item.getElementId(), AFTER_ADDITIONS, false);
            trimContribution.getChildren().add(item);
            ++n2;
        }
        if (hasAdditions) {
            trimContributions.add(0, trimContribution);
        } else {
            trimContributions.add(trimContribution);
        }
    }

    private void processToolbarChildren(ArrayList<MToolBarContribution> contributions, IConfigurationElement toolbar, String parentId, String position, boolean hasAdditions) {
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        toolBarContribution.getPersistedState().put("persistState", Boolean.FALSE.toString());
        String idContrib = MenuHelper.getId(toolbar);
        if (idContrib != null && idContrib.length() > 0) {
            toolBarContribution.setElementId(idContrib);
        }
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] iConfigurationElementArray = toolbar.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarElement element;
            final IConfigurationElement child = iConfigurationElementArray[n2];
            String itemType = child.getName();
            if ("command".equals(itemType)) {
                element = this.createToolBarCommandAddition(child);
                toolBarContribution.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createToolBarSeparatorAddition(child);
                toolBarContribution.getChildren().add(element);
            } else if ("control".equals(itemType)) {
                element = this.createToolControlAddition(child);
                toolBarContribution.getChildren().add(element);
            } else if ("dynamic".equals(itemType)) {
                ContextFunction generator = new ContextFunction(){

                    public Object compute(IEclipseContext context, String contextKey) {
                        ServiceLocator sl = new ServiceLocator();
                        sl.setContext(context);
                        return new DynamicToolBarContributionItem(MenuHelper.getId(child), sl, child);
                    }
                };
                MToolBarElement element2 = this.createToolDynamicAddition(child);
                RenderedElementUtil.setContributionManager((MUIElement)element2, (Object)generator);
                toolBarContribution.getChildren().add(element2);
            }
            ++n2;
        }
        if (hasAdditions) {
            contributions.add(0, toolBarContribution);
        } else {
            contributions.add(toolBarContribution);
        }
    }

    private MToolBarElement createToolDynamicAddition(IConfigurationElement element) {
        String id = MenuHelper.getId(element);
        MToolControl control = RenderedElementUtil.createRenderedToolBarElement();
        control.getPersistedState().put("persistState", Boolean.FALSE.toString());
        control.setElementId(id);
        control.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution");
        ControlContributionRegistry.add(id, element);
        control.setVisibleWhen(MenuHelper.getVisibleWhen(element));
        this.createIdentifierTracker((MApplicationElement)control);
        return control;
    }

    private MToolBarElement createToolControlAddition(IConfigurationElement element) {
        String id = MenuHelper.getId(element);
        MToolControl control = MenuFactoryImpl.eINSTANCE.createToolControl();
        control.getPersistedState().put("persistState", Boolean.FALSE.toString());
        control.setElementId(id);
        control.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution");
        ControlContributionRegistry.add(id, element);
        control.setVisibleWhen(MenuHelper.getVisibleWhen(element));
        this.createIdentifierTracker((MApplicationElement)control);
        return control;
    }

    private MToolBarElement createToolBarSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MToolBarSeparator element = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        element.getPersistedState().put("persistState", Boolean.FALSE.toString());
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setVisible(false);
            element.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
        }
        return element;
    }

    private MToolBarElement createToolBarCommandAddition(IConfigurationElement commandAddition) {
        ImageDescriptor descriptor;
        ICommandImageService commandImageService;
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        item.getPersistedState().put("persistState", Boolean.FALSE.toString());
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconURI(commandAddition, "icon");
        if (iconUrl == null) {
            commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(commandId, "toolbar");
            if (descriptor == null) {
                ImageDescriptor imageDescriptor2 = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId(), "toolbar");
                if (descriptor == null) {
                    item.setLabel(MenuHelper.getLabel(commandAddition));
                } else {
                    item.setIconURI(MenuHelper.getImageUrl(descriptor));
                }
            } else {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        iconUrl = MenuHelper.getIconURI(commandAddition, "disabledIcon");
        if (iconUrl == null && (commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class)) != null) {
            descriptor = commandImageService.getImageDescriptor(commandId, 1, "toolbar");
            if (descriptor == null) {
                descriptor = commandImageService.getImageDescriptor(item.getElementId(), 1, "toolbar");
            }
            if (descriptor != null) {
                iconUrl = MenuHelper.getImageUrl(descriptor);
            }
        }
        if (iconUrl != null) {
            MenuHelper.setDisabledIconURI((MToolItem)item, iconUrl);
        }
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        if (MenuHelper.hasPulldownStyle(commandAddition)) {
            MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
            String id = MenuHelper.getId(commandAddition);
            element.setElementId(id);
            item.setMenu(element);
        }
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        if (MenuHelper.getMode(commandAddition) == CommandContributionItem.MODE_FORCE_TEXT) {
            item.getTags().add("FORCE_TEXT");
            item.setLabel(MenuHelper.getLabel(commandAddition));
        }
        this.createIdentifierTracker((MApplicationElement)item);
        return item;
    }

    public String toString() {
        return "MenuAdditionCacheEntry [id=" + MenuHelper.getId(this.configElement) + ", namespaceId=" + this.namespaceIdentifier + ", location=" + this.location + "]";
    }

    private class IdListener
    implements IIdentifierListener {
        private IdListener() {
        }

        @Override
        public void identifierChanged(IdentifierEvent identifierEvent) {
            MenuAdditionCacheEntry.this.application.getContext().set(identifierEvent.getIdentifier().getId(), (Object)identifierEvent.getIdentifier().isEnabled());
        }
    }
}

