/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import java.util.function.Consumer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationDrawingStrategy;
import org.eclipse.jface.text.source.inlined.InlinedAnnotationSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;

public abstract class AbstractInlinedAnnotation
extends Annotation {
    public static final String TYPE = "org.eclipse.jface.text.source.inlined";
    private final Position position;
    private ISourceViewer fViewer;
    private InlinedAnnotationSupport support;
    int fX;
    int fY;

    protected AbstractInlinedAnnotation(Position position, ISourceViewer viewer) {
        super(TYPE, false, "");
        this.position = position;
        this.fViewer = viewer;
    }

    public Position getPosition() {
        return this.position;
    }

    final Position computeWidgetPosition() {
        if (this.fViewer instanceof ITextViewerExtension5) {
            IRegion region = ((ITextViewerExtension5)((Object)this.fViewer)).modelRange2WidgetRange((IRegion)new Region(this.position.getOffset(), this.position.getLength()));
            if (region != null) {
                return new Position(region.getOffset(), region.getLength());
            }
            return null;
        }
        return this.position;
    }

    public StyledText getTextWidget() {
        return this.fViewer.getTextWidget();
    }

    public ISourceViewer getViewer() {
        return this.fViewer;
    }

    public void redraw() {
        StyledText text = this.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        text.getDisplay().execute(() -> {
            if (text.isDisposed()) {
                return;
            }
            try {
                Position pos = this.getPosition();
                int offset = pos.getOffset();
                ISourceViewer viewer = this.getViewer();
                if (viewer instanceof ITextViewerExtension5) {
                    offset = ((ITextViewerExtension5)((Object)viewer)).modelOffset2WidgetOffset(offset);
                }
                InlinedAnnotationDrawingStrategy.draw(this, null, text, offset, pos.getLength(), null);
            }
            catch (RuntimeException runtimeException) {}
        });
    }

    public void draw(GC gc, StyledText textWidget, int widgetOffset, int length, Color color, int x, int y) {
        gc.setForeground(color);
        gc.setBackground(textWidget.getBackground());
        gc.drawString(this.getText(), x, y, true);
    }

    public void onMouseHover(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(styledText.getDisplay().getSystemCursor(21));
    }

    public void onMouseOut(MouseEvent e) {
        StyledText styledText = (StyledText)e.widget;
        styledText.setCursor(null);
    }

    public Consumer<MouseEvent> getAction(MouseEvent e) {
        return null;
    }

    void setSupport(InlinedAnnotationSupport support) {
        this.support = support;
    }

    protected boolean isInVisibleLines() {
        return this.support.isInVisibleLines(this.getPosition().getOffset());
    }

    boolean isFirstVisibleOffset(int widgetOffset) {
        if (this.fViewer instanceof ProjectionViewer) {
            IRegion widgetRange = ((ProjectionViewer)this.fViewer).modelRange2WidgetRange((IRegion)new Region(this.position.getOffset(), this.position.getLength()));
            return widgetOffset == widgetRange.getOffset();
        }
        return this.position.getOffset() == widgetOffset;
    }

    protected boolean isInVisibleLines(int offset) {
        return this.support.isInVisibleLines(offset);
    }

    Font getFont(int style) {
        return this.support.getFont(style);
    }

    void setLocation(int x, int y) {
        this.fX = x;
        this.fY = y;
    }

    boolean contains(int x, int y) {
        StyledText styledText = this.getTextWidget();
        GC gc = null;
        try {
            gc = new GC((Drawable)styledText);
            boolean bl = x >= this.fX && y >= this.fY && y <= this.fY + styledText.getLineHeight(this.position.getOffset()) && (double)x <= (double)(this.fX + gc.stringExtent((String)this.getText()).x) + 2.0 * gc.getFontMetrics().getAverageCharacterWidth();
            return bl;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }
}

